/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.usertransaction.begin;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jta.ee.common.Transact;
import java.io.Serializable;
import java.util.Properties;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class UserBeginClient
extends ServiceEETest
implements Serializable {
    private static final String testName = "jta.ee.usertransaction.begin";
    private UserTransaction userTransaction = null;

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            Transact.init();
            this.logTrace("Test environment initialized");
            this.userTransaction = (UserTransaction)Transact.nctx.lookup("java:comp/UserTransaction");
            if (this.userTransaction == null) {
                this.logErr("Unable to get User Transaction Instance : Could not proceed with tests");
                throw new Exception("couldnt proceed further");
            }
            if (this.userTransaction.getStatus() == 0) {
                this.userTransaction.rollback();
            }
        }
        catch (Exception exception) {
            this.logErr("Setup Failed!");
            this.logTrace("Unable to get User Transaction Instance : Could not proceed with tests");
            throw new EETest.Fault("Setup Failed", exception);
        }
    }

    public static void main(String[] args) {
        UserBeginClient userBeginClientInst = new UserBeginClient();
        Status s = userBeginClientInst.run(args, System.out, System.err);
        s.exit();
    }

    public void testUserBegin001() throws EETest.Fault {
        try {
            int beforeBegin = this.userTransaction.getStatus();
            if (beforeBegin != 6) {
                throw new EETest.Fault("Failed to return the status STATUS_NO_TRANSACTION");
            }
            this.logMsg("The Status of the UserTransaction is STATUS_NO_TRANSACTION");
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            int afterBegin = this.userTransaction.getStatus();
            if (afterBegin != 0) {
                throw new EETest.Fault("Failed to return the status STATUS_ACTIVE");
            }
            this.logMsg("The Status of the UserTransaction is STATUS_ACTIVE");
        }
        catch (IllegalStateException illegalState) {
            this.logErr("Exception " + illegalState.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", illegalState);
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new EETest.Fault("UnExpected Exception was caught: Failed", exception);
        }
    }

    public void testUserBegin002() throws EETest.Fault {
        try {
            this.userTransaction.begin();
            this.logMsg("UserTransaction Started");
            this.logMsg("Trying to start UserTransaction again");
            this.userTransaction.begin();
            throw new EETest.Fault("NotSupportedException was not thrown as Expected");
        }
        catch (NotSupportedException notSupported) {
            this.logMsg("Release Doesn't Support NESTED TRANSACTIONS");
            this.logMsg("NotSupportedException was caught as Expected !!");
        }
        catch (SystemException system) {
            this.logErr("Exception " + system.toString() + " was caught");
            throw new EETest.Fault("NotSupportedException was not thrown as Expected", system);
        }
        catch (Exception exception) {
            this.logErr("Exception " + exception.toString() + " was caught");
            throw new EETest.Fault("NotSupportedException was not thrown as Expected", exception);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            Transact.free();
            try {
                this.userTransaction.rollback();
            }
            catch (Exception exception) {
                throw new EETest.Fault(exception.getCause());
            }
            for (int retries = 1; this.userTransaction.getStatus() != 6 && retries <= 5; ++retries) {
                this.logMsg("cleanup(): retry # " + retries);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    throw new EETest.Fault(e.getCause());
                }
            }
            this.logMsg("Cleanup ok;");
        }
        catch (Exception exception) {
            this.logErr("Cleanup Failed", exception);
            this.logTrace("Could not clean the environment");
        }
    }
}

