/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.tx.common.session.cm;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.tx.common.session.cm.LocalTestBeanBase;
import com.sun.ts.tests.ejb30.tx.common.session.cm.TestIF;
import com.sun.ts.tests.ejb30.tx.common.session.cm.TxIF;
import javax.ejb.EJB;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public abstract class TestBeanBase
extends LocalTestBeanBase
implements TestIF {
    @EJB(name="txBean")
    protected TxIF txBean;

    protected void mandatoryTestOverloaded(TxIF b) throws TestFailedException {
        b.mandatoryTest("The tx attribute of mandatoryTest() must not apply to this method.");
    }

    protected void neverTestOverloaded(TxIF b) throws TestFailedException {
        String reason = "";
        UserTransaction ut = this.getEJBContext().getUserTransaction();
        try {
            ut.begin();
            b.neverTest("The tx attribute of neverTest() must not apply to this method");
        }
        catch (Exception e) {
            reason = "Unexpected exception: " + e;
            throw new TestFailedException(reason);
        }
        finally {
            try {
                ut.rollback();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void mandatoryTest() throws TestFailedException {
        String reason = "";
        try {
            this.txBean.mandatoryTest();
            reason = reason + "Expecting javax.ejb.EJBTransactionRequiredException, but got none";
            throw new TestFailedException(reason);
        }
        catch (EJBTransactionRequiredException e) {
            reason = reason + "Got expected javax.ejb.EJBTransactionRequiredException";
            Helper.getLogger().info(reason);
            this.mandatoryTestOverloaded(this.txBean);
            return;
        }
    }

    @Override
    public String supportsTest() throws TestFailedException {
        UserTransaction ut = this.getEJBContext().getUserTransaction();
        try {
            ut.begin();
            String string = this.txBean.supportsTest();
            return string;
        }
        catch (NotSupportedException e) {
            throw new TestFailedException(e);
        }
        catch (SystemException e) {
            throw new TestFailedException(e);
        }
        finally {
            try {
                ut.rollback();
            }
            catch (Exception ignore) {
                throw new TestFailedException(ignore);
            }
        }
    }

    @Override
    public String illegalGetSetRollbackOnlyNeverTest() throws TestFailedException {
        return this.txBean.illegalGetSetRollbackOnlyNeverTest();
    }

    @Override
    public String illegalGetSetRollbackOnlyNotSupportedTest() throws TestFailedException {
        UserTransaction ut = this.getEJBContext().getUserTransaction();
        try {
            ut.begin();
            String string = this.txBean.illegalGetSetRollbackOnlyNotSupportedTest();
            return string;
        }
        catch (NotSupportedException e) {
            throw new TestFailedException(e);
        }
        catch (SystemException e) {
            throw new TestFailedException(e);
        }
        finally {
            try {
                ut.rollback();
            }
            catch (Exception ignore) {
                throw new TestFailedException(ignore);
            }
        }
    }

    @Override
    public String systemExceptionTest() throws TestFailedException {
        String result = null;
        UserTransaction ut = this.getEJBContext().getUserTransaction();
        try {
            try {
                ut.begin();
                String s = this.txBean.systemExceptionTest();
                throw new TestFailedException("Expecting EJBTransactionRolledbackException, but got no exception.");
            }
            catch (NotSupportedException e) {
                throw new TestFailedException(e);
            }
            catch (SystemException e) {
                throw new TestFailedException(e);
            }
            catch (EJBTransactionRolledbackException e) {
                result = "Got expected EJBTransactionRolledbackException.";
                Integer status = null;
                try {
                    status = ut.getStatus();
                }
                catch (SystemException ex) {
                    throw new TestFailedException(result + " Failed to get tx status", ex);
                }
                if (status == 1) {
                    String string = result + " Got expected tx status " + status;
                    return string;
                }
                throw new TestFailedException(result + " but tx status is " + status);
            }
        }
        finally {
            try {
                ut.rollback();
            }
            catch (Exception ignore) {
                throw new TestFailedException(ignore);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void neverTest() throws TestFailedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void requiresNewTest() throws TestFailedException {
    }

    @Override
    public void sameMethodDifferentTxAttr() throws TestFailedException {
    }
}

