/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.ConnectionFactory;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Organization;

public class JAXRClient
extends JAXRCommonClient {
    private Properties props = null;
    protected Connection conn = null;
    protected ConnectionFactory factory = null;
    public String supr = "JAXRCommonClient";
    protected static final String JAXRPASSWORD = "jaxrPassword";
    protected static final String JAXRUSER = "jaxrUser";
    protected static final String JAXRPASSWORD2 = "jaxrPassword2";
    protected static final String JAXRUSER2 = "jaxrUser2";
    protected static final String QUERYMANAGERURL = "queryManagerURL";
    protected static final String REGISTRYURL = "registryURL";
    protected static final String JAXRALIAS = "jaxrAlias";
    protected static final String JAXRALIAS2 = "jaxrAlias2";
    protected static final String JAXRALIAS_PASSWORD = "jaxrAliasPassword";
    protected static final String JAXRALIAS2_PASSWORD = "jaxrAlias2Password";
    protected static final String JAXR_CONNECTIONFACTORY_LOOKUP = "jaxrConnectionFactoryLookup";
    protected static final int USE_JNDI = 0;
    protected static final int USE_NEWINSTANCE = 1;
    protected static final String JAXR_SECURITY_TYPE = "jaxrSecurityCredentialType";
    protected static final int USE_USERNAME_PASSWORD = 0;
    protected static final int USE_DIGITAL_CERTIFICATES = 1;
    int jaxrConnectionFactoryLookup;
    int jaxrSecurityCredentialType;
    protected String jaxrPassword;
    protected String jaxrUser;
    protected String jaxrPassword2;
    protected String jaxrUser2;
    protected String jaxrAlias;
    protected String jaxrAlias2;
    protected String registryURL;
    protected String queryManagerURL;
    protected String jaxrLookup;
    protected Collection tracer = null;
    protected RegistryService rs = null;
    protected BusinessLifeCycleManager blm = null;
    protected CapabilityProfile cp = null;
    protected int capabilityLevel;
    protected PasswordAuthentication passwdAuth = null;
    protected Collection debug = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.jaxrSecurityCredentialType = Integer.parseInt(p.getProperty(JAXR_SECURITY_TYPE));
            this.jaxrConnectionFactoryLookup = Integer.parseInt(p.getProperty(JAXR_CONNECTIONFACTORY_LOOKUP));
            this.jaxrUser = p.getProperty(JAXRUSER);
            this.jaxrPassword = p.getProperty(JAXRPASSWORD);
            this.jaxrUser2 = p.getProperty(JAXRUSER2);
            this.jaxrPassword2 = p.getProperty(JAXRPASSWORD2);
            this.jaxrAlias = p.getProperty(JAXRALIAS);
            this.jaxrAlias2 = p.getProperty(JAXRALIAS2);
            this.jaxrAliasPassword = p.getProperty(JAXRALIAS_PASSWORD);
            this.jaxrAlias2Password = p.getProperty(JAXRALIAS2_PASSWORD);
            this.queryManagerURL = p.getProperty(QUERYMANAGERURL);
            this.registryURL = p.getProperty(REGISTRYURL);
            this.authenticationMethod = p.getProperty("authenticationMethod");
            this.jaxrLookup = p.getProperty("jaxrJNDIResource");
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void connectionFactory_createConnectionFactoryTest() throws EETest.Fault {
        boolean pass = false;
        Object conn = null;
        ConnectionFactory factory = null;
        try {
            Properties props = new Properties();
            props.setProperty("javax.xml.registry.queryManagerURL", this.queryManagerURL);
            props.setProperty("javax.xml.registry.lifeCycleManagerURL", this.registryURL);
            props.setProperty("javax.xml.registry.security.authenticationMethod", this.authenticationMethod);
            factory = ConnectionFactory.newInstance();
            if (factory == null) {
                throw new EETest.Fault("ConnectionFactory.newInstance returned null");
            }
            if (factory instanceof ConnectionFactory) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("createConnectionFactoryTest failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("createConnectionFactoryTest failed");
        }
    }

    public void connectionFactory_createConnectionTest() throws EETest.Fault {
        boolean pass = false;
        Connection conn = null;
        ConnectionFactory factory = null;
        try {
            Properties props = new Properties();
            props.setProperty("javax.xml.registry.queryManagerURL", this.queryManagerURL);
            props.setProperty("javax.xml.registry.lifeCycleManagerURL", this.registryURL);
            props.setProperty("javax.xml.registry.security.authenticationMethod", this.authenticationMethod);
            factory = ConnectionFactory.newInstance();
            factory.setProperties(props);
            conn = factory.createConnection();
            if (conn == null) {
                throw new EETest.Fault("createConnection returned null");
            }
            if (conn instanceof Connection) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("createConnectionTest failed", e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                    TestUtil.printStackTrace((Throwable)e);
                    throw new EETest.Fault("Error in close connection in cleanup", e);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault("createConnectionTest failed");
        }
    }

    public void connectionFactory_propertiesTest() throws EETest.Fault {
        Object conn = null;
        ConnectionFactory factory = null;
        Properties retProperties = null;
        Properties props = null;
        String query = "javax.xml.registry.queryManagerURL";
        String lcm = "javax.xml.registry.lifeCycleManagerURL";
        try {
            props = new Properties();
            props.setProperty(query, this.queryManagerURL);
            props.setProperty(lcm, this.registryURL);
            factory = ConnectionFactory.newInstance();
            factory.setProperties(props);
            retProperties = factory.getProperties();
            TestUtil.logTrace((String)("getProperties returned: queryManagerURL = " + retProperties.getProperty(query) + " and \n lifeCycleManagerURL = " + retProperties.getProperty(lcm)));
            if (!retProperties.getProperty(query).equals(this.queryManagerURL) || !retProperties.getProperty(lcm).equals(this.registryURL)) {
                throw new EETest.Fault("unexpected results from getProperties");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("connectionFactory_propertiesTest failed", e);
        }
    }

    public void connectionFactory_createConnectionInvalidTest() throws EETest.Fault {
        boolean pass = false;
        Connection conn = null;
        ConnectionFactory factory = null;
        try {
            Properties props = new Properties();
            props.setProperty("javax.xml.registry.lifeCycleManagerURL", this.registryURL);
            props.setProperty("javax.xml.registry.security.authenticationMethod", this.authenticationMethod);
            factory = ConnectionFactory.newInstance();
            factory.setProperties(props);
            conn = factory.createConnection();
        }
        catch (InvalidRequestException ir) {
            TestUtil.printStackTrace((Throwable)ir);
            pass = true;
            TestUtil.logTrace((String)"InvalidRequestException was caught as expected!");
        }
        catch (Exception e) {
            TestUtil.logTrace((String)"Error: InvalidRequestException was NOT caught as expected!");
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("createConnectionTest failed", e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                    TestUtil.printStackTrace((Throwable)e);
                    throw new EETest.Fault("Error in close connection in cleanup", e);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault("createConnectionTest failed");
        }
    }

    public void connectionFactory_lifeCycleManagerPropertiesTest() throws EETest.Fault {
        Connection conn = null;
        ConnectionFactory factory = null;
        Object retProperties = null;
        Properties props = null;
        String query = "javax.xml.registry.queryManagerURL";
        String lcm = "javax.xml.registry.lifeCycleManagerURL";
        String orgName = "TS Default Organization";
        String testName = "connectionFactory_lifeCycleManagerPropertiesTest";
        if (this.queryManagerURL.equals(this.registryURL)) {
            try {
                props = new Properties();
                props.setProperty(query, this.queryManagerURL);
                props.setProperty("javax.xml.registry.security.authenticationMethod", this.authenticationMethod);
                switch (this.jaxrConnectionFactoryLookup) {
                    case 0: {
                        TSNamingContext nctx = null;
                        nctx = new TSNamingContext();
                        factory = (ConnectionFactory)nctx.lookup(this.jaxrLookup);
                        break;
                    }
                    case 1: {
                        factory = ConnectionFactory.newInstance();
                        break;
                    }
                    default: {
                        throw new EETest.Fault("setup failed: jaxrConnectionFactoryLookup is invalid");
                    }
                }
                factory.setProperties(props);
                conn = factory.createConnection();
                if (!(conn instanceof Connection)) {
                    this.logMsg("From JAXRCommonClient: Error did not get a connection object");
                }
                this.rs = conn.getRegistryService();
                Set credentials = null;
                switch (this.jaxrSecurityCredentialType) {
                    case 0: {
                        credentials = this.getUsernamePasswordCredentials();
                        break;
                    }
                    case 1: {
                        credentials = this.getDigitalCertificateCredentials(this.jaxrAlias, this.jaxrAliasPassword);
                        break;
                    }
                    default: {
                        throw new EETest.Fault("setup failed: jaxrSecurityCredentialType is invalid");
                    }
                }
                conn.setCredentials(credentials);
                try {
                    this.blm = this.rs.getBusinessLifeCycleManager();
                }
                catch (JAXRException je) {
                    TestUtil.printStackTrace((Throwable)je);
                }
                InternationalString iorgName = this.blm.createInternationalString(orgName);
                Organization org = this.blm.createOrganization(iorgName);
                ArrayList<Organization> orgs = new ArrayList<Organization>();
                orgs.add(org);
                BulkResponse br = this.blm.saveOrganizations(orgs);
                if (br.getExceptions() != null) {
                    TestUtil.logTrace((String)"== Exception returned from BulkResponse!!\n");
                    Collection ex = br.getExceptions();
                    for (JAXRException je : ex) {
                        TestUtil.logTrace((String)("== Detail Message for the JAXRException object: " + je.getMessage() + "\n"));
                    }
                    throw new EETest.Fault(testName + " due to saveOrganizations errors, test did not complete!");
                }
                Collection orgKeys = br.getCollection();
                if ((br = this.blm.deleteOrganizations(orgKeys)).getExceptions() != null) {
                    throw new EETest.Fault(testName + " due to deleteOrganizations errors, test cleanup not done!");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
                TestUtil.printStackTrace((Throwable)e);
                throw new EETest.Fault("connectionFactory_propertiesTest failed", e);
            }
        }
    }

    public void connectionFactory_propertiesMaxRowsTest() throws EETest.Fault {
        Object conn = null;
        ConnectionFactory factory = null;
        Properties retProperties = null;
        Properties props = null;
        String maxRows = "100";
        String maxRowsProp = "javax.xml.registry.uddi.maxRows";
        try {
            props = new Properties();
            props.setProperty(maxRowsProp, maxRows);
            factory = ConnectionFactory.newInstance();
            factory.setProperties(props);
            TestUtil.logTrace((String)("max rows set to " + maxRows));
            retProperties = factory.getProperties();
            TestUtil.logTrace((String)("getProperties returned: max Rows  = " + retProperties.getProperty(maxRowsProp)));
            if (!retProperties.getProperty(maxRowsProp).equals(maxRows)) {
                throw new EETest.Fault("max rows returned invalid");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("connectionFactory_propertiesTest failed", e);
        }
    }

    @Override
    public Set getUsernamePasswordCredentials() {
        HashSet<PasswordAuthentication> credentials = new HashSet<PasswordAuthentication>();
        this.passwdAuth = new PasswordAuthentication(this.jaxrUser, this.jaxrPassword.toCharArray());
        credentials.add(this.passwdAuth);
        return credentials;
    }
}

