/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.ejb.session.stateful.bean2beanmultijartest.bean2;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.ejb.session.stateful.bean2beanmultijartest.bean1.TestBean1;
import com.sun.ts.tests.interop.ejb.session.stateful.bean2beanmultijartest.bean1.TestBean1Home;
import java.io.Serializable;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.rmi.PortableRemoteObject;

public class TestBean2EJB
implements SessionBean {
    private static final String MyString = "message from bean2";
    private Handle MyHandle = null;
    private HomeHandle MyHomeHandle = null;
    private EJBMetaData MyEJBMetaData = null;
    private EJBObject myEJBObject = null;
    private EJBHome myEJBHome = null;
    private static final String ExpectedString = "message from bean1";
    private SessionContext sctx = null;
    private Properties harnessProps = null;

    public void ejbCreate(Properties p) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.harnessProps = p;
        try {
            TestUtil.logMsg((String)"initialize remote logging");
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    private void getInfo() throws EJBException {
        try {
            this.myEJBObject = this.sctx.getEJBObject();
            this.myEJBHome = this.myEJBObject.getEJBHome();
            this.MyHandle = this.myEJBObject.getHandle();
            this.MyHomeHandle = this.myEJBHome.getHomeHandle();
            this.MyEJBMetaData = this.myEJBHome.getEJBMetaData();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("EJBException: " + e);
        }
    }

    public String whoAmI() {
        return MyString;
    }

    public boolean passBean1String(String s) {
        TestUtil.logTrace((String)"passBean1String");
        TestUtil.logMsg((String)("received string: " + s));
        if (s == null) {
            TestUtil.logErr((String)"String passed in is null");
            return false;
        }
        if (s.equals(ExpectedString)) {
            TestUtil.logMsg((String)"String passed in is correct");
            return true;
        }
        TestUtil.logErr((String)"String passed in is not correct");
        return false;
    }

    public boolean passBean1Handle(Handle v) {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"passBean1Handle");
            TestUtil.logMsg((String)("received Handle: " + v));
            if (v == null) {
                TestUtil.logErr((String)"Handle passed in is null");
            } else if (!(v instanceof Serializable)) {
                TestUtil.logErr((String)"Handle passed in is not serializable");
            } else {
                TestUtil.logMsg((String)"Convert Handle to appropriate bean reference");
                EJBObject ejbObject = v.getEJBObject();
                TestBean1 bean1Ref = (TestBean1)PortableRemoteObject.narrow((Object)ejbObject, TestBean1.class);
                TestUtil.logMsg((String)"Check if we have correct bean reference");
                if (bean1Ref instanceof TestBean1) {
                    pass = true;
                    TestUtil.logMsg((String)"Correct bean reference (thus correct Handle)");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        return pass;
    }

    public boolean passBean1HomeHandle(HomeHandle v) {
        boolean pass = false;
        TestBean1Home bean1Home = null;
        try {
            TestUtil.logTrace((String)"passBean1HomeHandle");
            TestUtil.logMsg((String)("received HomeHandle: " + v));
            if (v == null) {
                TestUtil.logErr((String)"HomeHandle passed in is null");
            } else if (!(v instanceof Serializable)) {
                TestUtil.logErr((String)"HomeHandle passed in is not serializable");
            } else {
                TestUtil.logMsg((String)"Get HomeHandle & narrow to TestBean1Home");
                EJBHome ejbHome = v.getEJBHome();
                bean1Home = (TestBean1Home)PortableRemoteObject.narrow((Object)ejbHome, TestBean1Home.class);
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception in passBean1HomeHandle: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        return pass;
    }

    public boolean passBean1EJBMetaData(EJBMetaData v) {
        boolean pass = false;
        Object bean1Home = null;
        try {
            TestUtil.logTrace((String)"passBean1EJBMetaData");
            if (v == null) {
                TestUtil.logErr((String)"EJBMetaData returned is null");
            } else if (!(v instanceof Serializable)) {
                TestUtil.logErr((String)"EJBMetaData returned is not serializable");
            } else {
                TestUtil.logMsg((String)"Get the home interface class from EJBMetaData");
                Class cls = v.getHomeInterfaceClass();
                String clsName = cls.getName();
                TestUtil.logMsg((String)("The class name = " + clsName));
                if (clsName.endsWith("TestBean1Home")) {
                    pass = true;
                    TestUtil.logMsg((String)"Correct beanhome (thus correct EJBMetaData)");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        return pass;
    }

    public String returnBean2String() {
        TestUtil.logTrace((String)"returnBean2String");
        return MyString;
    }

    public Handle returnBean2Handle() {
        TestUtil.logTrace((String)"returnBean2Handle");
        this.getInfo();
        return this.MyHandle;
    }

    public HomeHandle returnBean2HomeHandle() {
        TestUtil.logTrace((String)"returnBean2HomeHandle");
        this.getInfo();
        return this.MyHomeHandle;
    }

    public EJBMetaData returnBean2EJBMetaData() {
        TestUtil.logTrace((String)"returnBean2EJBMetaData");
        this.getInfo();
        return this.MyEJBMetaData;
    }
}

