/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.ee.j2w.multiinterfacetest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.jaxrpc.ee.j2w.multiinterfacetest.MultiInterfaceTest1;
import com.sun.ts.tests.jaxrpc.ee.j2w.multiinterfacetest.MultiInterfaceTest2;
import java.net.URL;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.ee.j2w.multiinterfacetest.";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT1_URL = "multiinterfacetest.endpoint.1";
    private static final String ENDPOINT2_URL = "multiinterfacetest.endpoint.2";
    private static final String WSDLLOC_URL = "multiinterfacetest.wsdlloc.1";
    private static final String SERVICE_NAME = "multiinterfacetest.servicename.1";
    private static final String PORT_NAME1 = "multiinterfacetest.portname.1";
    private static final String PORT_NAME2 = "multiinterfacetest.portname.2";
    private String serviceName = null;
    private String portName1 = null;
    private String portName2 = null;
    private String url1 = null;
    private String url2 = null;
    private URL wsdlurl = null;
    String modeProperty = null;
    MultiInterfaceTest1 port1 = null;
    MultiInterfaceTest2 port2 = null;
    Stub stub1 = null;
    Stub stub2 = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT1_URL);
        this.url1 = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(ENDPOINT2_URL);
        this.url2 = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint1 URL: " + this.url1));
        TestUtil.logMsg((String)("Service Endpoint2 URL: " + this.url2));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getStubStandalone() throws Exception {
        this.serviceName = PKG_NAME + JAXRPC_Util.getURLFromProp(SERVICE_NAME);
        this.portName1 = JAXRPC_Util.getURLFromProp(PORT_NAME1);
        this.portName2 = JAXRPC_Util.getURLFromProp(PORT_NAME2);
        this.port1 = (MultiInterfaceTest1)JAXRPC_Util.getStub(this.serviceName, "get" + this.portName1);
        this.port2 = (MultiInterfaceTest2)JAXRPC_Util.getStub(this.serviceName, "get" + this.portName2);
        TestUtil.logMsg((String)"Cast stub to base Stub class ...");
        this.stub1 = (Stub)this.port1;
        this.stub2 = (Stub)this.port2;
    }

    private void getStub() throws Exception {
        try {
            InitialContext ic = new InitialContext();
            Service svc = (Service)ic.lookup("java:comp/env/service/multiinterfacetest");
            this.port1 = (MultiInterfaceTest1)svc.getPort(MultiInterfaceTest1.class);
            this.port2 = (MultiInterfaceTest2)svc.getPort(MultiInterfaceTest2.class);
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault(t.toString());
        }
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
                this.getStubStandalone();
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url1 + " ..."));
                this.stub1._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url1);
                TestUtil.logMsg((String)("Setting target endpoint to " + this.url2 + " ..."));
                this.stub2._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.url2);
            } else {
                this.getStub();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void multiinterfaceTest() throws EETest.Fault {
        TestUtil.logTrace((String)"multiinterfaceTest");
        boolean pass = true;
        TestUtil.logMsg((String)"Invoking method on interface 1 ...");
        if (this.multiinterface1Test()) {
            TestUtil.logMsg((String)"interface 1 test PASSED ...");
        } else {
            pass = false;
            TestUtil.logErr((String)"interface 1 test FAILED ...");
        }
        TestUtil.logMsg((String)"Invoking method on interface 2 ...");
        if (this.multiinterface2Test()) {
            TestUtil.logMsg((String)"interface 2 test PASSED ...");
        } else {
            pass = false;
            TestUtil.logErr((String)"interface 2 test FAILED ...");
        }
        if (!pass) {
            throw new EETest.Fault("multiinterfaceTest failed");
        }
    }

    public boolean inheritedinterfaceTest() throws EETest.Fault {
        TestUtil.logTrace((String)"inheritedinterfaceTest");
        boolean pass = true;
        String exp1 = "interface2:hello1:hello, world";
        String exp2 = "interface2:hello2:hello, world";
        try {
            String rec = this.port2.hello1("hello, world");
            TestUtil.logMsg((String)("Invoking RPC method port2.hello1(\"hello, world\")=" + rec));
            if (rec.equals(exp1)) {
                TestUtil.logMsg((String)("Result match - " + exp1));
            } else {
                TestUtil.logErr((String)("Result mismatch - expected: " + exp1 + ", received: " + rec));
                pass = false;
            }
            rec = this.port2.hello2("hello, world");
            TestUtil.logMsg((String)("Invoking RPC method port2.hello2(\"hello, world\")=" + rec));
            if (rec.equals(exp2)) {
                TestUtil.logMsg((String)("Result match - " + exp2));
            } else {
                TestUtil.logErr((String)("Result mismatch - expected: " + exp2 + ", received: " + rec));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("inheritedinterfaceTest failed");
        }
        return pass;
    }

    private boolean multiinterface1Test() throws EETest.Fault {
        TestUtil.logTrace((String)"multiinterface1Test");
        boolean pass = true;
        String exp = "interface1:hello1:hello, world";
        try {
            String rec = this.port1.hello1("hello, world");
            TestUtil.logMsg((String)("Invoking RPC method port1.hello1(\"hello, world\")=" + rec));
            if (rec.equals(exp)) {
                TestUtil.logMsg((String)("Result match - " + exp));
            } else {
                TestUtil.logErr((String)("Result mismatch - expected: " + exp + ", received: " + rec));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean multiinterface2Test() throws EETest.Fault {
        TestUtil.logTrace((String)"multiinterface2Test");
        boolean pass = true;
        String exp = "interface2:hello2:hello, world";
        try {
            String rec = this.port2.hello2("hello, world");
            TestUtil.logMsg((String)("Invoking RPC method port2.hello2(\"hello, world\")=" + rec));
            if (rec.equals(exp)) {
                TestUtil.logMsg((String)("Result match - " + exp));
            } else {
                TestUtil.logErr((String)("Result mismatch - expected: " + exp + ", received: " + rec));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

