/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContextErrorEntry
extends Entry {
    private long clientContextID;
    private int majorStatus;
    private int minorStatus;
    private byte[] errorToken;

    public ContextErrorEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("context-error")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("client-context-id")) {
                this.clientContextID = Long.parseLong(this.getText(node));
                continue;
            }
            if (node.getNodeName().equals("major-status")) {
                this.majorStatus = Integer.parseInt(this.getText(node));
                continue;
            }
            if (node.getNodeName().equals("minor-status")) {
                this.minorStatus = Integer.parseInt(this.getText(node));
                continue;
            }
            if (!node.getNodeName().equals("error-token")) continue;
            this.errorToken = ContextErrorEntry.parseBinHex(this.getText(node));
        }
    }

    public long getClientContextID() {
        return this.clientContextID;
    }

    public int getMajorStatus() {
        return this.majorStatus;
    }

    public int getMinorStatus() {
        return this.minorStatus;
    }

    public byte[] getErrorToken() {
        return this.errorToken;
    }

    public String toString() {
        String result = "<context-error>";
        result = result + "<client-context-id>" + this.clientContextID + "</client-context-id>\n";
        result = result + "<major-status>" + this.majorStatus + "</major-status>\n";
        result = result + "<minor-status>" + this.majorStatus + "</minor-status>\n";
        result = result + "<error-token>" + ContextErrorEntry.binHex(this.errorToken) + "</error-token>\n";
        result = result + "</context-error>\n";
        return result;
    }
}

