/*
 * Copyright (c) 2013, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.clientendpointonmessage;

import java.io.IOException;
import java.nio.ByteBuffer;

import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

import com.sun.ts.tests.websocket.common.client.AnnotatedStringClientEndpoint;
import com.sun.ts.tests.websocket.common.util.IOUtil;

@ClientEndpoint
public class WSByteBufferPartialClientEndpoint
    extends AnnotatedStringClientEndpoint {
  protected Session session;

  private StringBuilder sb = new StringBuilder();

  @OnMessage
  public void echo(ByteBuffer buf, boolean finito) throws IOException {
    sb.append(IOUtil.byteBufferToString(buf)).append("(").append(finito)
        .append(")");
    if (finito) {
      super.onMessage(sb.toString());
      session.getBasicRemote()
          .sendText(sb.toString().replaceAll("[(][a-z]*[)]", ""));
      sb = new StringBuilder();
    }
  }

  @OnError
  @Override
  public void onError(Session session, Throwable t) {
    this.session = session;
    super.onError(session, t);
  }

  @OnClose
  @Override
  public void onClose(Session session, CloseReason closeReason) {
    super.onClose(session, closeReason);
  }

  @OnOpen
  @Override
  public void onOpen(Session session, EndpointConfig config) {
    this.session = session;
    super.onOpen(session, config);
  }
}
