/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class SysEnv {
    private static String command;
    private static Map values;
    private static I18NResourceBundle i18n;

    public static void setCommand(String cmd) {
        command = cmd;
    }

    public static String get(String name) {
        if (values == null) {
            SysEnv.initValues();
        }
        return (String)values.get(name);
    }

    public static Map getAll() {
        return SysEnv.getAll(new HashMap());
    }

    public static Map getAll(Map m) {
        if (values == null) {
            SysEnv.initValues();
        }
        m.putAll(values);
        return m;
    }

    private static void initValues() {
        values = new HashMap();
        if (command == null) {
            command = SysEnv.getDefaultCommand();
        }
        if (command == null) {
            return;
        }
        try {
            String line;
            Process p = Runtime.getRuntime().exec(command);
            InputStream pin = p.getInputStream();
            DataInputStream in = new DataInputStream(new BufferedInputStream(pin));
            while ((line = in.readLine()) != null) {
                int eq = line.indexOf(61);
                if (eq == -1) continue;
                String name = line.substring(0, eq);
                String value = line.substring(eq + 1);
                values.put(name, value);
            }
            in.close();
            p.getErrorStream().close();
            p.getOutputStream().close();
        }
        catch (IOException e) {
            System.err.println(i18n.getString("sysEnv.err", e));
        }
    }

    private static String getDefaultCommand() {
        String prop = System.getProperty("javatest.sysEnv.command");
        if (prop != null) {
            return prop;
        }
        String osName = System.getProperty("os.name");
        if (osName.equalsIgnoreCase("SunOS") || osName.equalsIgnoreCase("Linux") || osName.equalsIgnoreCase("Mac OS X")) {
            return "/usr/bin/env";
        }
        if (osName.equalsIgnoreCase("Windows XP") || osName.equalsIgnoreCase("Windows 2000")) {
            return "cmd /c set";
        }
        if (osName.toLowerCase().startsWith("windows")) {
            return "cmd /c set";
        }
        return "env";
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(SysEnv.class);
    }
}

