/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunkartifacts.ConnectionHelper;
import com.ibm.jbatch.tck.artifacts.common.StatusConstants;
import jakarta.batch.api.listener.AbstractStepListener;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@Named(value="inventoryStepListener")
public class InventoryStepListener
extends AbstractStepListener
implements StatusConstants {
    private static final String sourceClass = InventoryStepListener.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    @Inject
    StepContext stepCtx;
    @Inject
    JobContext jobCtx;
    protected DataSource dataSource = null;

    private void init() throws NamingException {
        if (this.dataSource == null) {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup("java:module/env/jdbc/orderDB");
        }
    }

    public void afterStep() throws Exception {
        logger.fine("afterStep");
        int finalInventoryCount = this.getInventoryCount();
        int orderCount = this.getOrderCount();
        String initCheckpoint = String.valueOf((Integer)this.stepCtx.getTransientUserData());
        String exitStatus = "Inventory=" + finalInventoryCount + " InitialCheckpoint=" + initCheckpoint + " OrderCount=" + orderCount;
        this.jobCtx.setExitStatus(exitStatus);
    }

    private int getInventoryCount() throws Exception {
        int n;
        this.init();
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = ConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("select itemID, quantity from inventory where itemID = ?");
            statement.setInt(1, 1);
            rs = statement.executeQuery();
            int quantity = -1;
            while (rs.next()) {
                quantity = rs.getInt("quantity");
            }
            n = quantity;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanupConnection(connection, rs, statement);
                throw throwable;
            }
        }
        ConnectionHelper.cleanupConnection(connection, rs, statement);
        return n;
    }

    private int getOrderCount() throws Exception {
        int n;
        this.init();
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = ConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("select COUNT(*) AS rowcount from Orders");
            rs = statement.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt("rowcount");
            }
            n = count;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanupConnection(connection, rs, statement);
                throw throwable;
            }
        }
        ConnectionHelper.cleanupConnection(connection, rs, statement);
        return n;
    }

    public void beforeStep() {
    }
}

