/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.runtime.BatchStatus;
import java.util.Properties;

public class BatchletRestartStateMachineTests
extends ServiceEETest {
    private static JobOperatorBridge jobOp = null;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            BatchletRestartStateMachineTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public void cleanup() {
    }

    public void testTransitionElementOnAttrValuesWithRestartJobParamOverrides() throws EETest.Fault {
        String METHOD = "testTransitionElementOnAttrValuesWithRestartJobParamOverrides";
        TestUtil.logTrace((String)METHOD);
        String EXECUTION2_EXPECTED_EXIT_STATUS_FROM_JSL_ATTRIBUTE = "EXPECTED_FAILURE";
        try {
            TCKJobExecutionWrapper execution1 = null;
            TCKJobExecutionWrapper execution2 = null;
            TCKJobExecutionWrapper execution3 = null;
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            jobParams.setProperty("execution.number", "1");
            jobParams.setProperty("step1.stop", "ES.STEP1");
            jobParams.setProperty("step1.next", "ES.XXX");
            jobParams.setProperty("step2.fail", "ES.STEP2");
            jobParams.setProperty("step2.next", "ES.XXX");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            execution1 = jobOp.startJobAndWaitForResult("overrideOnAttributeValuesUponRestartBatchlet", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.STOPPED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "STOPPED", execution1.getExitStatus());
            TestUtil.logMsg((String)"Create job parameters for execution #2:");
            Properties restartJobParameters = new Properties();
            TestUtil.logMsg((String)"execution.number=2");
            TestUtil.logMsg((String)"step1.stop=ES.STOP");
            TestUtil.logMsg((String)"step1.next=ES.STEP1");
            restartJobParameters.setProperty("execution.number", "2");
            restartJobParameters.setProperty("step1.stop", "ES.STOP");
            restartJobParameters.setProperty("step1.next", "ES.STEP1");
            restartJobParameters.setProperty("step2.fail", "ES.STEP2");
            restartJobParameters.setProperty("step2.next", "ES.STEP2");
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with executionId: " + execution1.getExecutionId() + ""));
            execution2 = jobOp.restartJobAndWaitForResult(execution1.getExecutionId(), restartJobParameters);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + execution2.getBatchStatus()));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + execution2.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.FAILED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", EXECUTION2_EXPECTED_EXIT_STATUS_FROM_JSL_ATTRIBUTE, execution2.getExitStatus());
            TestUtil.logMsg((String)"Create job parameters for execution #3:");
            restartJobParameters = new Properties();
            TestUtil.logMsg((String)"execution.number=3");
            TestUtil.logMsg((String)"step1.stop=ES.STOP");
            TestUtil.logMsg((String)"step1.next=ES.STEP1");
            TestUtil.logMsg((String)"step2.fail=ES.FAIL");
            TestUtil.logMsg((String)"step2.next=ES.STEP2");
            restartJobParameters.setProperty("execution.number", "3");
            restartJobParameters.setProperty("step1.stop", "ES.STOP");
            restartJobParameters.setProperty("step1.next", "ES.STEP1");
            restartJobParameters.setProperty("step2.fail", "ES.FAIL");
            restartJobParameters.setProperty("step2.next", "ES.STEP2");
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with executionId: " + execution2.getExecutionId() + ""));
            execution3 = jobOp.restartJobAndWaitForResult(execution2.getExecutionId(), restartJobParameters);
            TestUtil.logMsg((String)("execution #3 JobExecution getBatchStatus()=" + execution3.getBatchStatus()));
            TestUtil.logMsg((String)("execution #3 JobExecution getExitStatus()=" + execution3.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #3", BatchStatus.COMPLETED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #3", "COMPLETED", execution3.getExitStatus());
        }
        catch (Exception e) {
            BatchletRestartStateMachineTests.handleException(METHOD, e);
        }
    }

    public void testAllowStartIfCompleteRestartExecution() throws EETest.Fault {
        String METHOD = "testAllowStartIfCompleteRestartExecution";
        TestUtil.logTrace((String)METHOD);
        try {
            long lastExecutionId = 0L;
            TCKJobExecutionWrapper exec = null;
            for (int i = 1; i <= 6; ++i) {
                String execString = new Integer(i).toString();
                Properties jobParameters = new Properties();
                jobParameters.put("execution.number", execString);
                if (i == 1) {
                    TestUtil.logMsg((String)"Invoking startJobAndWaitForResult for Execution #1");
                    exec = jobOp.startJobAndWaitForResult("batchletRestartStateMachine", jobParameters);
                } else {
                    TestUtil.logMsg((String)"Invoke restartJobAndWaitForResult");
                    exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParameters);
                }
                lastExecutionId = exec.getExecutionId();
                TestUtil.logMsg((String)("Execution #" + i + " JobExecution getBatchStatus()=" + exec.getBatchStatus()));
                TestUtil.logMsg((String)("Execution #" + i + " JobExecution getExitStatus()=" + exec.getExitStatus()));
                if (i == 6) {
                    AssertionUtils.assertWithMessage("Testing execution #" + i, BatchStatus.COMPLETED, exec.getBatchStatus());
                } else {
                    AssertionUtils.assertWithMessage("Testing execution #" + i, BatchStatus.STOPPED, exec.getBatchStatus());
                }
                AssertionUtils.assertWithMessage("Testing execution #" + i, "EXECUTION." + execString, exec.getExitStatus());
            }
        }
        catch (Exception e) {
            BatchletRestartStateMachineTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }
}

