/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.util.Properties;

public class PropertySubstitutionTests
extends ServiceEETest {
    private static JobOperatorBridge jobOp;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public static void tearDown() throws EETest.Fault {
    }

    public void cleanup() throws EETest.Fault {
        System.clearProperty("property.junit.result");
    }

    public void testBatchArtifactPropertyInjection() throws EETest.Fault {
        String METHOD = "testBatchArtifactPropertyInjection";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_properties2.xml");
            TestUtil.logMsg((String)"Set system property: property.junit.propName=myProperty1");
            System.setProperty("property.junit.propName", "myProperty1");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            TestUtil.logMsg((String)("Test result: " + result + ""));
            AssertionUtils.assertObjEquals("value1", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    public void testInitializedPropertyIsOverwritten() throws EETest.Fault {
        String METHOD = "testInitializedPropertyIsOverwritten";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_properties2.xml");
            TestUtil.logMsg((String)"Set system property: property.junit.propName=myProperty2");
            System.setProperty("property.junit.propName", "myProperty2");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            TestUtil.logMsg((String)("Test result: " + result + ""));
            AssertionUtils.assertObjEquals("value2", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    public void testPropertyWithJobParameter() throws EETest.Fault {
        String METHOD = "testPropertyWithJobParameter";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_properties2.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParameters = new Properties();
            String expectedResult = "mySubmittedValue";
            TestUtil.logMsg((String)("mySubmittedPropr=" + expectedResult + ""));
            jobParameters.setProperty("mySubmittedProp", expectedResult);
            TestUtil.logMsg((String)"Set system property: property.junit.propName=mySubmittedProp");
            System.setProperty("property.junit.propName", "mySubmittedProp");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2", jobParameters);
            String result = System.getProperty("property.junit.result");
            TestUtil.logMsg((String)("Test result: " + result + ""));
            AssertionUtils.assertObjEquals(expectedResult, result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    public void testDefaultPropertyName() throws EETest.Fault {
        String METHOD = "testDefaultPropertyName";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_properties2.xml");
            TestUtil.logMsg((String)"Set system property:property.junit.propName=property4");
            System.setProperty("property.junit.propName", "property4");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            TestUtil.logMsg((String)("Test result: " + result + ""));
            AssertionUtils.assertObjEquals("value4", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    public void testGivenPropertyName() throws EETest.Fault {
        String METHOD = "testGivenPropertyName";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_properties2.xml");
            TestUtil.logMsg((String)"Set system property:property.junit.propName=myProperty4");
            System.setProperty("property.junit.propName", "myProperty4");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            TestUtil.logMsg((String)("Test result: " + result + ""));
            AssertionUtils.assertObjEquals("value4", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    public void testPropertyInnerScopePrecedence() throws EETest.Fault {
        String METHOD = "testPropertyInnerScopePrecedence";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_properties2.xml");
            TestUtil.logMsg((String)"Set system property:property.junit.propName=batchletProp");
            System.setProperty("property.junit.propName", "batchletProp");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            TestUtil.logMsg((String)("Test result: " + result + ""));
            AssertionUtils.assertObjEquals("batchletPropValue", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    public void testPropertyQuestionMarkSimple() throws EETest.Fault {
        String METHOD = "testPropertyQuestionMarkSimple";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_properties2.xml");
            TestUtil.logMsg((String)"Set system property:property.junit.propName=defaultPropName1");
            System.setProperty("property.junit.propName", "defaultPropName1");
            TestUtil.logMsg((String)"Set system property:file.name.junit=myfile1.txt");
            System.setProperty("file.name.junit", "myfile1.txt");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            TestUtil.logMsg((String)("Test result: " + result + ""));
            AssertionUtils.assertObjEquals("myfile1.txt", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    public void testPropertyQuestionMarkComplex() throws EETest.Fault {
        String METHOD = "testPropertyQuestionMarkComplex";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_properties2.xml");
            TestUtil.logMsg((String)"Set system property:property.junit.propName=defaultPropName2");
            System.setProperty("property.junit.propName", "defaultPropName2");
            TestUtil.logMsg((String)"Set system property:file.name.junit=myfile2.txt");
            System.setProperty("file.name.junit", "myfile2");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2");
            String result = System.getProperty("property.junit.result");
            TestUtil.logMsg((String)("Test result: " + result + ""));
            AssertionUtils.assertObjEquals(File.separator + "myfile2.txt", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    public void testPropertyWithConcatenation() throws EETest.Fault {
        String METHOD = "testPropertyWithConcatenation";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_properties2.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"myFilename=testfile1");
            jobParameters.setProperty("myFilename", "testfile1");
            TestUtil.logMsg((String)"Set system property:file.name.junit=myConcatProp");
            System.setProperty("property.junit.propName", "myConcatProp");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2", jobParameters);
            String result = System.getProperty("property.junit.result");
            TestUtil.logMsg((String)("Test result: " + result + ""));
            AssertionUtils.assertObjEquals("testfile1.txt", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    public void testJavaSystemProperty() throws EETest.Fault {
        String METHOD = "testJavaSystemProperty";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_properties2.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"myFilename=testfile2");
            jobParameters.setProperty("myFilename", "testfile2");
            TestUtil.logMsg((String)"Set system property:file.name.junit=myJavaSystemProp");
            System.setProperty("property.junit.propName", "myJavaSystemProp");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_properties2", jobParameters);
            String result = System.getProperty("property.junit.result");
            String pathSep = System.getProperty("file.separator");
            TestUtil.logMsg((String)("Test result: " + pathSep + "test" + pathSep + "testfile2.txt"));
            AssertionUtils.assertObjEquals(pathSep + "test" + pathSep + "testfile2.txt", result);
        }
        catch (Exception e) {
            PropertySubstitutionTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }
}

