/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest.LoopBack;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest.LoopBackHome;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest.LoopBackLocal;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest.LoopBackLocalHome;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest.TestBeanLocal;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import java.rmi.RemoteException;
import java.util.Properties;

public class TestBeanEJB
implements SessionBean {
    private SessionContext sctx = null;
    private static final String beanName = "java:comp/env/ejb/LoopBack";
    private static final String beanName2 = "java:comp/env/ejb/LoopBackLocal";

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ping() {
        TestUtil.logTrace((String)"ping");
    }

    public void sleep(int n) {
        long t2;
        TestUtil.logTrace((String)"sleep");
        long t1 = System.currentTimeMillis();
        while ((t2 = System.currentTimeMillis()) < t1 + (long)n) {
        }
    }

    public boolean loopBackSameBean() {
        boolean pass;
        TestUtil.logTrace((String)"loopBackSameBean");
        TestUtil.logMsg((String)"perform loopback test");
        try {
            TestUtil.logMsg((String)"getEJBObject reference");
            TestBean ref = (TestBean)this.sctx.getEJBObject();
            TestUtil.logMsg((String)"Performing self-referential loopback call test");
            ref.ping();
            TestUtil.logMsg((String)"No exception occurred during loopback call");
            pass = true;
        }
        catch (RemoteException e) {
            TestUtil.logErr((String)("Caught RemoteException - unexpected: " + e), (Throwable)e);
            pass = false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean loopBackSameBeanLocal() {
        boolean pass;
        TestUtil.logTrace((String)"loopBackSameBean");
        TestUtil.logMsg((String)"perform loopback test");
        try {
            TestUtil.logMsg((String)"getEJBObject reference");
            TestBeanLocal ref = (TestBeanLocal)this.sctx.getEJBLocalObject();
            TestUtil.logMsg((String)"Performing self-referential loopback call test");
            ref.ping();
            TestUtil.logErr((String)"No exception occurred during loopback call");
            pass = true;
        }
        catch (EJBException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Caught EJBException - unexpected: " + (Object)((Object)e)));
            pass = false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean loopBackAnotherBean(Properties p) {
        boolean pass;
        TestUtil.logTrace((String)"loopBackAnotherBean");
        try {
            TestUtil.logMsg((String)"lookup home interface for EJB: java:comp/env/ejb/LoopBack");
            LoopBackHome beanHome = (LoopBackHome)this.lookup(beanName, LoopBackHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            LoopBack beanRef = beanHome.create((TestBean)this.sctx.getEJBObject());
            TestUtil.logMsg((String)"initialize remote logging");
            beanRef.initLogging(p);
            TestUtil.logMsg((String)"Performing loopback call test");
            pass = beanRef.loopBackTest();
            beanRef.remove();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean loopBackAnotherBeanLocal() {
        boolean pass;
        TestUtil.logTrace((String)"loopBackAnotherBean");
        try {
            TestUtil.logMsg((String)"lookup home interface for EJB: java:comp/env/ejb/LoopBack");
            LoopBackLocalHome beanLocalHome = (LoopBackLocalHome)this.lookup(beanName2, LoopBackLocalHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            LoopBackLocal beanLocalRef = beanLocalHome.create((TestBeanLocal)this.sctx.getEJBLocalObject());
            TestUtil.logMsg((String)"Performing loopback call test");
            pass = beanLocalRef.loopBackTestLocal();
            beanLocalRef.remove();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private Object lookup(String s, Class c) {
        TSNamingContext nctx = null;
        try {
            TestUtil.logMsg((String)"obtain naming context");
            nctx = new TSNamingContext();
            if (c != null) {
                return nctx.lookup(s, c);
            }
            return nctx.lookup(s);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("lookup failed: " + e);
        }
    }
}

