/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.messageTopic;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;

public class MessageTopicTest
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.messageTopic.MessageTopicTest";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        MessageTopicTest theTests = new MessageTopicTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void msgClearBodyTopicTest() throws EETest.Fault {
        boolean pass = true;
        byte bValue = 127;
        byte bValue2 = 22;
        Object id = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logTrace("Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.tool.getDefaultTopicSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"Initial message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgClearBodyTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            try {
                this.logTrace("Testing Object message");
                this.logTrace("read 1st contents");
                this.logTrace("  " + messageReceivedObjectMsg.getObject());
                this.logTrace("Call to clearBody !!!!!!!!!!!!!!!");
                messageReceivedObjectMsg.clearBody();
                if (messageReceivedObjectMsg.getObject() == null) {
                    this.logTrace("Empty body after clearBody as expected: null");
                } else {
                    this.logTrace("Fail: message body was not empty");
                    pass = false;
                }
                if (messageSentObjectMsg.getStringProperty("COM_SUN_JMS_TESTNAME").equals("msgClearBodyTopicTest")) {
                    this.logTrace("Pass: Object properties read ok after clearBody called");
                } else {
                    this.logErr("Fail: Object properties cleared after clearBody called");
                    pass = false;
                }
                this.logTrace("write 2nd contents");
                messageReceivedObjectMsg.setObject((Serializable)((Object)"new stuff here!!!!!!"));
                this.logTrace("read 2nd contents");
                if (messageReceivedObjectMsg.getObject().equals("new stuff here!!!!!!")) {
                    this.logTrace("Pass:");
                } else {
                    this.logErr("Fail: ");
                    pass = false;
                }
            }
            catch (Exception e) {
                this.logErr("Error: unexpected exception: ", e);
                pass = false;
            }
            this.logTrace("Send MapMessage to Topic.");
            messageSentMapMessage = this.tool.getDefaultTopicSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgClearBodyTopicTest");
            messageSentMapMessage.setString("aString", "Initial message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            try {
                this.logTrace("Test for MapMessage ");
                this.logTrace("read 1st contents");
                this.logTrace("  " + messageReceivedMapMessage.getString("aString"));
                this.logTrace("Call to clearBody !!!!!!!!!!!!!!!");
                messageReceivedMapMessage.clearBody();
                if (messageReceivedMapMessage.getString("aString") == null) {
                    this.logTrace("Empty body after clearBody as expected: null");
                } else {
                    this.logTrace("Fail: message body was not empty");
                    pass = false;
                }
                if (messageReceivedMapMessage.getStringProperty("COM_SUN_JMS_TESTNAME").equals("msgClearBodyTopicTest")) {
                    this.logTrace("Pass: Map properties read ok after clearBody called");
                } else {
                    this.logErr("Fail: Map properties cleared after clearBody called");
                    pass = false;
                }
                this.logTrace("write 2nd contents");
                messageReceivedMapMessage.setString("yes", "new stuff !!!!!");
                this.logTrace("read 2nd contents");
                if (messageReceivedMapMessage.getString("yes").equals("new stuff !!!!!")) {
                    this.logTrace("PASS:");
                } else {
                    this.logErr("FAIL:");
                    pass = false;
                }
            }
            catch (Exception e) {
                this.logErr("Error: unexpected exception: ", e);
                pass = false;
            }
            this.logTrace("Send BytesMessage to Topic.");
            messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgClearBodyTopicTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            try {
                this.logTrace("Test BytesMessage ");
                this.logTrace("read 1st contents");
                this.logTrace("  " + messageReceivedBytesMessage.readByte());
                this.logTrace("Call to clearBody !!!!!!!!!!!!!!!");
                messageReceivedBytesMessage.clearBody();
                this.logTrace("Bytes message body should now be empty and in writeonly mode");
                try {
                    byte b = messageReceivedBytesMessage.readByte();
                    this.logErr("Fail: MessageNotReadableException not thrown as expected");
                    pass = false;
                }
                catch (MessageNotReadableException e) {
                    this.logTrace("Pass: MessageNotReadableException thrown as expected");
                }
                catch (Exception ee) {
                    this.logErr("Error: Unexpected exception: ", ee);
                    pass = false;
                }
                if (messageReceivedBytesMessage.getStringProperty("COM_SUN_JMS_TESTNAME").equals("msgClearBodyTopicTest")) {
                    this.logTrace("Pass: Bytes msg properties read ok after clearBody called");
                } else {
                    this.logErr("Fail: Bytes msg properties cleared after clearBody called");
                    pass = false;
                }
                this.logTrace("write 2nd contents");
                messageReceivedBytesMessage.writeByte(bValue2);
                this.logTrace("read 2nd contents");
                messageReceivedBytesMessage.reset();
                if (messageReceivedBytesMessage.readByte() == bValue2) {
                    this.logTrace("Pass:");
                } else {
                    this.logErr("Fail:");
                    pass = false;
                }
            }
            catch (Exception e) {
                this.logErr("Error: unexpected exception: ", e);
                pass = false;
            }
            this.logTrace("sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgClearBodyTopicTest");
            messageSentStreamMessage.writeString("Testing...");
            this.logTrace("Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            try {
                this.logTrace("Test StreamMessage ");
                this.logTrace("read 1st contents");
                this.logTrace("  " + messageReceivedStreamMessage.readString());
                this.logTrace("Call to clearBody !!!!!!!!!!!!!!!");
                messageReceivedStreamMessage.clearBody();
                this.logTrace("Stream message body should now be empty and in writeonly mode");
                try {
                    String s = messageReceivedStreamMessage.readString();
                    this.logErr("Fail: MessageNotReadableException should have been thrown");
                    pass = false;
                }
                catch (MessageNotReadableException e) {
                    this.logTrace("Pass: MessageNotReadableException thrown as expected");
                }
                catch (Exception ee) {
                    this.logErr("Error: Unexpected exception: ", ee);
                    pass = false;
                }
                if (messageReceivedStreamMessage.getStringProperty("COM_SUN_JMS_TESTNAME").equals("msgClearBodyTopicTest")) {
                    this.logTrace("Pass: Stream msg properties read ok after clearBody called");
                } else {
                    this.logErr("Fail: Stream msg properties cleared after clearBody called");
                    pass = false;
                }
                this.logTrace("write 2nd contents");
                messageReceivedStreamMessage.writeString("new data");
                this.logTrace("read 2nd contents");
                messageReceivedStreamMessage.reset();
                if (messageReceivedStreamMessage.readString().equals("new data")) {
                    this.logTrace("Pass:");
                } else {
                    this.logErr("Fail:");
                }
            }
            catch (Exception e) {
                this.logErr("Error: ", e);
                pass = false;
            }
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("sending a Text message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgClearBodyTopicTest");
            this.logTrace("sending a Text message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            try {
                this.logTrace("Test TextMessage ");
                this.logTrace("read 1st contents");
                this.logTrace("  " + messageReceived.getText());
                this.logTrace("Call to clearBody !!!!!!!!!!!!!!!");
                messageReceived.clearBody();
                if (messageReceived.getText() == null) {
                    this.logTrace("Empty body after clearBody as expected: null");
                } else {
                    this.logTrace("Fail: message body was not empty");
                    pass = false;
                }
                if (messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME").equals("msgClearBodyTopicTest")) {
                    this.logTrace("Pass: Text properties read ok after clearBody called");
                } else {
                    this.logErr("Fail: Text properties cleared after clearBody called");
                    pass = false;
                }
                this.logTrace("write and read 2nd contents");
                messageReceived.setText("new data");
                if (messageReceived.getText().equals("new data")) {
                    this.logTrace("Pass:");
                } else {
                    this.logErr("Fail:");
                    pass = false;
                }
            }
            catch (Exception e) {
                this.logErr("Error: ", e);
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: clearBody test failure");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("msgClearBodyTopicTest", e);
        }
    }

    public void msgResetTopicTest() throws EETest.Fault {
        boolean pass = true;
        int nInt = 1000;
        try {
            StreamMessage messageSentStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            try {
                this.logTrace("creating a Stream message");
                messageSentStreamMessage = this.tool.getDefaultTopicSession().createStreamMessage();
                messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetTopicTest");
                messageSentStreamMessage.writeString("Testing...");
                this.logMsg("reset stream message -  now  should be in readonly mode");
                messageSentStreamMessage.reset();
                messageSentStreamMessage.writeString("new data");
                this.logErr("Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                this.logTrace("Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                this.logErr("Error: ", e);
                pass = false;
            }
            try {
                this.logTrace("creating a Byte message");
                messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
                messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetTopicTest");
                messageSentBytesMessage.writeInt(nInt);
                this.logMsg("reset Byte message -  now  should be in readonly mode");
                messageSentBytesMessage.reset();
                messageSentBytesMessage.writeInt(nInt);
                this.logErr("Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                this.logTrace("Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                this.logErr("Error: unexpected exception: ", e);
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: msgResetTopicTest test failure");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("msgResetTopicTest", e);
        }
    }

    public void readNullCharNotValidTopicTest() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            MapMessage mapSent = null;
            MapMessage mapReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "readNullCharNotValidTopicTest");
            this.logTrace("Write a null string to the stream message object with StreamMessage.writeString");
            messageSent.writeString(null);
            this.logTrace(" Send the message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("Use readChar to read a null  ");
            try {
                messageReceived.readChar();
                this.logErr("Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                this.logTrace("Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                this.logErr("Error: Unexpected exception: ", e);
                pass = false;
            }
            mapSent = this.tool.getDefaultTopicSession().createMapMessage();
            mapSent.setStringProperty("COM_SUN_JMS_TESTNAME", "readNullCharNotValidTopicTest");
            this.logTrace("Write a null string to the map message object with mapMessage.setString");
            mapSent.setString("WriteANull", null);
            this.logTrace(" Send the message");
            this.tool.getDefaultTopicPublisher().publish((Message)mapSent);
            mapReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("Use readChar to read a null  ");
            try {
                mapReceived.getChar("WriteANull");
                this.logErr("Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                this.logTrace("Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                this.logErr("Error: Unexpected exception: ", e);
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("readNullCharNotValidTopicTest", e);
        }
    }

    public void messageTIllegalarg() throws EETest.Fault {
        try {
            TextMessage messageSent = null;
            boolean pass = true;
            byte bValue = 127;
            short sValue = Short.MAX_VALUE;
            int cValue = 65535;
            int iValue = Integer.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            float fValue = 0.0f;
            double dValue = -0.0;
            String ssValue = "abc";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "messageTIllegalarg");
            this.logMsg("Writing a boolean property ... ");
            try {
                messageSent.setBooleanProperty("", pass);
                this.logErr("Shouldn't get here");
                throw new EETest.Fault("Error: test failed to be able to setBooleanProperty");
            }
            catch (IllegalArgumentException e) {
                this.logMsg("Got Expected IllegalArgumentException with setBooleanProperty");
                this.logMsg("Writing a byte Property ... ");
                try {
                    messageSent.setByteProperty("", bValue);
                    this.logErr("Shouldn't get here");
                    throw new EETest.Fault("Error: test failed to be able to setByteProperty");
                }
                catch (IllegalArgumentException e2) {
                    this.logMsg("Got Expected IllegalArgumentException with setByteProperty");
                    this.logMsg("Writing a short Property... ");
                    try {
                        messageSent.setShortProperty("", sValue);
                        this.logErr("Shouldn't get here");
                        throw new EETest.Fault("Error: test failed to be able to setShortProperty");
                    }
                    catch (IllegalArgumentException e3) {
                        this.logMsg("Got Expected IllegalArgumentException with setShortProperty");
                        this.logMsg("Writing a int Property ... ");
                        try {
                            messageSent.setIntProperty("", iValue);
                            this.logErr("Shouldn't get here");
                            throw new EETest.Fault("Error: test failed to be able to setIntProperty");
                        }
                        catch (IllegalArgumentException e4) {
                            this.logMsg("Got Expected IllegalArgumentException with setIntProperty");
                            this.logMsg("Writing a long Property ... ");
                            try {
                                messageSent.setLongProperty("", lValue);
                                this.logErr("Shouldn't get here");
                                throw new EETest.Fault("Error: test failed to be able to setLongProperty");
                            }
                            catch (IllegalArgumentException e5) {
                                this.logMsg("Got Expected IllegalArgumentException with setLongProperty");
                                this.logMsg("Writing a float Property ... ");
                                try {
                                    messageSent.setFloatProperty("", fValue);
                                    this.logErr("Shouldn't get here");
                                    throw new EETest.Fault("Error: test failed to be able to setFloatProperty");
                                }
                                catch (IllegalArgumentException e6) {
                                    this.logMsg("Got Expected IllegalArgumentException with setFloatProperty");
                                    this.logMsg("Writing a double Property ... ");
                                    try {
                                        messageSent.setDoubleProperty("", dValue);
                                        this.logErr("Shouldn't get here");
                                        throw new EETest.Fault("Error: test failed to be able to setDoubleProperty");
                                    }
                                    catch (IllegalArgumentException e7) {
                                        this.logMsg("Got Expected IllegalArgumentException with setDoubleProperty");
                                        this.logMsg("Writing a string Property ... ");
                                        try {
                                            messageSent.setStringProperty("", ssValue);
                                            this.logErr("Shouldn't get here");
                                            throw new EETest.Fault("Error: test failed to be able to setStringProperty");
                                        }
                                        catch (IllegalArgumentException e8) {
                                            this.logMsg("Got Expected IllegalArgumentException with setStringProperty");
                                            this.logMsg("Writing a object Property ... ");
                                            try {
                                                messageSent.setObjectProperty("", (Object)new Integer(iValue));
                                                this.logErr("Shouldn't get here");
                                                throw new EETest.Fault("Error: test failed to be able to setObjectProperty");
                                            }
                                            catch (IllegalArgumentException e9) {
                                                this.logMsg("Got Expected IllegalArgumentException with setObjectProperty");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("messageTIllegalarg", e);
        }
    }
}

