/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.module.soap;

import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.module.ClientAuthModule;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;

public class TSFailureClientAuthModule
implements ClientAuthModule {
    private static TSLogger logger = null;
    private static Map options = null;

    public void initialize(MessagePolicy reqPolicy, MessagePolicy resPolicy, CallbackHandler handler, Map optns) throws AuthException {
        options = optns;
        if (options.get("TSLogger") != null) {
            logger = (TSLogger)options.get("TSLogger");
        }
    }

    public Class[] getSupportedMessageTypes() {
        Class[] classarray = new Class[]{SOAPMessage.class};
        this.logMsg("TSFailureClientAuthModule.getSupportedMessageTypes called");
        return classarray;
    }

    public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
        String msg = "TSFailureClientAuthModule.secureRequest called";
        this.logMsg(msg);
        SOAPMessage smsg = null;
        try {
            MessageFactory mf = MessageFactory.newInstance();
            smsg = mf.createMessage();
            if (smsg != null) {
                this.setSOAPFault(smsg);
            }
        }
        catch (SOAPException ex) {
            ex.printStackTrace();
        }
        messageInfo.setResponseMessage((Object)smsg);
        return AuthStatus.FAILURE;
    }

    public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        String msg = "TSFailureClientAuthModule.validateResponse called";
        this.logMsg(msg);
        SOAPMessage smsg = (SOAPMessage)messageInfo.getResponseMessage();
        if (smsg != null) {
            this.setSOAPFault(smsg);
        }
        return AuthStatus.FAILURE;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.logMsg("TSFailureClientAuthModule.cleanSubject called");
        subject = null;
    }

    public void logMsg(String str) {
        if (logger != null) {
            logger.log(Level.INFO, str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***" + str);
        }
    }

    private void setSOAPFault(SOAPMessage smsg) {
        SOAPPart soap = smsg.getSOAPPart();
        if (soap != null) {
            try {
                SOAPBody body;
                SOAPEnvelope envelope = soap.getEnvelope();
                if (envelope != null && (body = envelope.getBody()) != null) {
                    QName qname = new QName("Client");
                    body.addFault(qname, "Error in Client");
                }
            }
            catch (SOAPException se) {
                logger.log(Level.INFO, "Error adding SOAP Fault", se);
            }
        }
    }
}

