/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.query.flushmode;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.schema30.CreditCard;
import com.sun.ts.tests.jpa.common.schema30.Customer;
import com.sun.ts.tests.jpa.common.schema30.Order;
import com.sun.ts.tests.jpa.common.schema30.Spouse;
import com.sun.ts.tests.jpa.common.schema30.Util;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.Query;
import java.sql.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class Client
extends Util {
    private final Date d1 = this.getSQLDate("2000-02-14");

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"Entering Setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void flushModeTest1() throws EETest.Fault {
        Customer newCust;
        String[] expectedPKs;
        List c;
        FlushModeType fmt;
        Query q;
        Customer cust1;
        EntityManager em;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        boolean pass6 = false;
        TestUtil.logTrace((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            em = this.getEntityManager();
            TestUtil.logTrace((String)"Calling find");
            cust1 = (Customer)em.find(Customer.class, (Object)"1");
            cust1.setName("Michael Bouschen");
            q = em.createQuery("SELECT c FROM Customer c WHERE c.name = 'Michael Bouschen'");
            TestUtil.logTrace((String)("EntityManager.getFlushMode() returned:" + em.getFlushMode()));
            TestUtil.logTrace((String)"Calling Query.getFlushMode()");
            fmt = q.getFlushMode();
            if (!fmt.equals((Object)em.getFlushMode())) {
                TestUtil.logErr((String)("getFlushMode() called when no mode set expected:" + em.getFlushMode() + ", actual:" + fmt));
            } else {
                pass1 = true;
                TestUtil.logTrace((String)"Setting mode to FlushModeType.AUTO");
                q.setFlushMode(FlushModeType.AUTO);
                fmt = q.getFlushMode();
                if (!fmt.equals((Object)FlushModeType.AUTO)) {
                    TestUtil.logErr((String)("getFlushMode() called when no mode set expected:" + FlushModeType.AUTO + ", actual:" + fmt));
                } else {
                    pass2 = true;
                    c = q.getResultList();
                    if (!this.checkEntityPK(c, expectedPKs = new String[]{"1"})) {
                        TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + c.size()));
                    } else {
                        newCust = (Customer)em.find(Customer.class, (Object)"1");
                        if (newCust.getName().equals("Michael Bouschen")) {
                            TestUtil.logTrace((String)"Expected results received");
                            pass3 = true;
                        }
                    }
                }
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        TestUtil.logTrace((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            em = this.getEntityManager();
            TestUtil.logTrace((String)"Calling find");
            cust1 = (Customer)em.find(Customer.class, (Object)"1");
            cust1.setName("Michael Bouschen");
            q = em.createQuery("SELECT c FROM Customer c WHERE c.name = 'Michael Bouschen'", Customer.class);
            TestUtil.logTrace((String)"Calling getFlushMode()");
            fmt = q.getFlushMode();
            if (!fmt.equals((Object)em.getFlushMode())) {
                TestUtil.logErr((String)("getFlushMode() called when no mode set expected:" + em.getFlushMode() + ", actual:" + fmt));
            } else {
                pass4 = true;
                TestUtil.logTrace((String)"Setting mode to FlushModeType.AUTO");
                q.setFlushMode(FlushModeType.AUTO);
                fmt = q.getFlushMode();
                if (!fmt.equals((Object)FlushModeType.AUTO)) {
                    TestUtil.logErr((String)("getFlushMode() called when no mode set expected:" + FlushModeType.AUTO + ", actual:" + fmt));
                } else {
                    pass5 = true;
                    c = q.getResultList();
                    if (!this.checkEntityPK(c, expectedPKs = new String[]{"1"})) {
                        TestUtil.logErr((String)("Did not get expected results.  Expected 1 references, got: " + c.size()));
                    } else {
                        newCust = (Customer)em.find(Customer.class, (Object)"1");
                        if (newCust.getName().equals("Michael Bouschen")) {
                            pass6 = true;
                            TestUtil.logTrace((String)"Expected results received");
                        }
                    }
                }
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6)) {
            throw new EETest.Fault("flushModeTest1 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void flushModeTest2() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute Starting flushModeTest2");
            Order o1 = (Order)this.getEntityManager().find(Order.class, (Object)"1");
            Customer cust2 = (Customer)this.getEntityManager().find(Customer.class, (Object)"2");
            o1.setCustomer(cust2);
            List result = this.getEntityManager().createQuery("SELECT o FROM Order o WHERE o.customer.name = 'Arthur D. Frechette'").setFlushMode(FlushModeType.AUTO).getResultList();
            String[] expectedPKs = new String[]{"1", "2"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexception: " + e));
        }
        if (!pass) {
            throw new EETest.Fault("flushModeTest2 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void flushModeTest3() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute Starting flushModeTest3");
            Customer cust1 = (Customer)this.getEntityManager().find(Customer.class, (Object)"1");
            cust1.setName("Michael Bouschen");
            List o = this.getEntityManager().createQuery("SELECT o FROM Order o WHERE o.customer.name = 'Michael Bouschen'").setFlushMode(FlushModeType.AUTO).getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(o, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + o.size()));
            } else {
                Customer newCust = (Customer)this.getEntityManager().find(Customer.class, (Object)"1");
                if (newCust.getName().equals("Michael Bouschen")) {
                    pass = true;
                }
                TestUtil.logTrace((String)"Expected results received");
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexception: " + e));
        }
        if (!pass) {
            throw new EETest.Fault("flushModeTest3 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void flushModeTest4() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Execute Starting flushModeTest4");
            Customer cust6 = (Customer)this.getEntityManager().find(Customer.class, (Object)"6");
            Spouse s4 = (Spouse)this.getEntityManager().find(Spouse.class, (Object)"4");
            cust6.setSpouse(s4);
            this.getEntityManager().merge((Object)cust6);
            s4.setCustomer(cust6);
            this.getEntityManager().merge((Object)s4);
            List result = this.getEntityManager().createQuery("SELECT o FROM Order o WHERE o.customer.spouse.lastName = 'Mullen'").setFlushMode(FlushModeType.AUTO).getResultList();
            String[] expectedPKs = new String[]{"6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected  2 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexception: " + e));
        }
        if (!pass) {
            throw new EETest.Fault("flushModeTest4 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void flushModeTest5() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Starting flushModeTest5");
            Spouse s4 = (Spouse)this.getEntityManager().find(Spouse.class, (Object)"4");
            s4.setLastName("Miller");
            List result = this.getEntityManager().createQuery("SELECT o FROM Order o WHERE o.customer.spouse.lastName = 'Miller'").setFlushMode(FlushModeType.AUTO).getResultList();
            String[] expectedPKs = new String[]{"11"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected  1 reference, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexception: " + e));
        }
        if (!pass) {
            throw new EETest.Fault("flushModeTest5 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void flushModeTest6() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Starting flushModeTest6");
            Customer cust4 = (Customer)this.getEntityManager().find(Customer.class, (Object)"4");
            Order order4 = (Order)this.getEntityManager().find(Order.class, (Object)"4");
            Order order9 = (Order)this.getEntityManager().find(Order.class, (Object)"9");
            order9.setCustomer(cust4);
            this.getEntityManager().merge((Object)order9);
            order4.setCustomer(null);
            this.getEntityManager().merge((Object)order4);
            Vector<Order> orders = new Vector<Order>();
            orders.add(order9);
            cust4.setOrders(orders);
            this.getEntityManager().merge((Object)cust4);
            List result = this.getEntityManager().createQuery("SELECT c FROM Customer c JOIN c.orders o where o.id = '4' ").setFlushMode(FlushModeType.AUTO).getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(result, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected  0 references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("flushModeTest6 failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void flushModeTest7() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"2"};
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Starting flushModeTest7");
            CreditCard c17 = (CreditCard)this.getEntityManager().find(CreditCard.class, (Object)"17");
            c17.setNumber("1111-1111-1111-1111");
            List result = this.getEntityManager().createQuery("SELECT s FROM Spouse s JOIN s.customer c JOIN c.orders o WHERE o.creditCard.number = '1111-1111-1111-1111'").setFlushMode(FlushModeType.AUTO).getResultList();
            if (!this.checkEntityPK(result, expected)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected " + expected.length + " references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("flushModeTest7 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void secondaryTablesValueTest() throws EETest.Fault {
        boolean pass = false;
        String[] expected = new String[]{"20", "24", "31", "37"};
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT p FROM Product p WHERE p.wareHouse = 'Lowell' ").getResultList();
            if (!this.checkEntityPK(result, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().rollback();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("secondaryTablesValueTest failed");
        }
    }
}

