/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.servlet.WebServiceRefsTest.client;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.webservices12.servlet.WebServiceRefsTest.client.WSHello1;
import com.sun.ts.tests.webservices12.servlet.WebServiceRefsTest.client.WSHello1Service;
import com.sun.ts.tests.webservices12.servlet.WebServiceRefsTest.client.WSHello2;
import com.sun.ts.tests.webservices12.servlet.WebServiceRefsTest.client.WSHello2Service;
import java.util.Properties;
import javax.naming.InitialContext;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    String modeProperty = null;
    WSHello1 port1 = null;
    WSHello2 port2 = null;

    private void getPort() throws Exception {
        TestUtil.logMsg((String)"Get JNDI InitialContext");
        InitialContext ic = new InitialContext();
        TestUtil.logMsg((String)"Do JNDI lookup of service1 java:comp/env/service/wshello1service");
        WSHello1Service service1 = (WSHello1Service)((Object)ic.lookup("java:comp/env/service/wshello1service"));
        TestUtil.logMsg((String)("service1=" + (Object)((Object)service1)));
        TestUtil.logMsg((String)"Do JNDI lookup of service2 java:comp/env/service/wshello2service");
        WSHello2Service service2 = (WSHello2Service)((Object)ic.lookup("java:comp/env/service/wshello2service"));
        TestUtil.logMsg((String)("service2=" + (Object)((Object)service2)));
        TestUtil.logMsg((String)"Services obtained");
        TestUtil.logMsg((String)"Get port from service1");
        this.port1 = service1.getWSHello1Port();
        TestUtil.logMsg((String)("port1=" + this.port1));
        TestUtil.logMsg((String)"Get port from service2");
        this.port2 = service2.getWSHello2Port();
        TestUtil.logMsg((String)("port2=" + this.port2));
        TestUtil.logMsg((String)"Ports obtained");
        JAXWS_Util.dumpTargetEndpointAddress(this.port1);
        JAXWS_Util.dumpTargetEndpointAddress(this.port2);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            this.getPort();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void DoInvokeWebService1Test() throws EETest.Fault {
        TestUtil.logMsg((String)"DoInvokeWebService1Test");
        boolean pass = true;
        try {
            String ret = this.port1.sayServletHello("Hello Hello!!!");
            if (!ret.equals("WSHello1Servlet: Hello Hello!!!")) {
                throw new EETest.Fault("DoInvokeWebService1Test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("DoInvokeWebService1Test failed", e);
        }
    }

    public void DoInvokeWebService2Test() throws EETest.Fault {
        TestUtil.logMsg((String)"DoInvokeWebService2Test");
        boolean pass = true;
        try {
            String ret = this.port2.sayServletHello("Hello Hello!!!");
            if (!ret.equals("WSHello2Servlet: Hello Hello!!!")) {
                throw new EETest.Fault("DoInvokeWebService2Test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("DoInvokeWebService2Test failed", e);
        }
    }

    public void VerifyTargetEndpointAddressForBothWebServices() throws EETest.Fault {
        TestUtil.logMsg((String)"VerifyTargetEndpointAddressForBothWebServices");
        try {
            String endpointaddr1 = JAXWS_Util.getTargetEndpointAddress(this.port1);
            String endpointaddr2 = JAXWS_Util.getTargetEndpointAddress(this.port2);
            TestUtil.logMsg((String)"Verify that target endpoint address for WebService1 ends with [jaxws/WSHello1]");
            TestUtil.logMsg((String)"Verify that target endpoint address for WebService2 ends with [jaxws/WSHello2]");
            if (!endpointaddr1.endsWith("jaxws/WSHello1") || !endpointaddr2.endsWith("jaxws/WSHello2")) {
                TestUtil.logErr((String)("Target Endpoint Address for WebService1: " + endpointaddr1));
                TestUtil.logErr((String)("Target Endpoint Address for WebService2: " + endpointaddr2));
                throw new EETest.Fault("VerifyTargetEndpointAddressForBothWebServices failed");
            }
            TestUtil.logMsg((String)"VerifyTargetEndpointAddressForBothWebServices passed");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault("VerifyTargetEndpointAddressForBothWebServices failed");
        }
    }
}

