/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.signaturetest;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.signaturetest.SigTestDriver;
import com.sun.ts.tests.signaturetest.SigTestResult;
import com.sun.ts.tests.signaturetest.SignatureTestDriver;
import java.util.ArrayList;
import java.util.Arrays;

public class Jdk9SigTestDriver
extends SigTestDriver {
    private static final String STATIC_FLAG = "-Static";
    private static final String CHECKVALUE_FLAG = "-CheckValue";
    private static final String SMODE_FLAG = "-mode";
    private static final String DEBUG_FLAG = "-Debug";
    private static final String VERBOSE_FLAG = "-Verbose";
    private static final String CLASSPATH_FLAG = "-Classpath";
    private static final String FILENAME_FLAG = "-FileName";
    private static final String PACKAGE_FLAG = "-Package";
    private static final String API_VERSION_FLAG = "-ApiVersion";
    private static final String XJIMAGE = "-xjimage";

    protected String[] createTestArguments(String packageListFile, String mapFile, String signatureRepositoryDir, String[] packageOrClassUnderTest, String classpath, boolean bStaticMode) throws Exception {
        SignatureTestDriver.SignatureFileInfo info = this.getSigFileInfo(packageOrClassUnderTest[0], mapFile, signatureRepositoryDir);
        ArrayList<String> command = new ArrayList<String>();
        if (bStaticMode) {
            TestUtil.logTrace((String)"Setting static mode flag to allow constant checking.");
            command.add(STATIC_FLAG);
            command.add(CHECKVALUE_FLAG);
            command.add(SMODE_FLAG);
            command.add("src");
        } else {
            TestUtil.logTrace((String)"Not Setting static mode flag to allow constant checking.");
        }
        if (TestUtil.harnessDebug) {
            command.add(DEBUG_FLAG);
        }
        command.add(VERBOSE_FLAG);
        command.add(FILENAME_FLAG);
        command.add(info.getFile());
        command.add(CLASSPATH_FLAG);
        command.add(classpath);
        command.add(PACKAGE_FLAG);
        command.add(packageOrClassUnderTest[0]);
        command.add(API_VERSION_FLAG);
        command.add(info.getVersion());
        String jimage = System.getProperty("java.home") + "/bin/jimage";
        command.add(XJIMAGE);
        command.add(jimage);
        return command.toArray(new String[command.size()]);
    }

    @Override
    public SigTestResult executeSigTest(String packageListFile, String mapFile, String signatureRepositoryDir, String[] packagesUnderTest, String[] classesUnderTest, String classpath, ArrayList<String> unaccountedTechPkgs, String optionalPkgToIgnore) throws Exception {
        SigTestResult result = new SigTestResult();
        if (packagesUnderTest != null && packagesUnderTest.length > 0) {
            TestUtil.logMsg((String)"********** BEGIN PACKAGE LEVEL SIGNATURE VALIDATION **********\n\n");
            String packageName = packagesUnderTest[0];
            TestUtil.logMsg((String)("********** BEGIN VALIDATE PACKAGE '" + packageName + "' **********\n"));
            TestUtil.logMsg((String)"********** VALIDATE IN STATIC MODE - TO CHECK CONSANT VALUES ****");
            TestUtil.logMsg((String)"Static mode supports checks of static constants values ");
            TestUtil.logMsg((String)"Extracting jimage, it can take several minutes....");
            String[] args = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, packagesUnderTest, classpath, true);
            Jdk9SigTestDriver.dumpTestArguments(args);
            if (this.runSignatureTest(Arrays.toString(packagesUnderTest), args)) {
                TestUtil.logMsg((String)("********** Package '" + packageName + "' - PASSED (STATIC MODE) **********"));
                for (String p : packagesUnderTest) {
                    result.addPassedPkg(p + "(static mode)");
                }
            } else {
                for (String p : packagesUnderTest) {
                    result.addFailedPkg(p + "(static mode)");
                }
                TestUtil.logMsg((String)("********** Package '" + packageName + "' - FAILED (STATIC MODE) **********"));
            }
            TestUtil.logMsg((String)"\n\n");
            TestUtil.logMsg((String)"********** VALIDATE IN REFLECTIVE MODE  ****");
            TestUtil.logMsg((String)"Reflective mode supports verification within containers (ie ejb, servlet, etc)");
            TestUtil.logMsg((String)"Extracting jimage, it can take several minutes....");
            String[] args2 = this.createTestArguments(packageListFile, mapFile, signatureRepositoryDir, packagesUnderTest, classpath, false);
            Jdk9SigTestDriver.dumpTestArguments(args2);
            if (this.runSignatureTest(Arrays.toString(packagesUnderTest), args2)) {
                TestUtil.logMsg((String)("********** Package '" + packageName + "' - PASSED (REFLECTION MODE) **********"));
                for (String p : packagesUnderTest) {
                    result.addPassedPkg(p + "(reflection mode)");
                }
            } else {
                for (String p : packagesUnderTest) {
                    result.addFailedPkg(p + "(reflection mode)");
                }
                TestUtil.logMsg((String)("********** Package '" + packageName + "' - FAILED (REFLECTION MODE) **********"));
            }
            TestUtil.logMsg((String)("********** END VALIDATE PACKAGE '" + packageName + "' **********\n"));
            TestUtil.logMsg((String)"\n");
            TestUtil.logMsg((String)"\n");
        }
        if (classesUnderTest != null && classesUnderTest.length > 0) {
            throw new IllegalStateException("Class validation not implemented");
        }
        if (unaccountedTechPkgs != null) {
            throw new IllegalStateException("Unaccounted Tech Packages not implemented");
        }
        return result;
    }

    protected static void dumpTestArguments(String[] params) {
        if (params != null && params.length > 0) {
            TestUtil.logTrace((String)"----------------- BEGIN SIG PARAM DUMP -----------------");
            for (int i = 0; i < params.length; ++i) {
                TestUtil.logTrace((String)("   Param[" + i + "]: " + params[i]));
            }
            TestUtil.logTrace((String)"------------------ END SIG PARAM DUMP ------------------");
        }
    }

    protected static boolean isIgnorePackageUnderTest(String packageName, String[] arrayOptionalPkgsToIgnore) {
        if (packageName == null || arrayOptionalPkgsToIgnore == null) {
            return false;
        }
        for (int ii = 0; ii < arrayOptionalPkgsToIgnore.length; ++ii) {
            if (!packageName.equals(arrayOptionalPkgsToIgnore[ii])) continue;
            return true;
        }
        return false;
    }
}

