/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.types.property;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.types.common.Grade;
import com.sun.ts.tests.jpa.core.types.property.Customer;
import com.sun.ts.tests.jpa.core.types.property.DataTypes;
import com.sun.ts.tests.jpa.core.types.property.DataTypes2;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private DataTypes d1;
    private DataTypes2 d2;
    private final java.util.Date dateId = this.getPKDate(2006, 4, 15);
    private final Date dateValue = this.getSQLDate(2006, 4, 15);

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupCust(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeCustTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest1() throws EETest.Fault {
        boolean pass = false;
        Character newChar = Character.valueOf('b');
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getCharacterData().equals(Character.valueOf('a'))) {
                    this.d1.setCharacterData(newChar);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getCharacterData().equals(newChar)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest2() throws EETest.Fault {
        boolean pass = false;
        Short newShort = 101;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getShortData().equals((short)100)) {
                    this.d1.setShortData(newShort);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getShortData().equals(newShort)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest3() throws EETest.Fault {
        boolean pass = false;
        Integer newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getIntegerData().equals(500)) {
                    this.d1.setIntegerData(newInt);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getIntegerData().equals(newInt)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest4() throws EETest.Fault {
        boolean pass = false;
        Long newLong = 600L;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getLongData().equals(300L)) {
                    this.d1.setLongData(newLong);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getLongData().equals(newLong)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest5() throws EETest.Fault {
        boolean pass = false;
        Double newDbl = 80.0;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getDoubleData().equals(50.0)) {
                    this.d1.setDoubleData(newDbl);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getDoubleData().equals(newDbl)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest6() throws EETest.Fault {
        boolean pass = false;
        Float newFloat = Float.valueOf(3.0f);
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getFloatData().equals(Float.valueOf(1.0f))) {
                    this.d1.setFloatData(newFloat);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getFloatData().equals(newFloat)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest6 failed");
        }
    }

    public void propertyTypeTest7() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D1 IN propertyTypeTest7");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting enumData ");
                this.d1.setEnumData(Grade.C);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"Check results");
                if (this.d1.getEnumData().equals((Object)Grade.C)) {
                    TestUtil.logTrace((String)("Expected Grade of:" + this.d1.getEnumData() + "received"));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected results.  Expected C, got: " + this.d1.getEnumData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest7 failed");
        }
    }

    public void propertyTypeTest8() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D2 IN propertyTypeTest8");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            TestUtil.logTrace((String)"Check results");
            if (null != this.d2) {
                if (this.d2.getId().equals(this.dateId)) {
                    TestUtil.logTrace((String)("Got expected PK of:" + this.d2.getId() + "received"));
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected results. Expected " + this.dateId + ", got: " + this.d2.getId()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest9() throws EETest.Fault {
        boolean pass = false;
        Byte[] b = new Byte[]{(byte)31, (byte)32, (byte)33, (byte)63, (byte)64, (byte)65};
        Byte bv = 5;
        Object[] a = null;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D1 IN propertyTypeTest9");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting byteData ");
                this.d1.setByteArrayData(b);
                a = this.d1.getByteArrayData();
                a[0] = (byte)(a[0] + bv);
                this.d1.setByteArrayData(b);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"Check results");
                if (Arrays.equals((Object[])this.d1.getByteArrayData(), a)) {
                    TestUtil.logTrace((String)"propertyTypeTest9: Expected results received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Unexpected result in array comparison.");
                    for (int i = 0; i < a.length; ++i) {
                        TestUtil.logTrace((String)("Array a in propertyTest9 equals: " + a[i]));
                    }
                    for (int j = 0; j < b.length; ++j) {
                        TestUtil.logTrace((String)("Array b in propertyTest9 equals: " + b[j]));
                    }
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest9 failed");
        }
    }

    public void propertyTypeTest10() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Object[] charData = new Character[]{Character.valueOf('C'), Character.valueOf('T'), Character.valueOf('S')};
            TestUtil.logTrace((String)"FIND D1 IN propertyTypeTest10");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting CharacterData ");
                this.d1.setCharArrayData((Character[])charData);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"propertyTypeTest10:  Check results");
                if (Arrays.equals((Object[])this.d1.getCharArrayData(), charData)) {
                    TestUtil.logTrace((String)"propertyTypeTest10: Expected Results Received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected results. Expected " + Arrays.toString(charData) + ", got: " + Arrays.toString((Object[])this.d1.getCharArrayData())));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest11() throws EETest.Fault {
        boolean pass = false;
        Time timeValue = this.getTimeData(18, 30, 15);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D2 IN propertyTypeTest11");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting TimeData ");
                this.d2.setTimeData(timeValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"propertyTypeTest11:  Check results");
                if (this.d2.getTimeData().equals(timeValue)) {
                    TestUtil.logTrace((String)"propertyTypeTest11: Expected Time Received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected results.  Expected " + timeValue + " , got: " + this.d2.getTimeData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest12() throws EETest.Fault {
        boolean pass = false;
        Timestamp tsValue = this.getTimestampData(2006, 2, 11);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D2 IN propertyTypeTest12");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting TimestampData ");
                this.d2.setTsData(tsValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                TestUtil.logTrace((String)"propertyTypeTest12:  Check results");
                if (this.d2.getTsData().equals(tsValue)) {
                    TestUtil.logTrace((String)"propertyTypeTest12: Expected Timestamp Received");
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected results.  Expected " + tsValue + " , got: " + this.d2.getTsData()));
                }
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("propertyTypeTest12 failed");
        }
    }

    public void scalarExpressionsTest() throws EETest.Fault {
        DataTypes d;
        List p;
        char expected;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            expected = this.d1.getIntegerData() + 1;
            TestUtil.logTrace((String)"Testing arithmetic expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where ((d.integerData + 1) = ?1)").setParameter(1, (Object)expected).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                TestUtil.logTrace((String)("DataType:" + d.toString()));
                int actual = d.getIntegerData() + 1;
                if (actual == expected) {
                    TestUtil.logTrace((String)("Received expected Integer data:" + actual));
                    pass1 = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected result, Expected: " + expected + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of results, expected:1, actual:" + p.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            expected = 'a';
            TestUtil.logTrace((String)"Testing string expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.characterData = ?1)").setParameter(1, (Object)Character.valueOf(expected)).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                TestUtil.logTrace((String)("DataType:" + d.toString()));
                Character actual = d.getCharacterData();
                if (actual.equals(Character.valueOf(expected))) {
                    TestUtil.logTrace((String)("Received expected Character data:" + actual));
                    pass2 = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected result, Expected: " + expected + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of results, expected:1, actual:" + p.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            Grade expected2 = Grade.C;
            TestUtil.logTrace((String)"Testing enum expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.enumData = ?1)").setParameter(1, (Object)expected2).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                TestUtil.logTrace((String)("DataType:" + d.toString()));
                Grade actual = d.getEnumData();
                if (actual.equals((Object)expected2)) {
                    TestUtil.logTrace((String)("Received expected Enum data:" + actual));
                    pass3 = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected result, Expected: " + expected2 + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of results, expected:1, actual:" + p.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            java.util.Date dateValue = this.getPKDate(2006, 1, 1);
            java.util.Date expected3 = this.dateId;
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Testing datetime expression:");
            List pp = this.getEntityManager().createQuery("Select d From DataTypes2 d where (d.dateData > ?1)").setParameter(1, (Object)dateValue).getResultList();
            if (pp.size() == 1) {
                DataTypes2 d2 = (DataTypes2)pp.get(0);
                TestUtil.logTrace((String)("DataType2:" + d2.toString()));
                java.util.Date actual = d2.getDateData();
                if (actual.equals(expected3)) {
                    TestUtil.logTrace((String)("Received expected Date data:" + actual));
                    pass4 = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected result, Expected: " + expected3 + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of results, expected:1, actual:" + pp.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            boolean expected4 = true;
            TestUtil.logTrace((String)"Testing boolean expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.booleanData = ?1)").setParameter(1, (Object)expected4).getResultList();
            if (p.size() > 0) {
                d = (DataTypes)p.get(0);
                TestUtil.logTrace((String)("DataType:" + d.toString()));
                Boolean actual = d.getBooleanData();
                if (actual.equals(expected4)) {
                    TestUtil.logTrace((String)("Received expected Boolean data:" + actual));
                    pass5 = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected result, Expected: " + expected4 + ", actual:" + actual));
                }
            } else {
                TestUtil.logErr((String)("Did not get expected number of results, expected:1, actual:" + p.size()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new EETest.Fault("scalarExpressionsTest failed");
        }
    }

    @SetupMethod(name="setupCust")
    @CleanupMethod(name="cleanupCust")
    public void elementCollectionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = new Customer("1");
            ArrayList<Grade> expectedphones = new ArrayList<Grade>();
            expectedphones.add(Grade.A);
            expectedphones.add(Grade.B);
            expectedphones.add(Grade.C);
            expected.setPhones(expectedphones);
            TestUtil.logTrace((String)("Persisting Customer:" + expected.toString()));
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                TestUtil.logTrace((String)("Found Customer: " + cust.toString()));
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    TestUtil.logTrace((String)"Received expected Phones:");
                    for (Grade g : cust.getPhones()) {
                        TestUtil.logTrace((String)("phone:" + g));
                    }
                    pass = true;
                } else {
                    TestUtil.logErr((String)"Did not get expected results.");
                    for (Grade g : expectedphones) {
                        TestUtil.logErr((String)("expected:" + g));
                    }
                    TestUtil.logErr((String)"actual:");
                    for (Grade g : cust.getPhones()) {
                        TestUtil.logErr((String)("actual:" + g));
                    }
                }
            } else {
                TestUtil.logErr((String)"Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred: ", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("elementCollectionTest failed");
        }
    }

    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            Character[] cArray = new Character[]{Character.valueOf('a')};
            Byte[] bArray = new Byte[]{(byte)100};
            this.d1 = new DataTypes(Integer.valueOf(1), Character.valueOf('a'), Boolean.valueOf(true), Short.valueOf((short)100), Integer.valueOf(500), Long.valueOf(300L), Double.valueOf(50.0), Float.valueOf(1.0f), cArray, bArray);
            this.d1.setEnumData(Grade.C);
            this.d2 = new DataTypes2(this.dateId);
            this.d2.setDateData((java.util.Date)this.dateValue);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityManager().persist((Object)this.d2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupCust() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeCustTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    private void removeCustTestData() {
        TestUtil.logTrace((String)"removeCustTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

