/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.annotations.anno;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import com.sun.ts.tests.connector.util.DBSupport;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class annotationClient
extends ServiceEETest
implements Serializable {
    private TSNamingContext nctx = null;
    private TSConnection con1 = null;
    private TSConnection con2 = null;
    private String partialMDJndiName = null;
    private String annoJndiName = null;
    private String uname = null;
    private String password = null;
    private TSDataSource ds1 = null;
    private DBSupport dbutil = null;

    public static void main(String[] args) {
        annotationClient theTests = new annotationClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.annoJndiName = p.getProperty("whitebox-anno_no_md");
        System.out.println("annoJndiName = : " + this.annoJndiName);
        this.uname = p.getProperty("rauser1");
        this.password = p.getProperty("rapassword1");
        this.logMsg("Using: " + this.annoJndiName);
        try {
            this.dbutil = new DBSupport();
        }
        catch (Exception e) {
            throw new EETest.Fault("Exception constructing DBSupport object: " + e.getMessage(), e);
        }
        try {
            this.nctx = new TSNamingContext();
            this.ds1 = (TSDataSource)this.nctx.lookup(this.annoJndiName);
            if (this.ds1 == null) {
                TestUtil.logMsg((String)"ds1 lookup failed and is null");
            } else {
                TestUtil.logMsg((String)"ds1 lookup is not null");
            }
            TestUtil.logMsg((String)("ds1 JNDI lookup: " + this.ds1));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception during JNDI lookup: " + e.getMessage()));
        }
    }

    public void testConnectorAnnotation() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        try {
            this.ds1.setLogFlag(true);
            this.con1 = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        String toCheck1 = "AnnotatedResourceAdapterImpl.start called";
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new EETest.Fault("@Connection annotation not processed correctly.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
        TestUtil.logMsg((String)"Performing end to end verification...");
        try {
            this.dbutil.insertIntoTable(this.con1);
            TestUtil.logMsg((String)"Values inserted into table!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception inserting into table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        try {
            this.dbutil.dropTable(this.con1);
            TestUtil.logMsg((String)"Table has been dropped!");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception dropping table.");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
    }

    public void testSetterMethodConfigPropAnno() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        String toCheck1 = "AnnotatedResourceAdapterImpl.setSetterMethodVal=NONDEFAULT";
        try {
            this.ds1.setLogFlag(true);
            this.con1 = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (!str.startsWith(toCheck1)) continue;
            b1 = true;
        }
        if (!b1) {
            throw new EETest.Fault("@ConfigProperty on setter method not processed correctly.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testConfigPropertyAnnotation() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        String toCheck1 = "setRAName called with raname=AnnotatedResourceAdapterImpl";
        String toCheck2 = "AnnoManagedConnectionFactory factoryName=AnnoManagedConnectionFactory";
        try {
            this.ds1.setLogFlag(true);
            this.con1 = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || !b2) {
            throw new EETest.Fault("@ConfigProperty annotation not processed correctly.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void testRAAccessibility() throws EETest.Fault {
        Vector log = null;
        boolean b1 = false;
        boolean b2 = false;
        String toCheck1 = "testRAAccessibility:  accessibility test";
        String toCheck2 = "AnnotatedResourceAdapterImpl.start called";
        ConnectorStatus.getConnectorStatus().logState(toCheck1);
        try {
            this.ds1.setLogFlag(true);
            this.con1 = this.ds1.getConnection();
            log = this.ds1.getStateLog();
            TestUtil.logTrace((String)"Got connection.");
        }
        catch (Exception sqle) {
            TestUtil.logMsg((String)"Exception caught on creating connection:");
            throw new EETest.Fault(sqle.getMessage(), sqle);
        }
        TestUtil.logTrace((String)log.toString());
        for (int i = 0; i < log.size(); ++i) {
            String str = (String)log.elementAt(i);
            if (str.startsWith(toCheck1)) {
                b1 = true;
            }
            if (!str.startsWith(toCheck2)) continue;
            b2 = true;
        }
        if (!b1 || !b2) {
            throw new EETest.Fault("standalone RA classes are available to app.");
        }
        TestUtil.logMsg((String)"Methods called correctly");
    }

    public void cleanup() throws EETest.Fault {
        if (this.ds1 != null) {
            this.ds1.clearLog();
        }
        TestUtil.logMsg((String)"Cleanup");
        try {
            TestUtil.logTrace((String)"Closing connection in cleanup.");
            if (this.con1 != null) {
                this.con1.close();
            }
        }
        catch (Exception sqle) {
            TestUtil.logErr((String)("Exception on cleanup: " + sqle.getMessage()), (Throwable)sqle);
        }
    }
}

