/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.sec.permsxml;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.tests.ejb30.sec.permsxml.PermDDTestIF;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.security.SecurityPermission;
import java.util.Properties;
import java.util.PropertyPermission;

public class Client
extends EETest {
    @EJB(beanName="PermDDTestEJB")
    private static PermDDTestIF ejbref = null;
    @Resource(lookup="java:comp/InAppClientContainer")
    private static Boolean inAppClientContainer;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private static final String AuthUser = "authuser";
    private String authuser = "";
    private String username = "";
    private String password = "";
    private Properties props = null;
    private TSLoginContext lc = null;
    private static final String SEC_MGR_WARNING = "ERROR:  Security Manager is NOT enabled and must be for these tests.  If you have passed these tests while running with Security Manager enabled, you can use keywords to bypass the running of these tests when Security Manager is disabled.";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.authuser = this.props.getProperty(AuthUser);
            this.username = this.props.getProperty(UserNameProp);
            this.password = this.props.getProperty(UserPasswordProp);
            if (inAppClientContainer.booleanValue()) {
                this.logTrace("In ACC.");
            } else {
                this.logTrace("NOT in ACC.");
            }
            this.lc = new TSLoginContext();
            this.lc.login(this.username, this.password);
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void ValidateCustomPerm() throws EETest.Fault {
        this.logTrace("Enterred ValidateCustomPerm()");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            if (ejbref == null) {
                this.logTrace("ValidateCustomPerm:  oh oh -  ejbref == null!");
                throw new EETest.Fault("FAILURE:  unexpected null value for ejbref.");
            }
            this.logTrace("ValidateCustomPerm:  good -  ejbref != null!");
            if (!ejbref.validateCustomPerm()) {
                throw new EETest.Fault("ValidateCustomPerm test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ValidateCustomPerm test failed: ", e);
        }
        this.logMsg("SUCCESS:  ValidateCustomPerm Passed");
    }

    public void ValidateCustomPermInACC() throws EETest.Fault {
        this.logTrace("Starting ValidateCustomPermInACC test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            SecurityPermission perm = new SecurityPermission("CTSPermission1_name");
            this.doCheckPermission(perm);
            this.logTrace("CTSPermission1_name permission okay");
        }
        catch (AccessControlException ex) {
            throw new EETest.Fault("FAILURE:  CTSPermission1_name perm missing, throwing AccessControlException.", ex);
        }
        catch (Exception ex) {
            throw new EETest.Fault("FAILURE:  ValidateCustomPermInACC(), throwing unexpected Exception.", ex);
        }
        this.logMsg("SUCCESS:  ValidateCustomPermInACC Passed.");
    }

    public void ValidateLocalGrantForCustomPerm() throws EETest.Fault {
        this.logTrace("Starting ValidateLocalGrantForCustomPerm test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            if (!ejbref.validateLocalGrantForCustomPerm()) {
                throw new EETest.Fault("ValidateLocalGrantForCustomPerm test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ValidateLocalGrantForCustomPerm test failed:", e);
        }
        this.logMsg("SUCCESS:  ValidateLocalGrantForCustomPerm Passed");
    }

    public void ValidateLocalGrantForCustomPermInACC() throws EETest.Fault {
        this.logTrace("Starting ValidateLocalGrantForCustomPermInACC test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            SecurityPermission perm = new SecurityPermission("CTSPermission2_name");
            this.doCheckPermission(perm);
            this.logMsg("SUCCESS:  ValidateLocalGrantForCustomPermInACC passed.");
        }
        catch (AccessControlException ex) {
            this.logMsg("CTSPermission2_name permission property threw unexpected AccessControlException.");
            throw new EETest.Fault("FAILURE:  validateLocalGrantForCustomPerm() did threw unexpected AccessControlException.", ex);
        }
        catch (Exception ex) {
            throw new EETest.Fault("FAILURE:  ValidateLocalGrantForCustomPermInACC threw unexpected exception.", ex);
        }
        this.logMsg("SUCCESS:  ValidateLocalGrantForCustomPermInACC Passed.");
    }

    public void ValidateRestrictedLocalPerm() throws EETest.Fault {
        this.logTrace("Starting ValidateRestrictedLocalPerm test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            if (!ejbref.validateRestrictedLocalPerm()) {
                throw new EETest.Fault("ValidateRestrictedLocalPerm test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ValidateRestrictedLocalPerm test failed:", e);
        }
        this.logMsg("SUCCESS:  ValidateRestrictedLocalPerm Passed");
    }

    public void ValidateRestrictedLocalPermInACC() throws EETest.Fault {
        this.logTrace("Starting ValidateRestrictedLocalPermInACC test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            PropertyPermission readPropertyPerm = new PropertyPermission("TestPropertyPerm", "read");
            try {
                this.doCheckPermission(readPropertyPerm);
                this.logMsg("ValidateRestrictedLocalPermInACC() has grant for read of TestPropertyPerm");
            }
            catch (AccessControlException ex) {
                throw new EETest.Fault("FAILURE:  ValidateRestrictedLocalPermInACC() threw unexpected exception for read of TestPropertyPerm.", ex);
            }
            catch (NullPointerException ex) {
                throw new EETest.Fault("FAILURE:  ValidateRestrictedLocalPermInACC() threw NullPointerException for read of TestPropertyPerm.", ex);
            }
        }
        catch (Exception ex) {
            throw new EETest.Fault("FAILURE:  ValidateRestrictedLocalPermInACC had unexpected exception.");
        }
        this.logMsg("SUCCESS:  ValidateRestrictedLocalPermInACC Passed.");
    }

    public void ValidateMissingPermFails() throws EETest.Fault {
        this.logTrace("Starting ValidateMissingPermFails test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            if (!ejbref.validateMissingPermFails()) {
                throw new EETest.Fault("ValidateMissingPermFails test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ValidateMissingPermFails test failed:", e);
        }
        this.logMsg("SUCCESS:  ValidateMissingPermFails Passed");
    }

    public void ValidateMissingPermFailsInACC() throws EETest.Fault {
        this.logTrace("Starting ValidateMissingPermFailsInACC test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            SecurityPermission perm = new SecurityPermission("CTSPermission3_name");
            this.doCheckPermission(perm);
            throw new EETest.Fault("FAILURE:  CTSPermission3_name permission okay");
        }
        catch (AccessControlException ex) {
            this.logMsg("CTSPermission3_name does not exist and was caught.");
        }
        catch (Exception ex) {
            throw new EETest.Fault("FAILURE:  ValidateMissingPermFailsInACC threw unexpected exception.", ex);
        }
        this.logMsg("SUCCESS:  ValidateMissingPermFailsInACC Passed.");
    }

    public void ValidateRequiredPermSet() throws EETest.Fault {
        this.logTrace("Starting ValidateRequiredPermSet test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            if (!ejbref.validateRequiredPermSet()) {
                throw new EETest.Fault("ValidateRequiredPermSet test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ValidateRequiredPermSet test failed:", e);
        }
        this.logMsg("SUCCESS:  ValidateRequiredPermSet Passed");
    }

    public void ValidateRequiredPermSetInACC() throws EETest.Fault {
        this.logMsg("Starting ValidateRequiredPermSetInACC test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            RuntimePermission rtperm = new RuntimePermission("loadLibrary.*");
            this.doCheckPermission(rtperm);
            this.logTrace("ValidateRequiredPermSetInACC():  valid perm for: " + rtperm.toString());
            RuntimePermission rtperm2 = new RuntimePermission("queuePrintJob");
            this.doCheckPermission(rtperm2);
            this.logTrace("ValidateRequiredPermSetInACC():  valid perm for: " + rtperm2.toString());
            SocketPermission socperm = new SocketPermission("*", "connect");
            this.doCheckPermission(socperm);
            this.logTrace("ValidateRequiredPermSetInACC():  valid perm for: " + socperm.toString());
            FilePermission fperm = new FilePermission("*", "read");
            this.doCheckPermission(fperm);
            this.logTrace("ValidateRequiredPermSetInACC():  valid perm for: " + fperm.toString());
            PropertyPermission pperm = new PropertyPermission("*", "read");
            this.doCheckPermission(pperm);
            this.logTrace("ValidateRequiredPermSetInACC():  valid perm for: " + pperm.toString());
        }
        catch (AccessControlException ex) {
            throw new EETest.Fault("FAILURE:  validateRequiredPermSet had perm missing, throwing AccessControlException.", ex);
        }
        catch (Exception ex) {
            throw new EETest.Fault("FAILURE:  validateRequiredPermSet had unexpected Exception.", ex);
        }
        this.logMsg("SUCCESS:  ValidateRequiredPermSetInACC Passed.");
    }

    public void ValidateLocalPermsInvalidName() throws EETest.Fault {
        this.logMsg("Starting ValidateLocalPermsInvalidName test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            if (!ejbref.validateLocalPermsInvalidName()) {
                throw new EETest.Fault("ValidateLocalPermsInvalidName test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ValidateLocalPermsInvalidName test failed:", e);
        }
        this.logMsg("SUCCESS:  ValidateLocalPermsInvalidName Passed");
    }

    public void ValidateLocalPermsInvalidNameInACC() throws EETest.Fault {
        this.logMsg("Starting ValidateLocalPermsInvalidNameInACC test");
        try {
            if (null == System.getSecurityManager()) {
                this.logMsg(SEC_MGR_WARNING);
                throw new EETest.Fault(SEC_MGR_WARNING);
            }
            SecurityPermission readPropertyPerm = new SecurityPermission("NonExistingName");
            try {
                this.doCheckPermission(readPropertyPerm);
                throw new EETest.Fault("FAILURE:  ValidateLocalPermsInvalidNameInACC() did not throw expected AccessControlException.");
            }
            catch (AccessControlException ex) {
                this.logMsg("SUCCESS:  ValidateLocalPermsInvalidNameInACC() threw expected AccessControlException");
            }
            catch (NullPointerException ex) {
                throw new EETest.Fault("FAILURE:  ValidateLocalPermsInvalidNameInACC() threw NullPointerException");
            }
            try {
                SecurityPermission perm = new SecurityPermission("CTSPermission_second_name");
                this.doCheckPermission(perm);
                this.logMsg("CTSPermission_second_name permission property granted AccessControlException.");
            }
            catch (AccessControlException ex) {
                throw new EETest.Fault("FAILURE:  ValidateLocalPermsInvalidNameInACC() threw unexpected exception.");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new EETest.Fault("FAILURE:  ValidateLocalPermsInvalidNameInACC had unexpeted exception.");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ValidateLocalPermsInvalidNameInACC test failed:", e);
        }
        this.logMsg("SUCCESS:  ValidateLocalPermsInvalidNameInACC Passed");
    }

    public void doCheckPermission(Permission pp) throws Exception {
        final Permission perm = pp;
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws AccessControlException {
                AccessController.checkPermission(perm);
                return null;
            }
        });
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

