/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.pointertests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonPointer;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;

public class PointerAdd {
    PointerAdd() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 6901 pointer usage for RFC 6902 add operation");
        TestUtil.logMsg((String)"Testing RFC 6901 pointer usage for RFC 6902 add operation");
        this.testAddStringOnEmptyObject(result);
        this.testAddStringOnEmptyArray(result);
        this.testAddStringOnSimpleObject(result);
        this.testAddStringOnSimpleArray(result);
        this.testAddStringOnSimpleArray2(result);
        this.testAddIntOnEmptyObject(result);
        this.testAddIntOnEmptyArray(result);
        this.testAddIntOnSimpleObject(result);
        this.testAddIntOnSimpleArray(result);
        this.testAddIntOnSimpleArray2(result);
        this.testAddBoolOnEmptyObject(result);
        this.testAddBoolOnEmptyArray(result);
        this.testAddBoolOnSimpleObject(result);
        this.testAddBoolOnSimpleArray(result);
        this.testAddBoolOnSimpleArray2(result);
        this.testAddObjectOnEmptyObject(result);
        this.testAddObjectOnEmptyArray(result);
        this.testAddObjectOnSimpleObject(result);
        this.testAddObjectOnSimpleArray(result);
        this.testAddObjectOnSimpleArray2(result);
        this.testAddArrayToReplaceObject(result);
        this.testAddArrayToReplaceDocument(result);
        this.testAddStringArrayToStringArray(result);
        this.testAddStringToNonExistingObject(result);
        return result;
    }

    private void testAddStringOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject check = SimpleValues.createSimpleObjectStr();
        JsonPointer ptr = Json.createPointer((String)"/address");
        JsonObject out = (JsonObject)ptr.add((JsonStructure)in, (JsonValue)Json.createValue((String)"In a galaxy far far away"));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/address\" ADD \"In a galaxy far far away\" failed on empty JSON object");
        }
    }

    private void testAddStringOnEmptyArray(TestResult result) {
        JsonPointer[] ptrs;
        TestUtil.logMsg((String)" - for String on empty JSON array");
        JsonArray in = SimpleValues.createEmptyArray();
        JsonArray check = SimpleValues.createEmptyArrayWithStr();
        for (JsonPointer ptr : ptrs = new JsonPointer[]{Json.createPointer((String)"/0"), Json.createPointer((String)"/-")}) {
            JsonArray out = (JsonArray)ptr.add((JsonStructure)in, (JsonValue)Json.createValue((String)"In a galaxy far far away"));
            if (JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) continue;
            result.fail("Pointer ADD operation", "Pointer \"" + ptr + "\" ADD \"" + "In a galaxy far far away" + "\" failed on empty JSON array");
        }
    }

    private void testAddStringOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject check = SimpleValues.createSimpleObjectWithStr();
        JsonPointer ptr = Json.createPointer((String)"/address");
        JsonObject out = (JsonObject)ptr.add((JsonStructure)in, (JsonValue)Json.createValue((String)"In a galaxy far far away"));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/address\" ADD \"In a galaxy far far away\" failed on simple JSON object");
        }
    }

    private void testAddStringOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 1");
        JsonArray in = SimpleValues.createStringArray1();
        JsonArray checkBefore = SimpleValues.createSimpleStringArrayWithStrBefore();
        JsonArray checkAfter = SimpleValues.createSimpleStringArrayWithStrAfter();
        JsonPointer ptrBefore = Json.createPointer((String)"/0");
        JsonPointer[] ptrsAfter = new JsonPointer[]{Json.createPointer((String)"/1"), Json.createPointer((String)"/-")};
        JsonArray outBefore = (JsonArray)ptrBefore.add((JsonStructure)in, (JsonValue)Json.createValue((String)"In a galaxy far far away"));
        if (!JsonAssert.assertEquals((JsonValue)checkBefore, (JsonValue)outBefore)) {
            result.fail("Pointer ADD operation", "Pointer \"/0\" ADD \"In a galaxy far far away\" failed on simple JSON array");
        }
        for (JsonPointer ptrAfter : ptrsAfter) {
            JsonArray outAfter = (JsonArray)ptrAfter.add((JsonStructure)in, (JsonValue)Json.createValue((String)"In a galaxy far far away"));
            if (JsonAssert.assertEquals((JsonValue)checkAfter, (JsonValue)outAfter)) continue;
            result.fail("Pointer ADD operation", "Pointer \"/1\" ADD \"In a galaxy far far away\" failed on simple JSON array");
        }
    }

    private void testAddStringOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 2");
        JsonArray in = SimpleValues.createStringArray2();
        JsonArray check = SimpleValues.createSimpleStringArray5();
        this.verifyAddValues(result, in, check, new String[]{"/2", "/1", "/0"}, new String[]{"Fifth value", "Third value", "First value"}, "Pointer ADD operation", "Pointers \"/2\", \"/1\", \"/0\" ADD sequence failed on simple JSON array");
        this.verifyAddValues(result, in, check, new String[]{"/0", "/2", "/4"}, new String[]{"First value", "Third value", "Fifth value"}, "Pointer ADD operation", "Pointers \"/0\", \"/2\", \"/4\" ADD sequence failed on simple JSON array");
    }

    private void testAddIntOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject check = SimpleValues.createSimpleObjectInt();
        JsonPointer ptr = Json.createPointer((String)"/age");
        JsonObject out = (JsonObject)ptr.add((JsonStructure)in, (JsonValue)Json.createValue((int)42));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/age\" ADD \"42\" failed on empty JSON object");
        }
    }

    private void testAddIntOnEmptyArray(TestResult result) {
        JsonPointer[] ptrs;
        TestUtil.logMsg((String)" - for int on empty JSON array");
        JsonArray in = SimpleValues.createEmptyArray();
        JsonArray check = SimpleValues.createEmptyArrayWithInt();
        for (JsonPointer ptr : ptrs = new JsonPointer[]{Json.createPointer((String)"/0"), Json.createPointer((String)"/-")}) {
            JsonArray out = (JsonArray)ptr.add((JsonStructure)in, (JsonValue)Json.createValue((int)42));
            if (JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) continue;
            result.fail("Pointer ADD operation", "Pointer \"" + ptr + "\" ADD \"" + 42 + "\" failed on empty JSON array");
        }
    }

    private void testAddIntOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject check = SimpleValues.createSimpleObjectWithInt();
        JsonPointer ptr = Json.createPointer((String)"/age");
        JsonObject out = (JsonObject)ptr.add((JsonStructure)in, (JsonValue)Json.createValue((int)42));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/age\" ADD \"42\" failed on simple JSON object");
        }
    }

    private void testAddIntOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 1");
        JsonArray in = SimpleValues.createIntArray1();
        JsonArray checkBefore = SimpleValues.createSimpleIntArrayWithIntBefore();
        JsonArray checkAfter = SimpleValues.createSimpleIntArrayWithIntAfter();
        JsonPointer ptrBefore = Json.createPointer((String)"/0");
        JsonPointer[] ptrsAfter = new JsonPointer[]{Json.createPointer((String)"/1"), Json.createPointer((String)"/-")};
        JsonArray outBefore = (JsonArray)ptrBefore.add((JsonStructure)in, (JsonValue)Json.createValue((int)42));
        if (!JsonAssert.assertEquals((JsonValue)checkBefore, (JsonValue)outBefore)) {
            result.fail("Pointer ADD operation", "Pointer \"/0\" ADD \"42\" failed on simple JSON array");
        }
        for (JsonPointer ptrAfter : ptrsAfter) {
            JsonArray outAfter = (JsonArray)ptrAfter.add((JsonStructure)in, (JsonValue)Json.createValue((int)42));
            if (JsonAssert.assertEquals((JsonValue)checkAfter, (JsonValue)outAfter)) continue;
            result.fail("Pointer ADD operation", "Pointer \"/1\" ADD \"42\" failed on simple JSON array");
        }
    }

    private void testAddIntOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 2");
        JsonArray in = SimpleValues.createIntArray2();
        JsonArray check = SimpleValues.createSimpleIntArray5();
        this.verifyAddValues(result, in, check, new String[]{"/2", "/1", "/0"}, new Integer[]{5, 3, 1}, "Pointer ADD operation", "Pointers \"/2\", \"/1\", \"/0\" ADD sequence failed on simple JSON array");
        this.verifyAddValues(result, in, check, new String[]{"/0", "/2", "/4"}, new Integer[]{1, 3, 5}, "Pointer ADD operation", "Pointers \"/0\", \"/2\", \"/4\" ADD sequence failed on simple JSON array");
    }

    private void testAddBoolOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject check = SimpleValues.createSimpleObjectBool();
        JsonPointer ptr = Json.createPointer((String)"/married");
        JsonObject out = (JsonObject)ptr.add((JsonStructure)in, SimpleValues.toJsonValue(true));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/married\" ADD \"true\" failed on empty JSON object");
        }
    }

    private void testAddBoolOnEmptyArray(TestResult result) {
        JsonPointer[] ptrs;
        TestUtil.logMsg((String)" - for boolean on empty JSON array");
        JsonArray in = SimpleValues.createEmptyArray();
        JsonArray check = SimpleValues.createEmptyArrayWithBool();
        for (JsonPointer ptr : ptrs = new JsonPointer[]{Json.createPointer((String)"/0"), Json.createPointer((String)"/-")}) {
            JsonArray out = (JsonArray)ptr.add((JsonStructure)in, SimpleValues.toJsonValue(true));
            if (JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) continue;
            result.fail("Pointer ADD operation", "Pointer \"" + ptr + "\" ADD \"" + true + "\" failed on empty JSON array");
        }
    }

    private void testAddBoolOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonObject check = SimpleValues.createSimpleObjectWithBool();
        JsonPointer ptr = Json.createPointer((String)"/married");
        JsonObject out = (JsonObject)ptr.add((JsonStructure)in, SimpleValues.toJsonValue(true));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/married\" ADD \"true\" failed on simple JSON object");
        }
    }

    private void testAddBoolOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 1");
        JsonArray in = SimpleValues.createBoolArray1();
        JsonArray checkBefore = SimpleValues.createSimpleBoolArrayWithBoolBefore();
        JsonArray checkAfter = SimpleValues.createSimpleBoolArrayWithBoolAfter();
        JsonPointer ptrBefore = Json.createPointer((String)"/0");
        JsonPointer[] ptrsAfter = new JsonPointer[]{Json.createPointer((String)"/1"), Json.createPointer((String)"/-")};
        JsonArray outBefore = (JsonArray)ptrBefore.add((JsonStructure)in, SimpleValues.toJsonValue(false));
        if (!JsonAssert.assertEquals((JsonValue)checkBefore, (JsonValue)outBefore)) {
            result.fail("Pointer ADD operation", "Pointer \"/0\" ADD \"false\" failed on simple JSON array");
        }
        for (JsonPointer ptrAfter : ptrsAfter) {
            JsonArray outAfter = (JsonArray)ptrAfter.add((JsonStructure)in, SimpleValues.toJsonValue(false));
            if (JsonAssert.assertEquals((JsonValue)checkAfter, (JsonValue)outAfter)) continue;
            result.fail("Pointer ADD operation", "Pointer \"/1\" ADD \"false\" failed on simple JSON array");
        }
    }

    private void testAddBoolOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 2");
        JsonArray in = SimpleValues.createBoolArray2();
        JsonArray check = SimpleValues.createSimpleBoolArray5();
        this.verifyAddValues(result, in, check, new String[]{"/2", "/1", "/0"}, new Boolean[]{true, true, false}, "Pointer ADD operation", "Pointers \"/2\", \"/1\", \"/0\" ADD sequence failed on simple JSON array");
        this.verifyAddValues(result, in, check, new String[]{"/0", "/2", "/4"}, new Boolean[]{false, true, true}, "Pointer ADD operation", "Pointers \"/0\", \"/2\", \"/4\" ADD sequence failed on simple JSON array");
    }

    private void testAddObjectOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        JsonObject check = SimpleValues.createSimpleObjectObject();
        JsonPointer ptr = Json.createPointer((String)"/wife");
        JsonObject out = (JsonObject)ptr.add((JsonStructure)in, (JsonValue)SimpleValues.OBJ_VALUE);
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/wife\" ADD \"" + SimpleValues.OBJ_VALUE + "\" failed on empty JSON object");
        }
    }

    private void testAddObjectOnEmptyArray(TestResult result) {
        JsonPointer[] ptrs;
        TestUtil.logMsg((String)" - for JsonObject on empty JSON array");
        JsonArray in = SimpleValues.createEmptyArray();
        JsonArray check = SimpleValues.createEmptyArrayWithObject();
        for (JsonPointer ptr : ptrs = new JsonPointer[]{Json.createPointer((String)"/0"), Json.createPointer((String)"/-")}) {
            JsonArray out = (JsonArray)ptr.add((JsonStructure)in, (JsonValue)SimpleValues.OBJ_VALUE);
            if (JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) continue;
            result.fail("Pointer ADD operation", "Pointer \"" + ptr + "\" ADD \"" + SimpleValues.OBJ_VALUE + "\" failed on empty JSON array");
        }
    }

    private void testAddObjectOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON object");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonObject check = SimpleValues.createCompoundObjectWithObject();
        JsonPointer ptr = Json.createPointer((String)"/wife");
        JsonObject out = (JsonObject)ptr.add((JsonStructure)in, (JsonValue)SimpleValues.OBJ_VALUE);
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/wife\" ADD \"" + SimpleValues.OBJ_VALUE + "\" failed on simple JSON object");
        }
    }

    private void testAddObjectOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 1");
        JsonArray in = SimpleValues.createObjectArray1();
        JsonArray checkBefore = SimpleValues.createSimpleObjectArrayWithObjectBefore();
        JsonArray checkAfter = SimpleValues.createSimpleObjectArrayWithObjectAfter();
        JsonPointer ptrBefore = Json.createPointer((String)"/0");
        JsonPointer[] ptrsAfter = new JsonPointer[]{Json.createPointer((String)"/1"), Json.createPointer((String)"/-")};
        JsonArray outBefore = (JsonArray)ptrBefore.add((JsonStructure)in, (JsonValue)SimpleValues.OBJ_VALUE);
        if (!JsonAssert.assertEquals((JsonValue)checkBefore, (JsonValue)outBefore)) {
            result.fail("Pointer ADD operation", "Pointer \"/0\" ADD \"" + SimpleValues.OBJ_VALUE + "\" failed on simple JSON array");
        }
        for (JsonPointer ptrAfter : ptrsAfter) {
            JsonArray outAfter = (JsonArray)ptrAfter.add((JsonStructure)in, (JsonValue)SimpleValues.OBJ_VALUE);
            if (JsonAssert.assertEquals((JsonValue)checkAfter, (JsonValue)outAfter)) continue;
            result.fail("Pointer ADD operation", "Pointer \"/1\" ADD \"" + SimpleValues.OBJ_VALUE + "\" failed on simple JSON array");
        }
    }

    private void testAddObjectOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 2");
        JsonArray in = SimpleValues.createObjectArray2();
        JsonArray check = SimpleValues.createSimpleObjectArray5();
        this.verifyAddValues(result, in, check, new String[]{"/2", "/1", "/0"}, new JsonObject[]{SimpleValues.OBJ_VALUE_5, SimpleValues.OBJ_VALUE_3, SimpleValues.OBJ_VALUE_1}, "Pointer ADD operation", "Pointers \"/2\", \"/1\", \"/0\" ADD sequence failed on simple JSON array");
        this.verifyAddValues(result, in, check, new String[]{"/0", "/2", "/4"}, new JsonObject[]{SimpleValues.OBJ_VALUE_1, SimpleValues.OBJ_VALUE_3, SimpleValues.OBJ_VALUE_5}, "Pointer ADD operation", "Pointers \"/0\", \"/2\", \"/4\" ADD sequence failed on simple JSON array");
    }

    private void testAddArrayToReplaceObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonArray to replace JsonObject");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonObject check = SimpleValues.createCompoundObjectWithObjectReplaced();
        JsonPointer ptr = Json.createPointer((String)"/child");
        JsonArray replace = SimpleValues.createSimpleStringArray5();
        JsonObject out = (JsonObject)ptr.add((JsonStructure)in, (JsonValue)replace);
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/child\" ADD array to replace existing object failed on compound JSON object");
        }
    }

    private void testAddArrayToReplaceDocument(TestResult result) {
        TestUtil.logMsg((String)" - for JsonArray to replace whole document");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonArray check = SimpleValues.createSimpleStringArray5();
        JsonPointer ptr = Json.createPointer((String)"");
        JsonArray replace = SimpleValues.createSimpleStringArray5();
        JsonStructure out = ptr.add((JsonStructure)in, (JsonValue)replace);
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/child\" ADD array to replace existing object failed on compound JSON object");
        }
    }

    private void testAddStringArrayToStringArray(TestResult result) {
        TestUtil.logMsg((String)" - for String array to be added to existing String array");
        JsonArray in = SimpleValues.createStringArray2();
        JsonArray check = SimpleValues.createStringArray2WithStringArrayInTheMiddle();
        JsonArray arrayToAdd = SimpleValues.createStringInnerArray2();
        JsonPointer ptr = Json.createPointer((String)"/1");
        JsonArray out = (JsonArray)ptr.add((JsonStructure)in, (JsonValue)arrayToAdd);
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer ADD operation", "Pointer \"/1\" ADD array failed on JSON array");
        }
    }

    private void testAddStringToNonExistingObject(TestResult result) {
        TestUtil.logMsg((String)" - for String to be added to non existing JsonObject");
        JsonObject in = SimpleValues.createSimpleObject();
        JsonPointer ptr = Json.createPointer((String)"/child/address");
        boolean exception = false;
        try {
            ptr.add((JsonStructure)in, (JsonValue)Json.createValue((String)"In a galaxy far far away"));
        }
        catch (JsonException e) {
            exception = true;
            TestUtil.logMsg((String)("    - Expected exception: " + e.getMessage()));
        }
        if (!exception) {
            result.fail("Pointer ADD operation", "ADD operation on non existing JsonObject \"/child\" passed");
        }
    }

    private void verifyAddValues(TestResult result, JsonArray in, JsonArray check, String[] paths, Object[] values, String testName, String errorMessage) {
        if (paths.length != values.length) {
            throw new IllegalArgumentException("Number of paths does not match number of indexes");
        }
        JsonArray out = in;
        for (int i = 0; i < paths.length; ++i) {
            JsonPointer ptr = Json.createPointer((String)paths[i]);
            out = (JsonArray)ptr.add((JsonStructure)out, SimpleValues.toJsonValue(values[i]));
        }
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail(testName, errorMessage);
        }
    }
}

