/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.oneXone.bi.delete;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.delete.ADVC;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.delete.ALocal;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.delete.ALocalHome;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.delete.BDVC;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.delete.BLocal;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.delete.BLocalHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.RemoveException;
import java.util.Properties;
import javax.naming.NamingException;

public abstract class BeanEJB
implements EntityBean {
    private static final int NO_RELATION_SET = 0;
    private static final int NULL_RELATION_SET = 1;
    private static final int RELATION_SET = 2;
    private static final String ALocal = "java:comp/env/ejb/ALocal";
    private static final String BLocal = "java:comp/env/ejb/BLocal";
    private EntityContext context = null;
    private TSNamingContext nctx = null;

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract int getValue();

    public abstract void setValue(int var1);

    public abstract ALocal getA1();

    public abstract void setA1(ALocal var1);

    public abstract ALocal getA2();

    public abstract void setA2(ALocal var1);

    public abstract BLocal getB1();

    public abstract void setB1(BLocal var1);

    public abstract BLocal getB2();

    public abstract void setB2(BLocal var1);

    private ALocal createALocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createALocal");
        TestUtil.logMsg((String)"Obtain naming context");
        this.nctx = new TSNamingContext();
        ALocalHome aLocalHome = (ALocalHome)this.nctx.lookup(ALocal);
        ALocal aLocal = aLocalHome.create(id, name, value);
        return aLocal;
    }

    private BLocal createBLocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createBLocal");
        TestUtil.logMsg((String)"Obtain naming context");
        this.nctx = new TSNamingContext();
        BLocalHome bLocalHome = (BLocalHome)this.nctx.lookup(BLocal);
        BLocal bLocal = bLocalHome.create(id, name, value);
        return bLocal;
    }

    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public boolean test1() {
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal b1 = null;
        ALocal a1 = null;
        try {
            aOne = this.getA1();
            bOne = this.getB1();
            b1 = aOne.getB();
            a1 = bOne.getA();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)"Delete entitybean object B1");
            bOne.remove();
            TestUtil.logMsg((String)"Attempt to call a method on B1");
            bOne.getId();
            TestUtil.logErr((String)"Entitybean object B1 was not deleted, expected EJBException");
            return false;
        }
        catch (EJBException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"Entitybean object B1 was deleted");
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean test2() {
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal b1 = null;
        ALocal a1 = null;
        try {
            aOne = this.getA1();
            bOne = this.getB1();
            b1 = aOne.getB();
            a1 = bOne.getA();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)"Delete entitybean object B1");
            bOne.remove();
            TestUtil.logMsg((String)"Check relationship accessor method of entitybean object A1");
            TestUtil.logMsg((String)("aOne.getB() = " + aOne.getB()));
            if (aOne.getB() != null) {
                TestUtil.logErr((String)"Relationship accessor method of A1 returns not null");
                return false;
            }
            TestUtil.logMsg((String)"Relationship accessor method of A1 returns null");
            TestUtil.logMsg((String)"Check relationship accessor method of BeanEJB");
            TestUtil.logMsg((String)("getB1() = " + this.getB1()));
            if (this.getB1() == null) {
                TestUtil.logMsg((String)"Relationship accessor method of BeanEJB returns null");
                return true;
            }
            TestUtil.logErr((String)"Relationship accessor method of BeanEJB returns not null");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean test3() {
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal b1 = null;
        ALocal a1 = null;
        try {
            aOne = this.getA1();
            bOne = this.getB1();
            b1 = aOne.getB();
            a1 = bOne.getA();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)"Delete entitybean object B1");
            bOne.remove();
            TestUtil.logMsg((String)"Accessor method of B1 must throw EJBException");
            TestUtil.logMsg((String)"Calling bOne.getA(), expect EJBException");
            bOne.getA();
            TestUtil.logErr((String)"Did not get expected EJBException");
            return false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Caught expected EJBException");
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean test4() {
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal b1 = null;
        ALocal a1 = null;
        boolean pass = true;
        try {
            aOne = this.getA1();
            bOne = this.getB1();
            b1 = aOne.getB();
            a1 = bOne.getA();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)"Delete entitybean object B1");
            bOne.remove();
            TestUtil.logMsg((String)"Assigning B1 to BeanEJB must throw IllegalArgumentException");
            TestUtil.logMsg((String)"Calling setB1(bOne), expect IllegalArgumentException");
            this.setB1(bOne);
            TestUtil.logErr((String)"Did not get expected IllegalArgumentException");
            pass = false;
        }
        catch (IllegalArgumentException e) {
            TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e), (Throwable)e);
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"Assigning B1 to A1 must throw EJBException");
            TestUtil.logMsg((String)"Calling aOne.setB(bOne), expect EJBException");
            aOne.setB(bOne);
            TestUtil.logErr((String)"Did not get expected EJBException");
            pass = false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Caught expected EJBException");
            TestUtil.logMsg((String)("Exception: " + (Object)((Object)e)));
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e), (Throwable)e);
            pass = false;
        }
        return pass;
    }

    public String ejbCreate(String id, String name, int value, ADVC a, BDVC b, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setName(name);
            this.setValue(value);
            this.setId(id);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC a, BDVC b, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            ALocal a1 = null;
            BLocal b1 = null;
            switch (flag) {
                case 0: {
                    a1 = this.createALocal(a.getId(), a.getName(), a.getValue());
                    b1 = this.createBLocal(b.getId(), b.getName(), b.getValue());
                    break;
                }
                case 1: {
                    a1 = this.createALocal(a.getId(), a.getName(), a.getValue());
                    b1 = this.createBLocal(b.getId(), b.getName(), b.getValue());
                    break;
                }
                case 2: {
                    a1 = this.createALocal(a.getId(), a.getName(), a.getValue());
                    b1 = this.createBLocal(b.getId(), b.getName(), b.getValue());
                    a1.setB(b1);
                    b1.setA(a1);
                }
            }
            this.setA1(a1);
            this.setB1(b1);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public String ejbCreate(String id, String name, int value, ADVC aOne, BDVC bOne, ADVC aTwo, BDVC bTwo) throws CreateException {
        TestUtil.logTrace((String)"ejbCreateWith");
        try {
            this.setId(id);
            this.setName(name);
            this.setValue(value);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC aOne, BDVC bOne, ADVC aTwo, BDVC bTwo) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            BLocal b1 = this.createBLocal(bOne.getId(), bOne.getName(), bOne.getValue());
            ALocal a1 = this.createALocal(aOne.getId(), aOne.getName(), aOne.getValue());
            BLocal b2 = this.createBLocal(bTwo.getId(), bTwo.getName(), bTwo.getValue());
            ALocal a2 = this.createALocal(aTwo.getId(), aTwo.getName(), aTwo.getValue());
            this.setA1(a1);
            this.setA2(a2);
            this.setB1(b1);
            this.setB2(b2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.context = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("NamingException ... " + e), (Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("Exception occurred: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        TestUtil.logMsg((String)("getA1() = " + this.getA1()));
        TestUtil.logMsg((String)("getA2() = " + this.getA2()));
        TestUtil.logMsg((String)("getB1() = " + this.getB1()));
        TestUtil.logMsg((String)("getB2() = " + this.getB2()));
        if (this.getA1() != null) {
            TestUtil.logMsg((String)"deleting entitybean object A1 ...");
            this.getA1().remove();
        }
        if (this.getA2() != null) {
            TestUtil.logMsg((String)"deleting entitybean object A2 ...");
            this.getA2().remove();
        }
        if (this.getB1() != null) {
            TestUtil.logMsg((String)"deleting entitybean object B1 ...");
            this.getB1().remove();
        }
        if (this.getB2() != null) {
            TestUtil.logMsg((String)"deleting entitybean object B2 ...");
            this.getB2().remove();
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }
}

