/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonvaluetests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;

public class Value {
    Value() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonValue API methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonValue API methods added in JSON-P 1.1.");
        this.testAsJsonObject(result);
        this.testAsJsonObjectOnNonObject(result);
        this.testAsJsonArray(result);
        this.testAsJsonArrayOnNonArray(result);
        return result;
    }

    private void testAsJsonObject(TestResult result) {
        JsonObject[] values;
        TestUtil.logMsg((String)" - asJsonObject() on JsonObject instances");
        JsonObject[] jsonObjectArray = values = new JsonObject[]{SimpleValues.createEmptyObject(), SimpleValues.createSimpleObjectStr(), SimpleValues.createSimpleObjectInt(), SimpleValues.createSimpleObjectBool(), SimpleValues.createSimpleObjectObject(), SimpleValues.createCompoundObject()};
        int n = jsonObjectArray.length;
        for (int i = 0; i < n; ++i) {
            JsonObject objValue;
            JsonObject value = objValue = jsonObjectArray[i];
            JsonObject out = objValue.asJsonObject();
            if (!this.operationFailed((JsonValue)objValue, (JsonValue)out)) continue;
            result.fail("asJsonObject()", "Output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)objValue));
        }
    }

    private void testAsJsonObjectOnNonObject(TestResult result) {
        JsonValue[] values;
        TestUtil.logMsg((String)" - asJsonObject() on non JsonObject instances");
        for (JsonValue value : values = new JsonValue[]{SimpleValues.createEmptyArrayWithStr(), SimpleValues.createEmptyArrayWithInt(), SimpleValues.createEmptyArrayWithBool(), SimpleValues.createEmptyArrayWithObject(), SimpleValues.toJsonValue("In a galaxy far far away"), SimpleValues.toJsonValue(42), SimpleValues.toJsonValue(9223372036854775765L), SimpleValues.toJsonValue(3.441073578556931E305), SimpleValues.toJsonValue(SimpleValues.BIN_VALUE), SimpleValues.toJsonValue(SimpleValues.BDC_VALUE), SimpleValues.toJsonValue(true), SimpleValues.toJsonValue(null)}) {
            try {
                value.asJsonObject();
                result.fail("asJsonObject()", "Call of asJsonObject() on non JsonObject instance shall throw ClassCastException");
            }
            catch (ClassCastException ex) {
                TestUtil.logMsg((String)("    - Expected exception: " + ex.getMessage()));
            }
            catch (Throwable t) {
                result.fail("asJsonObject()", "Call of asJsonObject() on non JsonObject instance shall throw ClassCastException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testAsJsonArray(TestResult result) {
        JsonArray[] values;
        TestUtil.logMsg((String)" - asJsonArray() on JsonArray instances");
        JsonArray[] jsonArrayArray = values = new JsonArray[]{SimpleValues.createEmptyArray(), SimpleValues.createEmptyArrayWithStr(), SimpleValues.createEmptyArrayWithInt(), SimpleValues.createEmptyArrayWithBool(), SimpleValues.createEmptyArrayWithObject(), SimpleValues.createSimpleStringArray5(), SimpleValues.createSimpleIntArray5(), SimpleValues.createSimpleBoolArray5(), SimpleValues.createSimpleObjectArray5()};
        int n = jsonArrayArray.length;
        for (int i = 0; i < n; ++i) {
            JsonArray objValue;
            JsonArray value = objValue = jsonArrayArray[i];
            JsonArray out = objValue.asJsonArray();
            if (!this.operationFailed((JsonValue)objValue, (JsonValue)out)) continue;
            result.fail("asJsonArray()", "Output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)objValue));
        }
    }

    private void testAsJsonArrayOnNonArray(TestResult result) {
        JsonValue[] values;
        TestUtil.logMsg((String)" - asJsonArray() on non JsonArray instances");
        for (JsonValue value : values = new JsonValue[]{SimpleValues.createSimpleObjectStr(), SimpleValues.createSimpleObjectInt(), SimpleValues.createSimpleObjectBool(), SimpleValues.createSimpleObjectObject(), SimpleValues.createCompoundObject(), SimpleValues.toJsonValue("In a galaxy far far away"), SimpleValues.toJsonValue(42), SimpleValues.toJsonValue(9223372036854775765L), SimpleValues.toJsonValue(3.441073578556931E305), SimpleValues.toJsonValue(SimpleValues.BIN_VALUE), SimpleValues.toJsonValue(SimpleValues.BDC_VALUE), SimpleValues.toJsonValue(true), SimpleValues.toJsonValue(null)}) {
            try {
                value.asJsonArray();
                result.fail("asJsonArray()", "Call of asJsonArray() on non JsonArray instance shall throw ClassCastException");
            }
            catch (ClassCastException ex) {
                TestUtil.logMsg((String)("    - Expected exception: " + ex.getMessage()));
            }
            catch (Throwable t) {
                result.fail("asJsonArray()", "Call of asJsonArray() on non JsonArray instance shall throw ClassCastException, not " + t.getClass().getSimpleName());
            }
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

