/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunkartifacts.ConnectionHelper;
import com.ibm.jbatch.tck.artifacts.chunktypes.InventoryRecord;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemWriter;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@Named(value="inventoryWriter")
public class InventoryWriter
extends AbstractItemWriter {
    protected DataSource dataSource = null;
    @Inject
    @BatchProperty(name="forced.fail.count")
    String forcedFailCountProp;
    @Inject
    @BatchProperty(name="dummy.delay.seconds")
    String dummyDelayProp;
    int forcedFailCount;
    int dummyDelay = -1;
    int writerIndex = 0;

    public void open(Serializable cpd) throws NamingException {
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("java:module/env/jdbc/orderDB");
        this.forcedFailCount = Integer.parseInt(this.forcedFailCountProp);
        this.dummyDelay = Integer.parseInt(this.dummyDelayProp);
    }

    public void writeItems(List<Object> records) throws Exception {
        int itemID = -1;
        int quantity = -1;
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = ConnectionHelper.getConnection(this.dataSource);
            for (Object record : records) {
                itemID = ((InventoryRecord)record).getItemID();
                quantity = ((InventoryRecord)record).getQuantity();
                statement = connection.prepareStatement("insert into Orders values(DEFAULT, ?, ?)");
                statement.setInt(1, itemID);
                statement.setInt(2, quantity);
                int rs = statement.executeUpdate();
                ++this.writerIndex;
                if (this.forcedFailCount == 0 || this.writerIndex < this.forcedFailCount) continue;
                if (this.dummyDelay > 0) {
                    Thread.sleep(this.dummyDelay);
                    this.forcedFailCount = 0;
                    this.dummyDelay = 0;
                    continue;
                }
                throw new Exception("Fail on purpose in InventoryRecord.readItem()");
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            ConnectionHelper.cleanupConnection(connection, null, statement);
        }
    }
}

