/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.override.table;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.override.table.NoTableAnnotation;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final Long ID = 1L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception:test failed ", (Throwable)e);
        }
    }

    public void testNoTableAnnotation() throws EETest.Fault {
        NoTableAnnotation entity = new NoTableAnnotation();
        entity.setId(ID);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)("persisting entity" + entity));
            this.getEntityManager().persist((Object)entity);
            TestUtil.logTrace((String)"flushing");
            this.getEntityManager().flush();
            TestUtil.logTrace((String)"Test Passed");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"test failed");
            throw new EETest.Fault(e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

