/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.jmsconsumertests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.core20.appclient.jmsconsumertests.MyMessageListener;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.appclient.jmsconsumertests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    transient ConnectionFactory cf = null;
    transient JMSContext context = null;
    transient JMSContext contextToSendMsg = null;
    transient JMSContext contextToCreateMsg = null;
    transient JMSConsumer consumer = null;
    transient JMSProducer producer = null;
    transient Destination destination = null;
    transient Queue queue = null;
    transient Topic topic = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    boolean queueTest = false;
    boolean topicTest = false;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            TestUtil.logMsg((String)"Didn't get expected exception");
            throw new Exception("Didn't get expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"Close JMSContext objects");
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            if (this.contextToSendMsg != null) {
                this.contextToSendMsg.close();
                this.contextToSendMsg = null;
            }
            if (this.contextToCreateMsg != null) {
                this.contextToCreateMsg.close();
                this.contextToCreateMsg = null;
            }
            TestUtil.logMsg((String)"Close JMSConsumer objects");
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            TestUtil.logMsg((String)"Closing default Connection");
            this.tool.getDefaultConnection().close();
            if (this.queueTest) {
                TestUtil.logMsg((String)"Flush any messages left on Queue");
                this.tool.flushDestination();
            }
            this.tool.closeAllResources();
            this.producer = null;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new EETest.Fault("cleanup failed!", e);
        }
    }

    public void queueSendRecvMessageListenerTest() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON QUEUE");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.tool.getDefaultConnection().close();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            this.queueTest = true;
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
            this.contextToCreateMsg = this.cf.createContext(this.user, this.password, 1);
            TestUtil.logMsg((String)"Create JMSProducer");
            this.producer = this.contextToSendMsg.createProducer();
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            MyMessageListener listener = new MyMessageListener();
            this.consumer.setMessageListener((MessageListener)listener);
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.contextToCreateMsg.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "queueSendRecvMessageListenerTest");
            TestUtil.logMsg((String)"Send the TestMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 0; i < 60; ++i) {
                TestUtil.sleepSec((int)2);
                if (listener.isComplete()) {
                    listener.setComplete(false);
                    actTextMessage = (TextMessage)listener.getMessage();
                    TestUtil.logMsg((String)("Received TextMessage after polling loop " + (i + 1)));
                    break;
                }
                TestUtil.logMsg((String)("Completed polling loop " + i));
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage (actTextMessage=NULL)");
            }
            TestUtil.logMsg((String)"Check value of TextMessage returned");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logErr((String)("Received [" + actTextMessage.getText() + "] expected [" + expTextMessage.getText() + "]"));
                pass = false;
            }
            TestUtil.logMsg((String)"Retreive MessageListener by calling consumer.getMessageListener()");
            MessageListener messageListener = this.consumer.getMessageListener();
            if (messageListener == null) {
                TestUtil.logErr((String)"getMessageListener() returned NULL");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("queueSendRecvMessageListenerTest", e);
        }
        if (!pass) {
            throw new EETest.Fault("queueSendRecvMessageListenerTest failed");
        }
    }

    public void topicSendRecvMessageListenerTest() throws EETest.Fault {
        boolean pass = true;
        String message = "Where are you!";
        try {
            TestUtil.logMsg((String)"Setup JmsTool for COMMON TOPIC");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.tool.getDefaultConnection().close();
            this.destination = this.tool.getDefaultDestination();
            this.topic = (Topic)this.destination;
            this.topicTest = true;
            TestUtil.logMsg((String)"Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
            this.contextToCreateMsg = this.cf.createContext(this.user, this.password, 1);
            TestUtil.logMsg((String)"Create JMSProducer");
            this.producer = this.contextToSendMsg.createProducer();
            TestUtil.logMsg((String)"Create JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            MyMessageListener listener = new MyMessageListener();
            this.consumer.setMessageListener((MessageListener)listener);
            TestUtil.logMsg((String)"Creating TextMessage");
            TextMessage expTextMessage = this.contextToCreateMsg.createTextMessage(message);
            TestUtil.logMsg((String)"Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "topicSendRecvMessageListenerTest");
            TestUtil.logMsg((String)"Send the TestMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            TestUtil.logMsg((String)"Poll listener waiting for TestMessage to arrive");
            TextMessage actTextMessage = null;
            for (int i = 1; i < 60; ++i) {
                TestUtil.sleepSec((int)2);
                if (listener.isComplete()) {
                    listener.setComplete(false);
                    actTextMessage = (TextMessage)listener.getMessage();
                    TestUtil.logMsg((String)("Received TextMessage after polling loop " + i));
                    break;
                }
                TestUtil.logMsg((String)("Completed polling loop " + i));
            }
            if (actTextMessage == null) {
                throw new EETest.Fault("Did not receive TextMessage (actTextMessage=NULL)");
            }
            TestUtil.logMsg((String)"Check value of TextMessage returned");
            if (!actTextMessage.getText().equals(expTextMessage.getText())) {
                TestUtil.logErr((String)("Received [" + actTextMessage.getText() + "] expected [" + expTextMessage.getText() + "]"));
                pass = false;
            }
            TestUtil.logMsg((String)"Retreive MessageListener by calling consumer.getMessageListener()");
            MessageListener messageListener = this.consumer.getMessageListener();
            if (messageListener == null) {
                TestUtil.logErr((String)"getMessageListener() returned NULL");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("topicSendRecvMessageListenerTest", e);
        }
        if (!pass) {
            throw new EETest.Fault("topicSendRecvMessageListenerTest failed");
        }
    }
}

