/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.patchtests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.patchtests.CommonOperation;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatchBuilder;
import jakarta.json.JsonValue;

public class PatchOperationRemove
extends CommonOperation {
    private final String OPERATION = "REMOVE";

    PatchOperationRemove() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 6902 remove operation");
        TestUtil.logMsg((String)"Testing RFC 6902 remove operation:");
        this.testRemoveStringOnEmptyObject(result);
        this.testRemoveStringOnEmptyArray(result);
        this.testRemoveStringOnSimpleObject(result);
        this.testRemoveStringOnSimpleArray(result);
        this.testRemoveStringOnSimpleArray2(result);
        this.testRemoveIntOnEmptyObject(result);
        this.testRemoveIntOnEmptyArray(result);
        this.testRemoveIntOnSimpleObject(result);
        this.testRemoveIntOnSimpleArray(result);
        this.testRemoveIntOnSimpleArray2(result);
        this.testRemoveBoolOnEmptyObject(result);
        this.testRemoveBoolOnEmptyArray(result);
        this.testRemoveBoolOnSimpleObject(result);
        this.testRemoveBoolOnSimpleArray(result);
        this.testRemoveBoolOnSimpleArray2(result);
        this.testRemoveObjectOnEmptyObject(result);
        this.testRemoveObjectOnEmptyArray(result);
        this.testRemoveObjectOnSimpleObject(result);
        this.testRemoveObjectOnSimpleArray(result);
        this.testRemoveObjectOnSimpleArray2(result);
        this.testRemoveFromNonExistingLocationInObject(result);
        this.testRemoveFromNonExistingLocationInArray(result);
        return result;
    }

    private void testRemoveStringOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for String to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectStr();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/address", null);
    }

    private void testRemoveStringOnEmptyArray(TestResult result) {
        TestUtil.logMsg((String)" - for String to produce empty JSON array");
        JsonArray in = SimpleValues.createEmptyArrayWithStr();
        JsonArray check = SimpleValues.createEmptyArray();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", null);
    }

    private void testRemoveStringOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithStr();
        JsonObject check = SimpleValues.createSimpleObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/address", null);
    }

    private void testRemoveStringOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 2");
        JsonArray inBefore = SimpleValues.createSimpleStringArrayWithStrBefore();
        JsonArray inAfter = SimpleValues.createSimpleStringArrayWithStrAfter();
        JsonArray check = SimpleValues.createStringArray1();
        this.simpleOperation(result, (JsonValue)inBefore, (JsonValue)check, "/0", null);
        this.simpleOperation(result, (JsonValue)inAfter, (JsonValue)check, "/1", null);
    }

    private void testRemoveStringOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleStringArray5();
        JsonArray check = SimpleValues.createStringArray2();
        this.complexOperation(result, in, check, new String[]{"/4", "/2", "/0"});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/2"});
    }

    private void testRemoveIntOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for int to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectInt();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/age", null);
    }

    private void testRemoveIntOnEmptyArray(TestResult result) {
        TestUtil.logMsg((String)" - for int to produce empty JSON array");
        JsonArray in = SimpleValues.createEmptyArrayWithInt();
        JsonArray check = SimpleValues.createEmptyArray();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", null);
    }

    private void testRemoveIntOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithInt();
        JsonObject check = SimpleValues.createSimpleObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/age", null);
    }

    private void testRemoveIntOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 2");
        JsonArray inBefore = SimpleValues.createSimpleIntArrayWithIntBefore();
        JsonArray inAfter = SimpleValues.createSimpleIntArrayWithIntAfter();
        JsonArray check = SimpleValues.createIntArray1();
        this.simpleOperation(result, (JsonValue)inBefore, (JsonValue)check, "/0", null);
        this.simpleOperation(result, (JsonValue)inAfter, (JsonValue)check, "/1", null);
    }

    private void testRemoveIntOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleIntArray5();
        JsonArray check = SimpleValues.createIntArray2();
        this.complexOperation(result, in, check, new String[]{"/4", "/2", "/0"});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/2"});
    }

    private void testRemoveBoolOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectBool();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/married", null);
    }

    private void testRemoveBoolOnEmptyArray(TestResult result) {
        TestUtil.logMsg((String)" - for boolean to produce empty JSON array");
        JsonArray in = SimpleValues.createEmptyArrayWithBool();
        JsonArray check = SimpleValues.createEmptyArray();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", null);
    }

    private void testRemoveBoolOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectWithBool();
        JsonObject check = SimpleValues.createSimpleObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/married", null);
    }

    private void testRemoveBoolOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 2");
        JsonArray inBefore = SimpleValues.createSimpleBoolArrayWithBoolBefore();
        JsonArray inAfter = SimpleValues.createSimpleBoolArrayWithBoolAfter();
        JsonArray check = SimpleValues.createBoolArray1();
        this.simpleOperation(result, (JsonValue)inBefore, (JsonValue)check, "/0", null);
        this.simpleOperation(result, (JsonValue)inAfter, (JsonValue)check, "/1", null);
    }

    private void testRemoveBoolOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleBoolArray5();
        JsonArray check = SimpleValues.createBoolArray2();
        this.complexOperation(result, in, check, new String[]{"/4", "/2", "/0"});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/2"});
    }

    private void testRemoveObjectOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject to produce empty JSON object");
        JsonObject in = SimpleValues.createSimpleObjectObject();
        JsonObject check = SimpleValues.createEmptyObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/wife", null);
    }

    private void testRemoveObjectOnEmptyArray(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject to produce empty JSON array");
        JsonArray in = SimpleValues.createEmptyArrayWithObject();
        JsonArray check = SimpleValues.createEmptyArray();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", null);
    }

    private void testRemoveObjectOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON object");
        JsonObject in = SimpleValues.createCompoundObjectWithObject();
        JsonObject check = SimpleValues.createCompoundObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/wife", null);
    }

    private void testRemoveObjectOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 2");
        JsonArray inBefore = SimpleValues.createSimpleObjectArrayWithObjectBefore();
        JsonArray inAfter = SimpleValues.createSimpleObjectArrayWithObjectAfter();
        JsonArray check = SimpleValues.createObjectArray1();
        this.simpleOperation(result, (JsonValue)inBefore, (JsonValue)check, "/0", null);
        this.simpleOperation(result, (JsonValue)inAfter, (JsonValue)check, "/1", null);
    }

    private void testRemoveObjectOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleObjectArray5();
        JsonArray check = SimpleValues.createObjectArray2();
        this.complexOperation(result, in, check, new String[]{"/4", "/2", "/0"});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/2"});
    }

    private void testRemoveFromNonExistingLocationInObject(TestResult result) {
        TestUtil.logMsg((String)" - for non existing location in JsonObject");
        JsonObject[] objsIn = new JsonObject[]{SimpleValues.createEmptyObject(), SimpleValues.createSimpleObject(), SimpleValues.createCompoundObject()};
        String[] paths = new String[]{"/address", "/age", "/married", "/wife"};
        for (int i = 0; i < objsIn.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                this.simpleOperationFail(result, (JsonValue)objsIn[i], paths[j], null);
            }
        }
    }

    private void testRemoveFromNonExistingLocationInArray(TestResult result) {
        TestUtil.logMsg((String)" - for non existing location in JsonArray");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createEmptyArray(), SimpleValues.createStringArray1(), SimpleValues.createIntArray2(), SimpleValues.createSimpleBoolArray5(), SimpleValues.createObjectArray2()};
        String[] paths = new String[]{"/", "/-1", "/-", "/5", "/0a", "/42", "/address/0"};
        for (int i = 0; i < arraysIn.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                this.simpleOperationFail(result, (JsonValue)arraysIn[i], paths[j], null);
            }
        }
    }

    @Override
    protected String operationName() {
        return "REMOVE";
    }

    @Override
    protected JsonPatchBuilder createOperationBuilder(String path, Object value) {
        return Json.createPatchBuilder().remove(path);
    }

    @Override
    protected JsonPatchBuilder updateOperationBuilder(JsonPatchBuilder builder, String path, Object value) {
        return builder.remove(path);
    }
}

