/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonreadertests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsonreadertests.Reader;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import com.sun.ts.tests.jsonp.common.MyBufferedInputStream;
import com.sun.ts.tests.jsonp.common.MyBufferedReader;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.stream.JsonParsingException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private boolean compareJsonObjectForUTFEncodedTests(JsonObject jsonObject) {
        JsonArray actArray;
        JsonObject actObject;
        boolean pass = true;
        this.logMsg("Comparing JsonObject values to expected results.");
        String expString = "stringValue";
        String actString = jsonObject.getJsonString("stringName").getString();
        if (!JSONP_Util.assertEquals(expString, actString)) {
            pass = false;
        }
        if (!JSONP_Util.assertEquals(expString = "bar", actString = (actObject = jsonObject.getJsonObject("objectName")).getJsonString("foo").getString())) {
            pass = false;
        }
        if (!(JSONP_Util.assertEquals(1, (actArray = jsonObject.getJsonArray("arrayName")).getJsonNumber(0).intValue()) && JSONP_Util.assertEquals(2, actArray.getJsonNumber(1).intValue()) && JSONP_Util.assertEquals(3, actArray.getJsonNumber(2).intValue()))) {
            pass = false;
        }
        return pass;
    }

    public void readEmptyArrayTest() throws EETest.Fault {
        boolean pass = true;
        try (JsonReader reader = null;){
            String expJsonText = "[]";
            this.logMsg("Testing read of " + expJsonText);
            reader = Json.createReader((java.io.Reader)new StringReader(expJsonText));
            JsonArray array = reader.readArray();
            pass = JSONP_Util.assertEqualsEmptyArrayList((List<JsonValue>)array);
        }
        if (!pass) {
            throw new EETest.Fault("readEmptyArrayTest Failed");
        }
    }

    public void readEscapeCharsInArrayTest() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader = null;
        String resourceFile = "jsonArrayWithEscapeCharsData.json";
        String expString = "popeye\"\\/\b\f\n\r\tolive";
        try {
            this.logMsg("Reading contents of resource file " + resourceFile);
            String readerContents = JSONP_Util.getContentsOfResourceAsString(resourceFile);
            this.logMsg("readerContents=" + readerContents);
            this.logMsg("Testing read of resource contents: " + readerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(readerContents));
            JsonArray expJsonArray = reader.readArray();
            TestUtil.logMsg((String)"Dump of expJsonArray");
            JSONP_Util.dumpJsonArray(expJsonArray);
            this.logMsg("Comparing JsonArray values with expected results.");
            String actString = expJsonArray.getJsonString(0).getString();
            if (!JSONP_Util.assertEquals(expString, actString)) {
                pass = false;
            }
            this.logMsg("Write the JsonArray 'expJsonArray' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeArray(expJsonArray);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            this.logMsg("Create actJsonArray from read of writer contents: " + writerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(writerContents));
            JsonArray actJsonArray = reader.readArray();
            TestUtil.logMsg((String)"Dump of actJsonArray");
            JSONP_Util.dumpJsonArray(actJsonArray);
            this.logMsg("Compare expJsonArray and actJsonArray for equality");
            if (!JSONP_Util.assertEqualsJsonArrays(expJsonArray, actJsonArray)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("readEscapeCharsInArrayTest Failed: ", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("readEscapeCharsInArrayTest Failed");
        }
    }

    public void readEscapeUnicodeCharsInArrayTest() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader = null;
        String unicodeTextString = "[\"\\u0000\u00ff\\uff00\uffff\"]";
        String expResult = "\u0000\u00ff\uff00\uffff";
        try {
            this.logMsg("Reading array of escaped and non escaped unicode chars.");
            reader = Json.createReader((java.io.Reader)new StringReader(unicodeTextString));
            JsonArray array = reader.readArray();
            String actResult = array.getJsonString(0).getString();
            pass = JSONP_Util.assertEquals(expResult, actResult);
        }
        catch (Exception e) {
            throw new EETest.Fault("readEscapeUnicodeCharsInArrayTest Failed: ", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("readEscapeUnicodeCharsInArrayTest Failed");
        }
    }

    public void readEscapeUnicodeControlCharsInArrayTest() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader = null;
        String unicodeTextString = "[\"\\u0000\\u0001\\u0002\\u0003\\u0004\\u0005\\u0006\\u0007\\u0008\\u0009\\u000a\\u000b\\u000c\\u000d\\u000e\\u000f\\u000A\\u000B\\u000C\\u000D\\u000E\\u000F\\u0010\\u0011\\u0012\\u0013\\u0014\\u0015\\u0016\\u0017\\u0018\\u0019\\u001a\\u001b\\u001c\\u001d\\u001e\\u001f\\u007f\\u001A\\u001B\\u001C\\u001D\\u001E\\u001F\\u007F\\u0080\\u0081\\u0082\\u0083\\u0084\\u0085\\u0086\\u0087\\u0088\\u0089\\u008a\\u008b\\u008c\\u008d\\u008e\\u008f\\u008A\\u008B\\u008C\\u008D\\u008E\\u008F\\u0090\\u0091\\u0092\\u0093\\u0094\\u0095\\u0096\\u0097\\u0098\\u0099\\u009a\\u009b\\u009c\\u009d\\u009e\\u009f\\u009A\\u009B\\u009C\\u009D\\u009E\\u009F\"]";
        String expResult = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f\u001a\u001b\u001c\u001d\u001e\u001f\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u009a\u009b\u009c\u009d\u009e\u009f";
        try {
            this.logMsg("Reading array of escaped and non escaped unicode chars.");
            reader = Json.createReader((java.io.Reader)new StringReader(unicodeTextString));
            JsonArray array = reader.readArray();
            String actResult = array.getJsonString(0).getString();
            pass = JSONP_Util.assertEquals(expResult, actResult);
        }
        catch (Exception e) {
            throw new EETest.Fault("readEscapeUnicodeControlCharsInArrayTest Failed: ", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("readEscapeUnicodeControlCharsInArrayTest Failed");
        }
    }

    public void readEmptyObjectTest() throws EETest.Fault {
        boolean pass = true;
        try (JsonReader reader = null;){
            String expJsonText = "{}";
            this.logMsg("Testing read of " + expJsonText);
            reader = Json.createReader((java.io.Reader)new StringReader(expJsonText));
            JsonObject object = reader.readObject();
            pass = JSONP_Util.assertEqualsEmptyObjectMap((Map<String, JsonValue>)object);
        }
        if (!pass) {
            throw new EETest.Fault("readEmptyObjectTest Failed");
        }
    }

    public void readEscapeCharsInObjectTest() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader = null;
        String resourceFile = "jsonObjectWithEscapeCharsData.json";
        String expString = "popeye\"\\/\b\f\n\r\tolive";
        try {
            this.logMsg("Reading contents of resource file " + resourceFile);
            String readerContents = JSONP_Util.getContentsOfResourceAsString(resourceFile);
            this.logMsg("readerContents=" + readerContents);
            this.logMsg("Testing read of resource contents: " + readerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(readerContents));
            JsonObject expJsonObject = reader.readObject();
            TestUtil.logMsg((String)"Dump of expJsonObject");
            JSONP_Util.dumpJsonObject(expJsonObject);
            this.logMsg("Comparing JsonArray values with expected results.");
            String actString = expJsonObject.getJsonString("escapeChars").getString();
            if (!JSONP_Util.assertEquals(expString, actString)) {
                pass = false;
            }
            this.logMsg("Write the JsonObject 'expJsonObject' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeObject(expJsonObject);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            this.logMsg("Create actJsonObject from read of writer contents: " + writerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(writerContents));
            JsonObject actJsonObject = reader.readObject();
            TestUtil.logMsg((String)"Dump of actJsonObject");
            JSONP_Util.dumpJsonObject(actJsonObject);
            this.logMsg("Compare expJsonObject and actJsonObject for equality");
            if (!JSONP_Util.assertEqualsJsonObjects(expJsonObject, actJsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("readEscapeCharsInObjectTest Failed: ", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("readEscapeCharsInObjectTest Failed");
        }
    }

    public void readEscapeUnicodeCharsInObjectTest() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader = null;
        String unicodeTextString = "{\"unicodechars\":\"\\u0000\u00ff\\uff00\uffff\"}";
        String expResult = "\u0000\u00ff\uff00\uffff";
        try {
            this.logMsg("Reading object of escaped and non escaped unicode chars.");
            reader = Json.createReader((java.io.Reader)new StringReader(unicodeTextString));
            JsonObject object = reader.readObject();
            String actResult = object.getJsonString("unicodechars").getString();
            pass = JSONP_Util.assertEquals(expResult, actResult);
        }
        catch (Exception e) {
            throw new EETest.Fault("readEscapeUnicodeCharsInObjectTest Failed: ", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("readEscapeUnicodeCharsInObjectTest Failed");
        }
    }

    public void readEscapeUnicodeControlCharsInObjectTest() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader = null;
        String unicodeTextString = "{\"unicodechars\":\"\\u0000\\u0001\\u0002\\u0003\\u0004\\u0005\\u0006\\u0007\\u0008\\u0009\\u000a\\u000b\\u000c\\u000d\\u000e\\u000f\\u000A\\u000B\\u000C\\u000D\\u000E\\u000F\\u0010\\u0011\\u0012\\u0013\\u0014\\u0015\\u0016\\u0017\\u0018\\u0019\\u001a\\u001b\\u001c\\u001d\\u001e\\u001f\\u007f\\u001A\\u001B\\u001C\\u001D\\u001E\\u001F\\u007F\\u0080\\u0081\\u0082\\u0083\\u0084\\u0085\\u0086\\u0087\\u0088\\u0089\\u008a\\u008b\\u008c\\u008d\\u008e\\u008f\\u008A\\u008B\\u008C\\u008D\\u008E\\u008F\\u0090\\u0091\\u0092\\u0093\\u0094\\u0095\\u0096\\u0097\\u0098\\u0099\\u009a\\u009b\\u009c\\u009d\\u009e\\u009f\\u009A\\u009B\\u009C\\u009D\\u009E\\u009F\"}";
        String expResult = "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u007f\u001a\u001b\u001c\u001d\u001e\u001f\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u009a\u009b\u009c\u009d\u009e\u009f";
        try {
            this.logMsg("Reading array of escaped and non escaped unicode chars.");
            reader = Json.createReader((java.io.Reader)new StringReader(unicodeTextString));
            JsonObject object = reader.readObject();
            String actResult = object.getJsonString("unicodechars").getString();
            pass = JSONP_Util.assertEquals(expResult, actResult);
        }
        catch (Exception e) {
            throw new EETest.Fault("readEscapeUnicodeControlCharsInObjectTest Failed: ", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("readEscapeUnicodeControlCharsInObjectTest Failed");
        }
    }

    public void readArrayTest() throws EETest.Fault {
        boolean pass = true;
        try (JsonReader reader = null;){
            JsonArray myJsonArray;
            String jsonText = "[true,false,null,\"booyah\",2147483647,9223372036854775807,1.7976931348623157E308,[true,false,null,\"bingo\",-2147483648,-9223372036854775808,4.9E-324],{\"true\":true,\"false\":false,\"null\":null,\"bonga\":\"boo\",\"int\":1,\"double\":10.4}]";
            this.logMsg("Create the expected list of JsonArray values");
            ArrayList<JsonValue> expList = new ArrayList<JsonValue>();
            expList.add(JsonValue.TRUE);
            expList.add(JsonValue.FALSE);
            expList.add(JsonValue.NULL);
            expList.add((JsonValue)JSONP_Util.createJsonString("booyah"));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(Integer.MAX_VALUE));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(Long.MAX_VALUE));
            expList.add((JsonValue)JSONP_Util.createJsonNumber(Double.MAX_VALUE));
            JsonArray array = Json.createArrayBuilder().add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("bingo").add(Integer.MIN_VALUE).add(Long.MIN_VALUE).add(Double.MIN_VALUE).build();
            JsonObject object = Json.createObjectBuilder().add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("bonga", "boo").add("int", 1).add("double", 10.4).build();
            expList.add((JsonValue)array);
            expList.add((JsonValue)object);
            this.logMsg("Testing read of " + jsonText);
            reader = Json.createReader((java.io.Reader)new StringReader(jsonText));
            JsonArray actList = myJsonArray = reader.readArray();
            this.logMsg("Compare actual list of JsonArray values with expected list of JsonArray values");
            pass = JSONP_Util.assertEqualsList(expList, (List<JsonValue>)actList);
        }
        if (!pass) {
            throw new EETest.Fault("readArrayTest Failed");
        }
    }

    public void readArrayTest2() throws EETest.Fault {
        boolean pass = true;
        try (JsonReader reader = null;){
            this.logMsg("Create the expected list of JsonArray values");
            JsonArray expJsonArray = Json.createArrayBuilder().add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("booyah").add(Integer.MAX_VALUE).add(Long.MAX_VALUE).add(Double.MAX_VALUE).add(Json.createArrayBuilder().add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("bingo").add(Integer.MIN_VALUE).add(Long.MIN_VALUE).add(Double.MIN_VALUE)).add(Json.createObjectBuilder().add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("bonga", "boo").add("int", 1).add("double", 10.4)).build();
            this.logMsg("Write the JsonArray 'expJsonArray' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeArray(expJsonArray);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String jsonText = sWriter.toString();
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + jsonText);
            this.logMsg("Testing read of " + jsonText);
            reader = Json.createReader((InputStream)JSONP_Util.getInputStreamFromString(jsonText));
            JsonArray actJsonArray = reader.readArray();
            this.logMsg("Compare expJsonArray and actJsonArray for equality");
            pass = JSONP_Util.assertEqualsJsonArrays(expJsonArray, actJsonArray);
        }
        if (!pass) {
            throw new EETest.Fault("readArrayTest2 Failed");
        }
    }

    public void readArrayTest3() throws EETest.Fault {
        boolean pass = true;
        try (JsonReader reader = null;){
            String expJsonText = "[true,false,null,\"booyah\",2147483647,9223372036854775807,[true,false,null,\"bingo\",-2147483648,-9223372036854775808],{\"true\":true,\"false\":false,\"null\":null,\"bonga\":\"boo\",\"int\":1}]";
            this.logMsg("Testing read of " + expJsonText);
            reader = Json.createReaderFactory(JSONP_Util.getEmptyConfig()).createReader((java.io.Reader)new StringReader(expJsonText));
            JsonArray myJsonArray = reader.readArray();
            this.logMsg("Write the JsonArray 'myJsonArray' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeArray(myJsonArray);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String actJsonText = sWriter.toString();
            this.logMsg("Compare actual JSON text with expected JSON text");
            pass = JSONP_Util.assertEqualsJsonText(expJsonText, actJsonText);
        }
        if (!pass) {
            throw new EETest.Fault("readArrayTest3 Failed");
        }
    }

    public void readArrayTest4() throws EETest.Fault {
        boolean pass = true;
        String resourceFile = "jsonArrayWithAllTypesOfData.json";
        try (JsonReader reader = null;){
            this.logMsg("Read contents of InputStream from resource file: " + resourceFile);
            Map<String, ?> config = JSONP_Util.getEmptyConfig();
            reader = Json.createReaderFactory(config).createReader(JSONP_Util.getInputStreamFromResource(resourceFile), JSONP_Util.UTF_8);
            JsonArray expJsonArray = reader.readArray();
            TestUtil.logMsg((String)"Dump of expJsonArray");
            JSONP_Util.dumpJsonArray(expJsonArray);
            this.logMsg("Write the JsonArray 'expJsonArray' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeArray(expJsonArray);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            this.logMsg("Create actJsonArray from read of writer contents: " + writerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(writerContents));
            JsonArray actJsonArray = reader.readArray();
            TestUtil.logMsg((String)"Dump of actJsonArray");
            JSONP_Util.dumpJsonArray(actJsonArray);
            this.logMsg("Compare expJsonArray and actJsonArray for equality");
            pass = JSONP_Util.assertEqualsJsonArrays(expJsonArray, actJsonArray);
        }
        if (!pass) {
            throw new EETest.Fault("readArrayTest4 Failed");
        }
    }

    public void readArrayTest5() throws EETest.Fault {
        boolean pass = true;
        String resourceFile = "jsonArrayWithLotsOfNestedObjectsData.json";
        try (JsonReader reader = null;){
            this.logMsg("Reading contents of resource file " + resourceFile);
            String readerContents = JSONP_Util.getContentsOfResourceAsString(resourceFile);
            this.logMsg("readerContents=" + readerContents);
            this.logMsg("Filter readerContents of whitespace for comparison");
            String expJsonText = JSONP_Util.removeWhitespace(readerContents);
            this.logMsg("Read contents of InputStream from resource file: " + resourceFile);
            reader = Json.createReaderFactory(JSONP_Util.getEmptyConfig()).createReader(JSONP_Util.getInputStreamFromResource(resourceFile), JSONP_Util.UTF_8);
            JsonArray myJsonArray = (JsonArray)reader.read();
            this.logMsg("Write the JsonArray 'myJsonArray' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeArray(myJsonArray);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            this.logMsg("Dump contents of the JsonWriter as a String");
            this.logMsg("writerContents=" + writerContents);
            this.logMsg("Filter writerContents of whitespace for comparison");
            String actJsonText = JSONP_Util.removeWhitespace(writerContents);
            this.logMsg("Compare actual JSON text with expected JSON text");
            pass = JSONP_Util.assertEqualsJsonText(expJsonText, actJsonText);
        }
        if (!pass) {
            throw new EETest.Fault("readArrayTest5 Failed");
        }
    }

    public void readArrayEncodingTest() throws EETest.Fault {
        String actString;
        JsonArray jsonArray;
        InputStream is;
        boolean pass = true;
        JsonReader reader = null;
        String expString = "a\u65e8\u452c\u8b9e\u6589\u5c57\u5217z";
        String resourceFileUTF8 = "jsonArrayUTF8.json";
        String resourceFileUTF16BE = "jsonArrayUTF16BE.json";
        Map<String, ?> config = JSONP_Util.getEmptyConfig();
        try {
            this.logMsg("Reading contents of resource file using UTF-8 encoding " + resourceFileUTF8);
            is = JSONP_Util.getInputStreamFromResource(resourceFileUTF8);
            reader = Json.createReaderFactory(config).createReader(is, JSONP_Util.UTF_8);
            jsonArray = reader.readArray();
            this.logMsg("Comparing JsonArray values with expected results.");
            actString = jsonArray.getJsonString(0).getString();
            if (!JSONP_Util.assertEquals(expString, actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("readArrayEncodingTest Failed: ", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Reading contents of resource file using UTF-16BE encoding " + resourceFileUTF16BE);
            is = JSONP_Util.getInputStreamFromResource(resourceFileUTF16BE);
            reader = Json.createReaderFactory(config).createReader(is, JSONP_Util.UTF_16BE);
            jsonArray = reader.readArray();
            this.logMsg("Comparing JsonArray values with expected results.");
            actString = jsonArray.getJsonString(0).getString();
            if (!JSONP_Util.assertEquals(expString, actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("readArrayEncodingTest Failed: ", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("readArrayEncodingTest Failed");
        }
    }

    public void readObjectTest() throws EETest.Fault {
        boolean pass = true;
        try (JsonReader reader = null;){
            JsonObject myJsonObject;
            String expJsonText = "{\"true\":true,\"false\":false,\"null\":null,\"booyah\":\"booyah\",\"int\":2147483647,\"long\":9223372036854775807,\"double\":1.7976931348623157E308,\"array\":[true,false,null,\"bingo\",-2147483648,-9223372036854775808,4.9E-324],\"object\":{\"true\":true,\"false\":false,\"null\":null,\"bonga\":\"boo\",\"int\":1,\"double\":10.4}}";
            this.logMsg("Create the expected map of JsonObject values");
            HashMap<String, JsonValue> expMap = new HashMap<String, JsonValue>();
            expMap.put("true", JsonValue.TRUE);
            expMap.put("false", JsonValue.FALSE);
            expMap.put("null", JsonValue.NULL);
            expMap.put("booyah", (JsonValue)JSONP_Util.createJsonString("booyah"));
            expMap.put("int", (JsonValue)JSONP_Util.createJsonNumber(Integer.MAX_VALUE));
            expMap.put("long", (JsonValue)JSONP_Util.createJsonNumber(Long.MAX_VALUE));
            expMap.put("double", (JsonValue)JSONP_Util.createJsonNumber(Double.MAX_VALUE));
            JsonArray array = Json.createArrayBuilder().add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("bingo").add(Integer.MIN_VALUE).add(Long.MIN_VALUE).add(Double.MIN_VALUE).build();
            JsonObject object = Json.createObjectBuilder().add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("bonga", "boo").add("int", 1).add("double", 10.4).build();
            expMap.put("array", (JsonValue)array);
            expMap.put("object", (JsonValue)object);
            this.logMsg("Testing read of " + expJsonText);
            reader = Json.createReader((java.io.Reader)new StringReader(expJsonText));
            JsonObject actMap = myJsonObject = reader.readObject();
            this.logMsg("Compare actual map of JsonObject values with expected map of JsonObject values");
            pass = JSONP_Util.assertEqualsMap(expMap, (Map<String, JsonValue>)actMap);
        }
        if (!pass) {
            throw new EETest.Fault("readObjectTest Failed");
        }
    }

    public void readObjectTest2() throws EETest.Fault {
        boolean pass = true;
        try (JsonReader reader = null;){
            this.logMsg("Create the expected list of JsonObject values");
            JsonObject expJsonObject = Json.createObjectBuilder().add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("booyah", "booyah").add("int", Integer.MAX_VALUE).add("long", Long.MAX_VALUE).add("double", Double.MAX_VALUE).add("array", Json.createArrayBuilder().add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add("bingo").add(Integer.MIN_VALUE).add(Long.MIN_VALUE).add(Double.MIN_VALUE)).add("object", Json.createObjectBuilder().add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("bonga", "boo").add("int", 1).add("double", 10.4)).build();
            this.logMsg("Write the JsonObject 'expJsonObject' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeObject(expJsonObject);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String jsonText = sWriter.toString();
            this.logMsg("Dump contents of JsonWriter as a String");
            this.logMsg("JsonWriterContents=" + jsonText);
            this.logMsg("Testing read of " + jsonText);
            reader = Json.createReader((InputStream)JSONP_Util.getInputStreamFromString(jsonText));
            JsonObject actJsonObject = reader.readObject();
            this.logMsg("Compare expJsonObject and actJsonObject for equality");
            pass = JSONP_Util.assertEqualsJsonObjects(expJsonObject, actJsonObject);
        }
        if (!pass) {
            throw new EETest.Fault("readObjectTest2 Failed");
        }
    }

    public void readObjectTest3() throws EETest.Fault {
        boolean pass = true;
        try (JsonReader reader = null;){
            String expJsonText = "{\"true\":true,\"false\":false,\"null\":null,\"booyah\":\"booyah\",\"int\":2147483647,\"long\":9223372036854775807,\"array\":[true,false,null,\"bingo\",-2147483648,-9223372036854775808],\"object\":{\"true\":true,\"false\":false,\"null\":null,\"bonga\":\"boo\",\"int\":1}}";
            this.logMsg("Testing read of " + expJsonText);
            reader = Json.createReaderFactory(JSONP_Util.getEmptyConfig()).createReader((java.io.Reader)new StringReader(expJsonText));
            JsonObject myJsonObject = reader.readObject();
            this.logMsg("Write the JsonObject 'myJsonObject' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeObject(myJsonObject);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String actJsonText = sWriter.toString();
            this.logMsg("Compare actual JSON text with expected JSON text");
            pass = JSONP_Util.assertEqualsJsonText(expJsonText, actJsonText);
        }
        if (!pass) {
            throw new EETest.Fault("readObjectTest3 Failed");
        }
    }

    public void readObjectTest4() throws EETest.Fault {
        boolean pass = true;
        String resourceFile = "jsonObjectWithAllTypesOfData.json";
        try (JsonReader reader = null;){
            this.logMsg("Read contents of InputStream from resource file: " + resourceFile);
            Map<String, ?> config = JSONP_Util.getEmptyConfig();
            reader = Json.createReaderFactory(config).createReader(JSONP_Util.getInputStreamFromResource(resourceFile), JSONP_Util.UTF_8);
            JsonObject expJsonObject = reader.readObject();
            TestUtil.logMsg((String)"Dump of expJsonObject");
            JSONP_Util.dumpJsonObject(expJsonObject);
            this.logMsg("Write the JsonObject 'expJsonObject' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeObject(expJsonObject);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            this.logMsg("Create actJsonObject from read of writer contents: " + writerContents);
            reader = Json.createReader((java.io.Reader)new StringReader(writerContents));
            JsonObject actJsonObject = reader.readObject();
            TestUtil.logMsg((String)"Dump of actJsonObject");
            JSONP_Util.dumpJsonObject(actJsonObject);
            this.logMsg("Compare expJsonObject and actJsonObject for equality");
            pass = JSONP_Util.assertEqualsJsonObjects(expJsonObject, actJsonObject);
        }
        if (!pass) {
            throw new EETest.Fault("readObjectTest4 Failed");
        }
    }

    public void readObjectTest5() throws EETest.Fault {
        boolean pass = true;
        String resourceFile = "jsonObjectWithLotsOfNestedObjectsData.json";
        try (JsonReader reader = null;){
            this.logMsg("Reading contents of resource file " + resourceFile);
            String readerContents = JSONP_Util.getContentsOfResourceAsString(resourceFile);
            this.logMsg("readerContents=" + readerContents);
            this.logMsg("Filter readerContents of whitespace for comparison");
            String expJsonText = JSONP_Util.removeWhitespace(readerContents);
            this.logMsg("Read contents of InputStream from resource file: " + resourceFile);
            reader = Json.createReaderFactory(JSONP_Util.getEmptyConfig()).createReader(JSONP_Util.getInputStreamFromResource(resourceFile), JSONP_Util.UTF_8);
            JsonObject myJsonObject = (JsonObject)reader.read();
            this.logMsg("Write the JsonObject 'myJsonObject' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((Writer)sWriter);){
                writer.writeObject(myJsonObject);
                this.logMsg("Close JsonWriter");
            }
            this.logMsg("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            this.logMsg("Dump contents of the JsonWriter as a String");
            this.logMsg("writerContents=" + writerContents);
            this.logMsg("Filter writerContents of whitespace for comparison");
            String actJsonText = JSONP_Util.removeWhitespace(writerContents);
            this.logMsg("Compare actual JSON text with expected JSON text");
            pass = JSONP_Util.assertEqualsJsonText(expJsonText, actJsonText);
        }
        if (!pass) {
            throw new EETest.Fault("readObjectTest5 Failed");
        }
    }

    public void readObjectEncodingTest() throws EETest.Fault {
        String actString;
        JsonObject jsonObject;
        Map<String, ?> config;
        InputStream is;
        boolean pass = true;
        JsonReader reader = null;
        String expString = "a\u65e8\u452c\u8b9e\u6589\u5c57\u5217z";
        String resourceFileUTF8 = "jsonObjectUTF8.json";
        String resourceFileUTF16LE = "jsonObjectUTF16LE.json";
        try {
            this.logMsg("Reading contents of resource file using UTF-8 encoding " + resourceFileUTF8);
            is = JSONP_Util.getInputStreamFromResource(resourceFileUTF8);
            config = JSONP_Util.getEmptyConfig();
            reader = Json.createReaderFactory(config).createReader(is, JSONP_Util.UTF_8);
            jsonObject = reader.readObject();
            this.logMsg("Comparing JsonObject values with expected results.");
            actString = jsonObject.getJsonString("unicodeChars").getString();
            if (!JSONP_Util.assertEquals(expString, actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("readObjectEncodingTest Failed: ", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Reading contents of resource file using UTF-16LE encoding " + resourceFileUTF16LE);
            is = JSONP_Util.getInputStreamFromResource(resourceFileUTF16LE);
            config = JSONP_Util.getEmptyConfig();
            reader = Json.createReaderFactory(config).createReader(is, JSONP_Util.UTF_16LE);
            jsonObject = reader.readObject();
            this.logMsg("Comparing JsonObject values with expected results.");
            actString = jsonObject.getJsonString("unicodeChars").getString();
            if (!JSONP_Util.assertEquals(expString, actString)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("readObjectEncodingTest Failed: ", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("readObjectEncodingTest Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUTFEncodedTests() throws EETest.Fault {
        JsonObject jsonObject;
        InputStream is;
        boolean pass = true;
        JsonReader reader = null;
        Map<String, ?> config = JSONP_Util.getEmptyConfig();
        try {
            this.logMsg("-----------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-8]");
            this.logMsg("-----------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF8.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF8.json");
            this.logMsg("Create JsonReader from the InputStream with character encoding UTF-8");
            reader = Json.createReaderFactory(config).createReader(is, JSONP_Util.UTF_8);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-8 encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-16]");
            this.logMsg("------------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF16.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF16.json");
            this.logMsg("Create JsonReader from the InputStream with character encoding UTF-16");
            reader = Json.createReaderFactory(config).createReader(is, JSONP_Util.UTF_16);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-16 encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-16LE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF16LE.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF16LE.json");
            this.logMsg("Create JsonReader from the InputStream with character encoding UTF-16LE");
            reader = Json.createReaderFactory(config).createReader(is, JSONP_Util.UTF_16LE);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-16LE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-16BE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF16BE.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF16BE.json");
            this.logMsg("Create JsonReader from the InputStream with character encoding UTF-16BE");
            reader = Json.createReaderFactory(config).createReader(is, JSONP_Util.UTF_16BE);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-16BE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-32LE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF32LE.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF32LE.json");
            this.logMsg("Create JsonReader from the InputStream with character encoding UTF-32LE");
            reader = Json.createReaderFactory(config).createReader(is, JSONP_Util.UTF_32LE);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-32LE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReaderFactory(Map<String,?>).createReader(InputStream, Charset) as UTF-32BE]");
            this.logMsg("--------------------------------------------------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF32BE.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF32BE.json");
            this.logMsg("Create JsonReader from the InputStream with character encoding UTF-32BE");
            reader = Json.createReaderFactory(config).createReader(is, JSONP_Util.UTF_32BE);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-32BE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("readUTFEncodedTests Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUTFEncodedTests2() throws EETest.Fault {
        JsonObject jsonObject;
        InputStream is;
        boolean pass = true;
        JsonReader reader = null;
        try {
            this.logMsg("---------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReader(InputStream) as UTF-8]");
            this.logMsg("---------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF8.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF8.json");
            this.logMsg("Create JsonReader from the InputStream and auto-detect character encoding UTF-8");
            reader = Json.createReader((InputStream)is);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-8 encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReader(InputStream) as UTF-16LE]");
            this.logMsg("------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF16LE.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF16LE.json");
            this.logMsg("Create JsonReader from the InputStream and auto-detect character encoding UTF-16LE");
            reader = Json.createReader((InputStream)is);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-16LE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReader(InputStream) as UTF-16BE]");
            this.logMsg("------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF16BE.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF16BE.json");
            this.logMsg("Create JsonReader from the InputStream and auto-detect character encoding UTF-16BE");
            reader = Json.createReader((InputStream)is);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-16BE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReader(InputStream) as UTF-32LE]");
            this.logMsg("------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF32LE.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF32LE.json");
            this.logMsg("Create JsonReader from the InputStream and auto-detect character encoding UTF-32LE");
            reader = Json.createReader((InputStream)is);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-32LE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
        try {
            this.logMsg("------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createReader(InputStream) as UTF-32BE]");
            this.logMsg("------------------------------------------------------");
            this.logMsg("Get InputStream from data file as resource (jsonObjectEncodingUTF32BE.json)");
            is = JSONP_Util.getInputStreamFromResource("jsonObjectEncodingUTF32BE.json");
            this.logMsg("Create JsonReader from the InputStream and auto-detect character encoding UTF-32BE");
            reader = Json.createReader((InputStream)is);
            jsonObject = reader.readObject();
            if (!this.compareJsonObjectForUTFEncodedTests(jsonObject)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing reading of UTF-32BE encoding: " + e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("readUTFEncodedTests2 Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void negativeObjectTests() throws EETest.Fault {
        JsonObject value;
        boolean pass = true;
        try (JsonReader reader = null;){
            this.logMsg("Testing for not an object '[]'");
            reader = Json.createReader((java.io.Reader)new StringReader("[]"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonException");
        }
        try {
            this.logMsg("Trip JsonParsingException for JsonReader.read() if incorrect representation for object.");
            this.logMsg("Reading {\"name\":\"value\",1,2,3}");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"name\":\"value\",1,2,3}"));
            JsonObject jsonObject = reader.readObject();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Testing for missing '['");
            reader = Json.createReader((java.io.Reader)new StringReader("{1,2]}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ']'");
            reader = Json.createReader((java.io.Reader)new StringReader("{[1,2}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing '{'");
            reader = Json.createReader((java.io.Reader)new StringReader("}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing '}'");
            reader = Json.createReader((java.io.Reader)new StringReader("{"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between array elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("{[5\"foo\"]}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between array elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("{[5{}]}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between object elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"foo\":\"bar\"5}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between object elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"one\":1[]}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing key name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("{:\"bar\"}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing value name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"foo\":}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Test for missing double quote on a name");
            reader = Json.createReader((java.io.Reader)new StringReader("{name\" : \"value\"}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Test for missing double quote on a value");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"name\" : value\"}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value -foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : -foo}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value +foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : +foo}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value -784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : -784foo}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value +784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : +784foo}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value 0.1E5E5");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0.1E5E5}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value  0.F10");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0.F10}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value string");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : string}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value hex numbers invalid per JSON RFC");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0x137a}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value octal numbers invalid per JSON RFC");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0137}"));
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("negativeObjectTests Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void negativeArrayTests() throws EETest.Fault {
        JsonArray value;
        boolean pass = true;
        try (JsonReader reader = null;){
            this.logMsg("Testing for not an array '{}'");
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonException");
        }
        try {
            this.logMsg("Trip JsonParsingException for JsonReader.readArray() if incorrect representation for array.");
            this.logMsg("Reading [foo,10,\"name\":\"value\"]");
            reader = Json.createReader((java.io.Reader)new StringReader("[foo,10,\"name\":\"value\"]"));
            JsonArray jsonArray = reader.readArray();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Testing for missing '['");
            reader = Json.createReader((java.io.Reader)new StringReader("]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ']'");
            reader = Json.createReader((java.io.Reader)new StringReader("["));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing '{'");
            reader = Json.createReader((java.io.Reader)new StringReader("[1,\"name\":\"value\"}]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing '}'");
            reader = Json.createReader((java.io.Reader)new StringReader("[1,{\"name\":\"value\"]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between array elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("[5\"foo\"]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between array elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("[5{}]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between object elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("[{\"foo\":\"bar\"5}]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between object elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("[{\"one\":1[]}]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing key name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("[{:\"bar\"}]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing value name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("[{\"foo\":}]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Test for missing double quote on a name");
            reader = Json.createReader((java.io.Reader)new StringReader("[{name\" : \"value\"}]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Test for missing double quote on a value");
            reader = Json.createReader((java.io.Reader)new StringReader("[{\"name\" : value\"}]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value -foo");
            reader = Json.createReader((java.io.Reader)new StringReader("[-foo]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value +foo");
            reader = Json.createReader((java.io.Reader)new StringReader("[+foo]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value -784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("[-784foo]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value +784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("[+784foo]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value 0.1E5E5");
            reader = Json.createReader((java.io.Reader)new StringReader("[0.1E5E5]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value  0.F10");
            reader = Json.createReader((java.io.Reader)new StringReader("[0.F10]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value string");
            reader = Json.createReader((java.io.Reader)new StringReader("[string]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value hex numbers invalid per JSON RFC");
            reader = Json.createReader((java.io.Reader)new StringReader("[0x137a]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value octal numbers invalid per JSON RFC");
            reader = Json.createReader((java.io.Reader)new StringReader("[0137]"));
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("negativeArrayTests Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void illegalStateExceptionTests() throws EETest.Fault {
        JsonStructure value;
        boolean pass = true;
        JsonReader reader = null;
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            reader.close();
            this.logMsg("Calling reader.read() after reader.close() is called is illegal.");
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            value = reader.readObject();
            this.logMsg("Calling reader.readObject() after reader.readObject() was called is illegal.");
            value = (JsonObject)reader.read();
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("[]"));
            value = reader.readArray();
            this.logMsg("Calling reader.read() after reader.readArray() was called is illegal.");
            value = (JsonArray)reader.read();
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            reader.close();
            this.logMsg("Calling reader.readObject() after reader.close() is called is illegal.");
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            value = reader.readObject();
            this.logMsg("Calling reader.readObject() after reader.readObject() was called is illegal.");
            value = reader.readObject();
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("{}"));
            JsonObject obj = reader.readObject();
            this.logMsg("Calling reader.readArray() after reader.readObject() was called is illegal.");
            JsonArray arr = reader.readArray();
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("[]"));
            reader.close();
            this.logMsg("Calling reader.readArray() after reader.close() is called is illegal.");
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("[]"));
            value = reader.readArray();
            this.logMsg("Calling reader.readArray() after reader.readArray() was called is illegal.");
            value = reader.readArray();
            pass = false;
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            reader = Json.createReader((java.io.Reader)new StringReader("[]"));
            JsonArray arr = reader.readArray();
            this.logMsg("Calling reader.readObject() after reader.readArray() was called is illegal.");
            JsonObject obj = reader.readObject();
            pass = false;
            this.logMsg("obj=" + obj);
            this.logErr("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            this.logMsg("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("illegalStateExceptionTests Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void negativeJsonStructureTests() throws EETest.Fault {
        JsonStructure value;
        JsonStructure jsonStructure;
        boolean pass = true;
        JsonReader reader = null;
        try {
            this.logMsg("Trip JsonParsingException for JsonReader.read() if incorrect representation for array.");
            this.logMsg("Reading [foo,10,\"name\":\"value\"]");
            reader = Json.createReader((java.io.Reader)new StringReader("[foo,10,\"name\":\"value\"]"));
            jsonStructure = reader.read();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonParsingException for JsonReader.read() if incorrect representation for object.");
            this.logMsg("Reading {\"name\":\"value\",1,2,3}");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"name\":\"value\",1,2,3}"));
            jsonStructure = reader.read();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Testing for incorrect representation '{]'");
            reader = Json.createReader((java.io.Reader)new StringReader("{]"));
            this.logMsg("Calling reader.read() with incorrect representation should throw JsonParsingException");
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Testing for missing '['");
            reader = Json.createReader((java.io.Reader)new StringReader("{1,2]}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ']'");
            reader = Json.createReader((java.io.Reader)new StringReader("{[1,2}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing '{'");
            reader = Json.createReader((java.io.Reader)new StringReader("}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing '}'");
            reader = Json.createReader((java.io.Reader)new StringReader("{"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between array elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("{[5\"foo\"]}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between array elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("{[5{}]}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between object elements test case 1");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"foo\":\"bar\"5}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing ',' between object elements test case 2");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"one\":1[]}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing key name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("{:\"bar\"}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Testing for missing value name in object element");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"foo\":}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Test for missing double quote on a name");
            reader = Json.createReader((java.io.Reader)new StringReader("{name\" : \"value\"}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Test for missing double quote on a value");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"name\" : value\"}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value -foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : -foo}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value +foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : +foo}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value -784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : -784foo}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value +784foo");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : +784foo}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value 0.1E5E5");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0.1E5E5}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value  0.F10");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : 0.F10}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try {
            this.logMsg("Incorrect digit value string");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"number\" : string}"));
            value = reader.read();
            pass = false;
            this.logErr("Failed to throw JsonParsingException");
        }
        catch (JsonParsingException e) {
            this.logMsg("Got expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (!pass) {
            throw new EETest.Fault("negativeJsonStructureTests Failed");
        }
    }

    public void jsonReaderIOErrorTests() throws EETest.Fault {
        JsonReader reader;
        MyBufferedReader mbr;
        boolean pass = true;
        String jsonArrayText = "[\"name1\",\"value1\"]";
        String jsonObjectText = "{\"name1\":\"value1\"}";
        try {
            this.logMsg("Trip JsonException if there is an i/o error on JsonReader.close().");
            this.logMsg("Reading object " + jsonObjectText);
            InputStream is = JSONP_Util.getInputStreamFromString(jsonObjectText);
            MyBufferedInputStream mbi = new MyBufferedInputStream(is);
            try (JsonReader reader2 = Json.createReader((InputStream)mbi);){
                JsonObject jsonObject = reader2.readObject();
                this.logMsg("jsonObject=" + jsonObject);
                mbi.setThrowIOException(true);
                this.logMsg("Calling JsonReader.close()");
                mbi.setThrowIOException(true);
            }
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonException for JsonReader.read() if i/o error.");
            this.logMsg("Reading array " + jsonArrayText);
            mbr = new MyBufferedReader(new StringReader(jsonArrayText));
            reader = Json.createReader((java.io.Reader)mbr);
            mbr.setThrowIOException(true);
            this.logMsg("Calling JsonReader.read()");
            JsonStructure jsonStructure = reader.read();
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonException for JsonReader.readArray() if i/o error.");
            this.logMsg("Reading array " + jsonArrayText);
            mbr = new MyBufferedReader(new StringReader(jsonArrayText));
            reader = Json.createReader((java.io.Reader)mbr);
            mbr.setThrowIOException(true);
            this.logMsg("Calling JsonReader.readArray()");
            JsonArray jsonArray = reader.readArray();
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonException for JsonReader.read() if i/o error.");
            this.logMsg("Reading object " + jsonObjectText);
            mbr = new MyBufferedReader(new StringReader(jsonObjectText));
            reader = Json.createReader((java.io.Reader)mbr);
            mbr.setThrowIOException(true);
            this.logMsg("Calling JsonReader.readObject()");
            JsonObject jsonObject = reader.readObject();
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonReaderIOErrorTests Failed");
        }
    }

    public void invalidLiteralNamesTest() throws EETest.Fault {
        JsonStructure jsonStructure;
        JsonReader reader;
        boolean pass = true;
        try {
            this.logMsg("Trip JsonParsingException for JsonReader.read() if invalid liternal TRUE instead of true.");
            this.logMsg("Reading [TRUE]");
            reader = Json.createReader((java.io.Reader)new StringReader("[TRUE]"));
            jsonStructure = reader.read();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonParsingException for JsonReader.read() if invalid liternal FALSE instead of false.");
            this.logMsg("Reading [FALSE]");
            reader = Json.createReader((java.io.Reader)new StringReader("[FALSE]"));
            jsonStructure = reader.read();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonParsingException for JsonReader.read() if invalid liternal NULL instead of null.");
            this.logMsg("Reading [NULL]");
            reader = Json.createReader((java.io.Reader)new StringReader("[NULL]"));
            jsonStructure = reader.read();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonParsingException for JsonReader.read() if invalid liternal TRUE instead of true.");
            this.logMsg("Reading {\"true\":TRUE}");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"true\":TRUE}"));
            jsonStructure = reader.read();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonParsingException for JsonReader.read() if invalid liternal FALSE instead of false.");
            this.logMsg("Reading {\"false\":FALSE}");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"false\":FALSE}"));
            jsonStructure = reader.read();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonParsingException for JsonReader.read() if invalid liternal NULL instead of null.");
            this.logMsg("Reading {\"null\":NULL}");
            reader = Json.createReader((java.io.Reader)new StringReader("{\"null\":NULL}"));
            jsonStructure = reader.read();
            this.logErr("Did not get expected JsonParsingException");
            pass = false;
        }
        catch (JsonParsingException e) {
            this.logMsg("Caught expected JsonParsingException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("invalidLiteralNamesTest Failed");
        }
    }

    public void jsonReader11Test() throws EETest.Fault {
        Reader readerTest = new Reader();
        TestResult result = readerTest.test();
        result.eval();
    }
}

