/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.stmt.stmt1;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;

public class stmtClient1
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.stmt.stmt1";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        stmtClient1 theTests = new stmtClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.dbSch = new dbSchema();
                this.rsSch = new rsSchema();
                this.dbSch.createData(p, this.conn);
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testClose() throws EETest.Fault {
        Statement statemt = null;
        boolean sqlExceptFlag = false;
        try {
            statemt = this.conn.createStatement();
            this.msg.setMsg("invoking the Close method");
            this.msg.setMsg("Calling close method");
            statemt.close();
            String sSelCoffee = this.sqlp.getProperty("SelCoffeeAll", "");
            this.msg.setMsg("Query String : " + sSelCoffee);
            try {
                this.rs = statemt.executeQuery(sSelCoffee);
            }
            catch (SQLException sql) {
                TestUtil.printStackTrace((Throwable)sql);
                sqlExceptFlag = true;
            }
            if (sqlExceptFlag) {
                this.msg.setMsg("close method closes the Statement object");
            } else {
                this.msg.printTestError("close method does not close the Statement object", "Call to close method is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to close is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to close is Failed!");
        }
    }

    public void testExecute01() throws EETest.Fault {
        boolean executeFlag = false;
        try {
            String sSqlStmt = this.sqlp.getProperty("Upd_Coffee_Tab", "");
            this.msg.setMsg("Sql Statement to be executed  " + sSqlStmt);
            this.msg.setMsg("Calling execute method ");
            executeFlag = this.stmt.execute(sSqlStmt);
            if (!executeFlag) {
                this.msg.setMsg("execute method executes the SQL Statement ");
            } else {
                this.msg.printTestError("execute method does not execute the SQL Statement", "Call to execute is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to execute is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to execute is Failed!");
        }
    }

    public void testExecute02() throws EETest.Fault {
        boolean executeFlag = false;
        try {
            String sSqlStmt = this.sqlp.getProperty("Sel_Coffee_Tab", "");
            this.msg.setMsg("Sql Statement to be executed  " + sSqlStmt);
            this.msg.setMsg("Calling execute method ");
            executeFlag = this.stmt.execute(sSqlStmt);
            if (executeFlag) {
                this.msg.setMsg("execute method executes the SQL Statement ");
            } else {
                this.msg.printTestError("execute method does not execute the SQL Statement", "Call to execute is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to execute is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to execute is Failed!");
        }
    }

    public void testExecuteQuery01() throws EETest.Fault {
        ResultSet reSet = null;
        try {
            String sSqlStmt = this.sqlp.getProperty("SelCoffeeAll", "");
            this.msg.setMsg("SQL Statement to be executed  :  " + sSqlStmt);
            this.msg.setMsg("invoking the executeQuery");
            this.msg.setMsg("Calling executeQuery method ");
            reSet = this.stmt.executeQuery(sSqlStmt);
            if (reSet instanceof ResultSet) {
                this.msg.setMsg("executeQuery method returns a ResultSet object");
            } else {
                this.msg.printTestError("executeQuery method does not return a ResultSet object", "Call to executeQuery is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeQuery is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeQuery is Failed!");
        }
    }

    public void testExecuteQuery02() throws EETest.Fault {
        ResultSet reSet = null;
        try {
            String sSqlStmt = this.sqlp.getProperty("SelCoffeeNull", "");
            this.msg.setMsg("SQL Statement to be executed  :  " + sSqlStmt);
            this.msg.setMsg("invoking the executeQuery");
            this.msg.setMsg("Calling executeQuery method ");
            reSet = this.stmt.executeQuery(sSqlStmt);
            if (!reSet.next()) {
                this.msg.setMsg("executeQuery method returns an Empty ResultSet for Non-Existent row");
            } else {
                this.msg.printTestError("executeQuery method does not return an Empty ResultSet for non-existent row", "Call to executeQuery is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeQuery is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeQuery is Failed!");
        }
    }

    public void testExecuteQuery03() throws EETest.Fault {
        ResultSet reSet = null;
        boolean sqlExceptFlag = false;
        try {
            String sSqlStmt = this.sqlp.getProperty("Ins_Coffee_Tab", "");
            this.msg.setMsg("SQL Statement to be executed  :  " + sSqlStmt);
            try {
                this.msg.setMsg("invoking the executeQuery with the Insert statement");
                this.msg.setMsg("Calling executeQuery method ");
                reSet = this.stmt.executeQuery(sSqlStmt);
            }
            catch (SQLException sql) {
                TestUtil.printStackTrace((Throwable)sql);
                sqlExceptFlag = true;
            }
            if (!sqlExceptFlag) {
                this.msg.printTestError("executeQuery method executes an Insert Statement", "Call to executeQuery is Failed!");
            } else {
                this.msg.setMsg("executeQuery method does not execute an Insert Statement");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeQuery is Failed!");
        }
    }

    public void testExecuteUpdate01() throws EETest.Fault {
        int updCount = 0;
        int retRowCount = 0;
        try {
            String sSqlStmt = this.sqlp.getProperty("Upd_Coffee_Tab", "");
            this.msg.setMsg("Update String  : " + sSqlStmt);
            this.msg.setMsg("invoking the executeUpdate method");
            this.msg.setMsg("Calling executeUpdate method ");
            updCount = this.stmt.executeUpdate(sSqlStmt);
            this.msg.setMsg("to get the query which returns number of rows affected");
            String countQuery = this.sqlp.getProperty("Coffee_Updcount_Query", "");
            this.msg.setMsg("Query String :  " + countQuery);
            this.rs = this.stmt.executeQuery(countQuery);
            this.rs.next();
            retRowCount = this.rs.getInt(1);
            this.msg.setMsg("Number of rows in the table with the specified condition  " + retRowCount);
            if (updCount == retRowCount) {
                this.msg.setMsg("executeUpdate executes the SQL Statement ");
            } else {
                this.msg.printTestError("executeUpdate does not execute the SQL Statement ", "Call to executeUpdate is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeUpdate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeUpdate is Failed!");
        }
    }

    public void testExecuteUpdate03() throws EETest.Fault {
        boolean sqlExceptFlag = false;
        int updCount = 0;
        try {
            String sSqlStmt = this.sqlp.getProperty("Sel_Coffee_Tab", "");
            this.msg.setMsg("SQL String of non - existent row  :  " + sSqlStmt);
            try {
                this.msg.setMsg("Calling executeUpdate method ");
                updCount = this.stmt.executeUpdate(sSqlStmt);
            }
            catch (SQLException sqle) {
                TestUtil.printStackTrace((Throwable)sqle);
                sqlExceptFlag = true;
            }
            if (sqlExceptFlag) {
                this.msg.setMsg("executeUpdate does not execute the SQL statement on non-existent row");
            } else {
                this.msg.printTestError("executeUpdate executes the SQL statement on non-existent row", "Call to executeUpdate is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeUpdate is Failed!");
        }
    }

    public void testGetFetchDirection() throws EETest.Fault {
        int fetchDirVal = 0;
        try {
            this.msg.setMsg("Calling getFetchDirection method ");
            fetchDirVal = this.stmt.getFetchDirection();
            if (fetchDirVal == 1000) {
                this.msg.setMsg("getFetchDirection method returns ResultSet.FETCH_FORWARD ");
            } else if (fetchDirVal == 1001) {
                this.msg.setMsg("getFetchDirection method returns ResultSet.FETCH_REVERSE");
            } else if (fetchDirVal == 1002) {
                this.msg.setMsg("getFetchDirection method returns ResultSet.FETCH_UNKNOWN");
            } else {
                this.msg.printTestError(" getFetchDirection method returns a invalid value", "Call to getFetchDirection is Failed");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getFetchDirection is Failed");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getFetchDirection is Failed");
        }
    }

    public void testGetFetchSize() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling getFetchSize on Statement");
            int fetchSizeVal = this.stmt.getFetchSize();
            if (fetchSizeVal >= 0) {
                this.msg.setMsg("getFetchSize method returns :" + fetchSizeVal);
            } else {
                this.msg.printTestError(" getFetchSize method returns a invalid value", "Call to getFetchSize is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getFetchSize is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getFetchSize is Failed!");
        }
    }

    public void testGetMaxFieldSize() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling getMaxFieldSize on Statement");
            int maxFieldSizeVal = this.stmt.getMaxFieldSize();
            if (maxFieldSizeVal >= 0) {
                this.msg.setMsg("getMaxFieldSize method returns :" + maxFieldSizeVal);
            } else {
                this.msg.printTestError(" getMaxFieldSize method returns a invalid value", "Call to getMaxFieldSize is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxFieldSize is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxFieldSize is Failed!");
        }
    }

    public void testGetMaxRows() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling getMaxRows on Statement");
            int maxRowsVal = this.stmt.getMaxRows();
            if (maxRowsVal >= 0) {
                this.msg.setMsg("getMaxRows method returns :" + maxRowsVal);
            } else {
                this.msg.printTestError(" getMaxRows method returns a invalid value", "Call to getMaxRows is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMaxRows is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMaxRows is Failed!");
        }
    }

    public void testGetMoreResults01() throws EETest.Fault {
        try {
            String sSqlStmt = this.sqlp.getProperty("SelCoffeeAll", "");
            this.msg.setMsg("Query String : " + sSqlStmt);
            this.stmt.executeQuery(sSqlStmt);
            this.msg.setMsg("invoke on the getMoreResults");
            this.msg.setMsg("Calling getMoreResults on Statement");
            boolean moreResVal = this.stmt.getMoreResults();
            if (moreResVal || !moreResVal) {
                this.msg.setMsg("getMoreResults method returns :" + moreResVal);
            } else {
                this.msg.printTestError(" getMoreResults method returns a invalid value", "Call to getMoreResults is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMoreResults is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMoreResults is Failed!");
        }
    }

    public void testGetMoreResults02() throws EETest.Fault {
        try {
            String sSqlStmt = this.sqlp.getProperty("SelCoffeeNull", "");
            this.msg.setMsg("Query String : " + sSqlStmt);
            this.stmt.executeQuery(sSqlStmt);
            this.msg.setMsg("Calling getMoreResults on Statement");
            boolean moreResVal = this.stmt.getMoreResults();
            if (!moreResVal) {
                this.msg.setMsg("getMoreResults method returns :" + moreResVal);
            } else {
                this.msg.printTestError(" getMoreResults method returns a invalid value", "Call to getMoreResults is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMoreResults is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMoreResults is Failed!");
        }
    }

    public void testGetMoreResults03() throws EETest.Fault {
        try {
            String sSqlStmt = this.sqlp.getProperty("Upd_Coffee_Tab", "");
            this.msg.setMsg("Query String : " + sSqlStmt);
            this.stmt.executeUpdate(sSqlStmt);
            this.msg.setMsg("invoke on the getMoreResults");
            this.msg.setMsg("Calling getMoreResults on Statement");
            boolean moreResVal = this.stmt.getMoreResults();
            if (!moreResVal) {
                this.msg.setMsg("getMoreResults method returns :" + moreResVal);
            } else {
                this.msg.printTestError(" getMoreResults method returns a invalid value", "Call to getMoreResults is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMoreResults is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMoreResults is Failed!");
        }
    }

    public void testGetQueryTimeout() throws EETest.Fault {
        int queryTimeout = 0;
        try {
            this.msg.setMsg("Calling getQueryTimeout on Statement");
            queryTimeout = this.stmt.getQueryTimeout();
            if (queryTimeout >= 0) {
                this.msg.setMsg("getQueryTimeout method returns :" + queryTimeout);
            } else {
                this.msg.printTestError(" getQueryTimeout method returns a invalid value", "Call to getQueryTimeout is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getQueryTimeout is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getQueryTimeout is Failed!");
        }
    }

    public void testGetResultSet01() throws EETest.Fault {
        ResultSet retResSet = null;
        try {
            String sSqlStmt = this.sqlp.getProperty("SelCoffeeAll", "");
            this.msg.setMsg("Query String :  " + sSqlStmt);
            this.msg.setMsg("Calling getResultSet on Statement");
            this.stmt.executeQuery(sSqlStmt);
            retResSet = this.stmt.getResultSet();
            if (retResSet instanceof ResultSet) {
                this.msg.setMsg("getResultSet method returns a ResultSet object ");
            } else {
                this.msg.printTestError(" getResultSet method does not return a ResultSet object", "Call to getResultSet is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getResultSet is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getResultSet is Failed!");
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            this.dbSch.destroyData(this.conn);
            this.stmt.close();
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

