/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.CommonAsyncHelper;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

@InternalUseOnly
final class AsyncSearchHelper
implements CommonAsyncHelper,
IntermediateResponseListener {
    private static final long serialVersionUID = 1006163445423767824L;
    private final AsyncRequestID asyncRequestID;
    private final AsyncSearchResultListener resultListener;
    private final AtomicBoolean responseReturned;
    private int numEntries;
    private int numReferences;
    private final IntermediateResponseListener intermediateResponseListener;
    private final LDAPConnection connection;
    private final long createTime;

    @InternalUseOnly
    AsyncSearchHelper(LDAPConnection connection, int messageID, AsyncSearchResultListener resultListener, IntermediateResponseListener intermediateResponseListener) {
        this.connection = connection;
        this.resultListener = resultListener;
        this.intermediateResponseListener = intermediateResponseListener;
        this.numEntries = 0;
        this.numReferences = 0;
        this.asyncRequestID = new AsyncRequestID(messageID, connection);
        this.responseReturned = new AtomicBoolean(false);
        this.createTime = System.nanoTime();
    }

    @Override
    public AsyncRequestID getAsyncRequestID() {
        return this.asyncRequestID;
    }

    @Override
    public LDAPConnection getConnection() {
        return this.connection;
    }

    @Override
    public long getCreateTimeNanos() {
        return this.createTime;
    }

    @Override
    public OperationType getOperationType() {
        return OperationType.SEARCH;
    }

    int getNumEntries() {
        return this.numEntries;
    }

    int getNumReferences() {
        return this.numReferences;
    }

    @Override
    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        if (this.responseReturned.get()) {
            return;
        }
        if (response instanceof ConnectionClosedResponse) {
            if (!this.responseReturned.compareAndSet(false, true)) {
                return;
            }
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String ccrMessage = ccr.getMessage();
            String message = ccrMessage == null ? LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE.get() : LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE.get(ccrMessage);
            this.connection.getConnectionStatistics().incrementNumSearchResponses(this.numEntries, this.numReferences, System.nanoTime() - this.createTime);
            SearchResult searchResult = new SearchResult(this.asyncRequestID.getMessageID(), ccr.getResultCode(), message, null, StaticUtils.NO_STRINGS, this.numEntries, this.numReferences, StaticUtils.NO_CONTROLS);
            this.resultListener.searchResultReceived(this.asyncRequestID, searchResult);
            this.asyncRequestID.setResult(searchResult);
        } else if (response instanceof SearchResultEntry) {
            ++this.numEntries;
            this.resultListener.searchEntryReturned((SearchResultEntry)response);
        } else if (response instanceof SearchResultReference) {
            ++this.numReferences;
            this.resultListener.searchReferenceReturned((SearchResultReference)response);
        } else {
            if (!this.responseReturned.compareAndSet(false, true)) {
                return;
            }
            this.connection.getConnectionStatistics().incrementNumSearchResponses(this.numEntries, this.numReferences, System.nanoTime() - this.createTime);
            SearchResult searchResult = (SearchResult)response;
            searchResult.setCounts(this.numEntries, null, this.numReferences, null);
            this.resultListener.searchResultReceived(this.asyncRequestID, searchResult);
            this.asyncRequestID.setResult(searchResult);
        }
    }

    @Override
    @InternalUseOnly
    public void intermediateResponseReturned(IntermediateResponse intermediateResponse) {
        if (this.intermediateResponseListener == null) {
            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(intermediateResponse)));
        } else {
            this.intermediateResponseListener.intermediateResponseReturned(intermediateResponse);
        }
    }
}

