/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.nonpositiveinteger.maxinclusive.maxinclusive_5;

import jakarta.xml.bind.*;
import java.math.BigInteger;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxInclusive5_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxInclusive5_GetSetCTTests test = new maxInclusive5_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "maxInclusive-5-1.xml", "maxInclusive-5-2.xml", "maxInclusive-5-3.xml",
            "maxInclusive-5-4.xml", "maxInclusive-5-5.xml"
        };
        BigInteger[] expectedValues = {new BigInteger("-99999999999999999999"), new BigInteger("-81113958948661291081"), 
                                       new BigInteger("-81378778381038863187"), new BigInteger("-63411255198923788256"), 
                                       new BigInteger("0")};
        BigInteger[] anExpectedValues = {new BigInteger("-99999999999999999998"), new BigInteger("-81113958948661291081"), 
                                         new BigInteger("-81113958948661291081"), new BigInteger("0"), 
                                         new BigInteger("-1")};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<BigInteger> elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocNames[i]);
            if (!elemObj.getValue().equals(expectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (!elemObj.getValue().equals(anExpectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        BigInteger[] setValues = {new BigInteger("-99999999999999999999"), new BigInteger("-81113958948661291081"), 
                                       new BigInteger("-81378778381038863187"), new BigInteger("-63411255198923788256"), 
                                       new BigInteger("0")};
        BigInteger[] anSetValues = {new BigInteger("-99999999999999999998"), new BigInteger("-81113958948661291081"), 
                                         new BigInteger("-81113958948661291081"), new BigInteger("0"), 
                                         new BigInteger("-1")};

        JAXBElement<BigInteger> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNonPositiveIntegerMaxInclusive5(setValues[i]);
            
            if (!elemObj.getValue().equals(setValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (!elemObj.getValue().equals(anSetValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

