/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

/*
 * $Id: FuncMapperELContext.java 65064 2012-02-21 15:28:55Z dougd $
 */

package com.sun.ts.tests.el.common.elcontext;

import com.sun.ts.tests.el.common.elresolver.FunctionELResolver;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import javax.el.ELResolver;
import javax.el.ELContext;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;

/* This ELContext provides only a FunctionMapper implementation and
   an ELResolver that resolves only the functions mapped by the
   FunctionMapper.
 */

public class FuncMapperELContext extends ELContext {

    private final ELResolver elResolver;
    private final FunctionMapper funcMapper;

    /*
     * Constructor.
     */
    public FuncMapperELContext() {
	elResolver = new FunctionELResolver();
	funcMapper = new TCKFunctionMapper();
    }

    public ELResolver getELResolver() {
        return elResolver;
    }

    public VariableMapper getVariableMapper() {
	return null;
    }

    public FunctionMapper getFunctionMapper() {
	return funcMapper;
    }

}
