/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class FileHistory {
    private WeakReference workDirRef;
    private String name;
    private File historyFile;
    private long historyFileLastModified;
    private Vector entries;
    public static final String FILE = "file";
    private static WeakHashMap cache;
    private static final String FILE_HISTORY = "fileHistory";
    private static I18NResourceBundle i18n;

    public static FileHistory getFileHistory(WorkDirectory wd, String name) {
        FileHistory h;
        HashMap<String, FileHistory> map;
        if (cache == null) {
            cache = new WeakHashMap(8);
        }
        if ((map = (HashMap<String, FileHistory>)cache.get(wd)) == null) {
            map = new HashMap<String, FileHistory>(8);
            cache.put(wd, map);
        }
        if ((h = (FileHistory)map.get(name)) == null) {
            h = new FileHistory(wd, name);
            map.put(name, h);
        }
        return h;
    }

    public static FileHistory getFileHistory(File wdFile, String name) {
        if (cache == null) {
            cache = new WeakHashMap(8);
        }
        if (!WorkDirectory.isWorkDirectory(wdFile)) {
            return null;
        }
        Iterator it = cache.keySet().iterator();
        WorkDirectory wd = null;
        while (it.hasNext()) {
            WorkDirectory tempWD = (WorkDirectory)it.next();
            if (!tempWD.getRoot().equals(wdFile)) continue;
            wd = tempWD;
            break;
        }
        if (wd != null) {
            return FileHistory.getFileHistory(wd, name);
        }
        return null;
    }

    public void add(File file) {
        this.ensureEntriesUpToDate();
        file = file.getAbsoluteFile();
        this.entries.remove(file);
        this.entries.add(0, file);
        this.writeEntries();
    }

    public File[] getRecentEntries(int count) {
        this.ensureEntriesUpToDate();
        Vector<File> v = new Vector<File>();
        for (int i = 0; i < this.entries.size() && v.size() < count; ++i) {
            File f = (File)this.entries.elementAt(i);
            if (!f.exists()) continue;
            v.add(f);
        }
        Object[] e = new File[v.size()];
        v.copyInto(e);
        return e;
    }

    public File getLatestEntry() {
        this.ensureEntriesUpToDate();
        for (int i = 0; i < this.entries.size(); ++i) {
            File f = (File)this.entries.elementAt(i);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public File getRelativeLatestEntry(String newRoot, String oldRoot) {
        this.ensureEntriesUpToDate();
        for (int i = 0; i < this.entries.size(); ++i) {
            File toCheck;
            File f = (File)this.entries.elementAt(i);
            if (f.exists()) {
                return f;
            }
            String sf = f.getPath();
            String[] diff = WorkDirectory.getDiffInPaths(newRoot, oldRoot);
            if (diff == null || !(toCheck = new File(diff[0] + sf.substring(diff[1].length()))).exists()) continue;
            return toCheck;
        }
        return null;
    }

    private FileHistory(WorkDirectory workDir, String name) {
        this.workDirRef = new WeakReference<WorkDirectory>(workDir);
        this.name = name;
        this.historyFile = workDir.getSystemFile(name);
    }

    private void ensureEntriesUpToDate() {
        if (this.entries == null || this.historyFile.lastModified() > this.historyFileLastModified) {
            this.readEntries();
        }
    }

    private void readEntries() {
        if (this.entries == null) {
            this.entries = new Vector();
        } else {
            this.entries.clear();
        }
        if (this.historyFile.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(this.historyFile));
                while ((line = br.readLine()) != null) {
                    String p = line.trim();
                    if (p.length() == 0 || p.startsWith("#")) continue;
                    this.entries.add(new File(p));
                }
                br.close();
            }
            catch (IOException e) {
                WorkDirectory workDir = (WorkDirectory)this.workDirRef.get();
                workDir.log(i18n, "fh.cantRead", new Object[]{this.name, e});
            }
            this.historyFileLastModified = this.historyFile.lastModified();
        }
    }

    private void writeEntries() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.historyFile));
            bw.write("# Configuration File History");
            bw.newLine();
            bw.write("# written at " + new Date());
            bw.newLine();
            for (int i = 0; i < this.entries.size(); ++i) {
                bw.write(this.entries.elementAt(i).toString());
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            WorkDirectory workDir = (WorkDirectory)this.workDirRef.get();
            workDir.log(i18n, "fh.cantWrite", new Object[]{this.name, e});
        }
        this.historyFileLastModified = this.historyFile.lastModified();
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(FileHistory.class);
    }

    public static class Listener
    implements MenuListener {
        private FileHistory history;
        private int offset;
        private ActionListener clientListener;

        public Listener(ActionListener l) {
            this(null, -1, l);
        }

        public Listener(int o, ActionListener l) {
            this(null, o, l);
        }

        public Listener(FileHistory h, int o, ActionListener l) {
            this.history = h;
            this.offset = o;
            this.clientListener = l;
        }

        public FileHistory getFileHistory() {
            return this.history;
        }

        public void setFileHistory(FileHistory h) {
            this.history = h;
        }

        @Override
        public void menuSelected(MenuEvent e) {
            File[] entries;
            JMenu menu = (JMenu)e.getSource();
            File[] fileArray = entries = this.history == null ? null : this.history.getRecentEntries(5);
            if (entries == null || entries.length == 0) {
                JMenuItem noEntries = new JMenuItem(i18n.getString("fh.empty"));
                noEntries.putClientProperty(FileHistory.FILE_HISTORY, this);
                noEntries.setEnabled(false);
                if (this.offset < 0) {
                    menu.add(noEntries);
                } else {
                    menu.insert(noEntries, this.offset);
                }
            } else {
                for (int i = 0; i < entries.length; ++i) {
                    JMenuItem mi = new JMenuItem(i + " " + entries[i].getPath());
                    mi.setActionCommand(entries[i].getPath());
                    mi.addActionListener(this.clientListener);
                    mi.putClientProperty(FileHistory.FILE, entries[i]);
                    mi.putClientProperty(FileHistory.FILE_HISTORY, this);
                    mi.setMnemonic(48 + i);
                    if (this.offset < 0) {
                        menu.add(mi);
                        continue;
                    }
                    menu.insert(mi, this.offset + i);
                }
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            this.removeDynamicEntries((JMenu)e.getSource());
        }

        @Override
        public void menuCanceled(MenuEvent e) {
            this.removeDynamicEntries((JMenu)e.getSource());
        }

        private void removeDynamicEntries(JMenu menu) {
            for (int i = menu.getItemCount() - 1; i >= 0; --i) {
                JMenuItem mi = menu.getItem(i);
                if (mi == null || mi.getClientProperty(FileHistory.FILE_HISTORY) != this) continue;
                menu.remove(mi);
            }
        }
    }
}

