/*
 * Copyright (c) 2002-2016 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.HeaderTokenizer;

import java.io.*;
import java.util.Vector;
import javax.mail.*;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.ParseException;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>peek()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.     <p>
 *
 *	Show the next token without actually removing it from the parse stream. <p>
 * api2test: public HeaderTokenizer.Token peek()  <p>
 *
 * how2test: Call API, if it returns HeaderTokenizer.Token object
 *	     values then testcase passes otherwise it fails.
 */

public class peek_Test extends MailTest {

    static boolean return_comments = false;	// return comments as tokens
    static boolean mime = false;		// use MIME specials

    public String value = "ggere, /tmp/mail.out, +mailbox, ~user/mailbox, ~/mailbox, /PN=x400.address/PRMD=ibmmail/ADMD=ibmx400/C=us/@mhs-mci.ebay, C'est bien moche <paris@france>, Mad Genius <george@boole>, two@weeks (It Will Take), /tmp/mail.out, laborious (But Bug Free), cannot@waste (My, Intellectual, Cycles), users:get,what,they,deserve;, it (takes, no (time, at) all), if@you (could, see (almost, as, (badly, you) would) agree), famous <French@physicists>, it@is (brilliant (genius, and) superb), confused (about, being, french)";

    public static void main( String argv[] )
    {
        peek_Test test = new peek_Test();
        Status s = test.run(argv, System.err, System.out);
        s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
        out.println("\nTesting class HeaderTokenizer: peek()\n");

	try {
	   // Create HeaderTokenizer object
	      HeaderTokenizer ht = new HeaderTokenizer(value,
			mime ? HeaderTokenizer.MIME : HeaderTokenizer.RFC822,
			!return_comments);

	      if( ht == null )
		  return Status.failed("Failed to create HeaderTokenizer object!");

	      HeaderTokenizer.Token tok;
	      Vector<HeaderTokenizer.Token> toklist =
					new Vector<HeaderTokenizer.Token>();

	   // BEGIN UNIT TEST 1:
	      out.println("UNIT TEST 1: peek()");

	      while((tok = ht.next()).getType() != HeaderTokenizer.Token.EOF) {
		     toklist.addElement(tok);
		     int pk = (ht.peek()).getType();     // API TEST
	      }

	      for(int i = 0; i < toklist.size(); i++) {
		  tok = toklist.elementAt(i);
		        out.println("\t" + type(tok.getType()) +
					"\t" + tok.getValue());
	      }
	      out.println("UNIT TEST 1: passed.\n");
	   // END UNIT TEST 1:

	      status = Status.passed("OKAY");
	} catch (Exception e) {
	      handlException(e);
	}
	return status;
    }

    private static String type(int t) {
	if (t == HeaderTokenizer.Token.ATOM)
	    return "ATOM";
	else if (t == HeaderTokenizer.Token.QUOTEDSTRING)
	    return "QUOTEDSTRING";
	else if (t == HeaderTokenizer.Token.COMMENT)
	    return "COMMENT";
	else if (t == HeaderTokenizer.Token.EOF)
	    return "EOF";
	else if (t < 0)
	    return "UNKNOWN";
	else
	    return "SPECIAL";
    }

    private static int type(String s) {
	if (s.equals("ATOM"))
	    return HeaderTokenizer.Token.ATOM;
	else if (s.equals("QUOTEDSTRING"))
	    return HeaderTokenizer.Token.QUOTEDSTRING;
	else if (s.equals("COMMENT"))
	    return HeaderTokenizer.Token.COMMENT;
	else if (s.equals("EOF"))
	    return HeaderTokenizer.Token.EOF;
	else // if (s.equals("SPECIAL"))
	    return 0;
    }
}
