/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common;

import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryException;
import org.freebxml.omar.common.BindingUtility;
import org.freebxml.omar.common.CredentialInfo;
import org.freebxml.omar.common.QueryManager;
import org.freebxml.omar.common.QueryManagerFactory;
import org.freebxml.omar.common.RegistryResponseHolder;
import org.freebxml.omar.common.RepositoryItem;
import org.freebxml.omar.common.SOAPMessenger;
import org.freebxml.omar.common.Utility;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryRequest;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryRequestType;
import org.oasis.ebxml.registry.bindings.query.AdhocQueryResponseType;
import org.oasis.ebxml.registry.bindings.query.ResponseOption;
import org.oasis.ebxml.registry.bindings.query.ResponseOptionType;
import org.oasis.ebxml.registry.bindings.query.ReturnType;
import org.oasis.ebxml.registry.bindings.rim.RegistryObjectType;
import org.oasis.ebxml.registry.bindings.rim.UserType;
import org.oasis.ebxml.registry.bindings.rs.RegistryResponseType;

public class QueryManagerLocalProxy
implements QueryManager {
    private QueryManager qm = QueryManagerFactory.getInstance().getQueryManager();
    private UserType callersUser = null;
    private String registryURL = null;
    private CredentialInfo credentialInfo = null;
    private SOAPMessenger msgr = null;

    public QueryManagerLocalProxy(String registryURL, CredentialInfo credentialInfo) {
        this.credentialInfo = credentialInfo;
        this.msgr = new SOAPMessenger(registryURL, credentialInfo);
    }

    public AdhocQueryResponseType submitAdhocQuery(UserType user, AdhocQueryRequestType partAdhocQueryRequest) throws RegistryException {
        return this.qm.submitAdhocQuery(this.getCallersUser(), partAdhocQueryRequest);
    }

    public RegistryObjectType getRegistryObject(String id) throws RegistryException {
        return this.getRegistryObject(id, "RegistryObject");
    }

    public RegistryObjectType getRegistryObject(String id, String typeName) throws RegistryException {
        RegistryObjectType ro = null;
        try {
            typeName = Utility.getInstance().mapTableName(typeName);
            String queryStr = "SELECT * from " + typeName + " WHERE id='" + id + "'";
            AdhocQueryRequest req = BindingUtility.getInstance().createAdhocQueryRequest(queryStr);
            ResponseOption respOption = BindingUtility.getInstance().queryFac.createResponseOption();
            respOption.setReturnComposedObjects(true);
            respOption.setReturnType(ReturnType.LEAF_CLASS_WITH_REPOSITORY_ITEM);
            req.setResponseOption((ResponseOptionType)respOption);
            UserType user = null;
            AdhocQueryResponseType resp = this.submitAdhocQuery(user, (AdhocQueryRequestType)req);
            RegistryResponseHolder respHolder = new RegistryResponseHolder((RegistryResponseType)resp, null);
            List results = respHolder.getCollection();
            if (results.size() == 1) {
                ro = (RegistryObjectType)results.get(0);
            }
        }
        catch (JAXRException e) {
            throw new RegistryException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new RegistryException((Throwable)e);
        }
        return ro;
    }

    public RepositoryItem getRepositoryItem(String id) throws RegistryException {
        RepositoryItem ri = this.qm.getRepositoryItem(id);
        return ri;
    }

    private UserType getCallersUser() throws RegistryException {
        X509Certificate cert = null;
        if (this.credentialInfo != null) {
            cert = this.credentialInfo.cert;
        }
        return this.getUser(cert);
    }

    public UserType getUser(X509Certificate cert) throws RegistryException {
        this.callersUser = this.qm.getUser(cert);
        return this.callersUser;
    }
}

