/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.Security;
import java.util.Enumeration;

public class KeystoreMover {
    public KeystoreMover() {
        Security.addProvider((java.security.Provider)new Provider());
    }

    public static void main(String[] args) throws Throwable {
        KeystoreMover ksm = new KeystoreMover();
        String sourceKeystoreType = "PKCS12";
        String sourceKeystorePath = null;
        String sourceKeystorePassword = null;
        String sourceAlias = null;
        String sourceKeyPassword = null;
        String destinationKeystoreType = "JKS";
        String destinationKeystorePath = null;
        String destinationKeystorePassword = null;
        String destinationAlias = null;
        String destinationKeyPassword = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help")) {
                KeystoreMover.printUsage();
                continue;
            }
            if (args[i].equalsIgnoreCase("-sourceKeystoreType")) {
                sourceKeystoreType = args[++i];
                continue;
            }
            if (args[i].startsWith("-sourceKeystorePath")) {
                sourceKeystorePath = args[++i];
                continue;
            }
            if (args[i].startsWith("-sourceKeystorePassword")) {
                sourceKeystorePassword = args[++i];
                continue;
            }
            if (args[i].startsWith("-sourceAlias")) {
                sourceAlias = args[++i];
                continue;
            }
            if (args[i].startsWith("-sourceKeyPassword")) {
                sourceKeyPassword = args[++i];
                continue;
            }
            if (args[i].startsWith("-destinationKeystoreType")) {
                destinationKeystoreType = args[++i];
                continue;
            }
            if (args[i].startsWith("-destinationKeystorePath")) {
                destinationKeystorePath = args[++i];
                continue;
            }
            if (args[i].startsWith("-destinationKeystorePassword")) {
                destinationKeystorePassword = args[++i];
                continue;
            }
            if (args[i].startsWith("-destinationAlias")) {
                destinationAlias = args[++i];
                continue;
            }
            if (args[i].startsWith("-destinationKeyPassword")) {
                destinationKeyPassword = args[++i];
                continue;
            }
            System.err.println("Unknown parameter: '" + args[i] + "' at position " + i);
            if (i > 0) {
                System.err.println("Last valid parameter was '" + args[i - 1] + "'");
            }
            KeystoreMover.printUsage();
        }
        if (sourceKeystorePath == null) {
            System.err.println("Error: Missing sourceKeystorePath.");
            KeystoreMover.printUsage();
        }
        if (sourceKeystorePassword == null) {
            System.err.println("Error: Missing sourceKeystorePassword.");
            KeystoreMover.printUsage();
        }
        if (destinationKeystorePath == null) {
            System.err.println("Error: Missing destinationKeystorePath.");
            KeystoreMover.printUsage();
        }
        if (destinationKeystorePassword == null) {
            System.err.println("Error: Missing destinationKeystorePassword.");
            KeystoreMover.printUsage();
        }
        try {
            ksm.move(sourceKeystoreType, sourceKeystorePath, sourceKeystorePassword, sourceAlias, sourceKeyPassword, destinationKeystoreType, destinationKeystorePath, destinationKeystorePassword, destinationAlias, destinationKeyPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        System.exit(0);
    }

    private static void printUsage() {
        System.out.println("\nKeystoreMover Usage: \njava KeystoreMove [-sourceKeystoreType JKS|*PKCS12*] -sourceKeystorePath <file> -sourceKeystorePassword <password> [-destinationAlias <if only a specific alias is to be exported.>] [-destinationKeystoreType *JKS*|PKCS12] -destinationKeystorePath <file> -destinationKeystorePassword <password> [-destinationAlias <newAlias default is to keep old alias>]\n");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String sourceKeystoreType, String sourceKeystorePath, String sourceKeystorePassword, String sourceAlias, String sourceKeyPassword, String destinationKeystoreType, String destinationKeystorePath, String destinationKeystorePassword, String destinationAlias, String destinationKeyPassword) throws Exception {
        char[] sourceKeyPasswordArr = null;
        if (sourceKeyPassword != null) {
            sourceKeyPasswordArr = sourceKeyPassword.toCharArray();
        }
        char[] sourceKeystorePasswordArr = null;
        if (sourceKeystorePassword != null) {
            sourceKeystorePasswordArr = sourceKeystorePassword.toCharArray();
        }
        char[] destinationKeystorePasswordArr = null;
        if (destinationKeystorePassword != null) {
            destinationKeystorePasswordArr = destinationKeystorePassword.toCharArray();
        }
        char[] destinationKeyPasswordArr = destinationKeystorePasswordArr;
        if (destinationKeyPassword != null) {
            destinationKeyPasswordArr = destinationKeyPassword.toCharArray();
        }
        FileInputStream in = new FileInputStream(sourceKeystorePath);
        KeyStore ksin = KeyStore.getInstance(sourceKeystoreType);
        ksin.load(in, sourceKeystorePasswordArr);
        in.close();
        KeyStore ksout = KeyStore.getInstance(destinationKeystoreType);
        try {
            in = new FileInputStream(destinationKeystorePath);
            ksout.load(in, destinationKeystorePasswordArr);
        }
        catch (FileNotFoundException e) {
            ksout.load(null, destinationKeystorePasswordArr);
        }
        finally {
            in.close();
        }
        Enumeration<String> en = ksin.aliases();
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            if (sourceAlias != null && !sourceAlias.equalsIgnoreCase(alias)) continue;
            if (ksout.containsAlias(alias)) {
                System.out.println(destinationKeystorePath + " already contains " + alias + "  Key will not be copied.");
                continue;
            }
            if (destinationAlias == null) {
                destinationAlias = alias;
            }
            if (ksin.isCertificateEntry(alias)) {
                System.out.println("importing certificate " + alias);
                ksout.setCertificateEntry(destinationAlias, ksin.getCertificate(alias));
            }
            if (!ksin.isKeyEntry(alias)) continue;
            System.out.println("importing key " + alias);
            ksout.setKeyEntry(destinationAlias, ksin.getKey(alias, sourceKeyPasswordArr), destinationKeyPasswordArr, ksin.getCertificateChain(alias));
        }
        FileOutputStream out = new FileOutputStream(destinationKeystorePath);
        ksout.store(out, destinationKeystorePasswordArr);
        out.close();
        System.out.println("keystore copy successful\n");
    }
}

