/*
 * Copyright (c) 2012, 2015, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: LowerPriorityProvider.java 74330 2015-02-09 12:52:10Z jsupol $ 
 */

package com.sun.ts.tests.jaxrs.api.rs.bindingpriority;

import java.util.concurrent.atomic.AtomicInteger;

import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Response;

import com.sun.ts.lib.harness.EETest.Fault;

@Priority(Integer.MAX_VALUE)
// the lower the number the higher the priority
public class LowerPriorityProvider extends ContextProvider {
	private AtomicInteger counter;

	public LowerPriorityProvider(AtomicInteger counter) {
		super();
		this.counter = counter;
	}

	protected void checkFilterContext(ClientRequestContext context)
			throws Fault {
		assertFault(counter.incrementAndGet() == 2,
				"Lower provider priority has been called as ", counter.get(),
				"st");
		Response response = Response.ok().build();
		context.abortWith(response);
	}
}
