/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: Resource.java 69465 2013-01-11 12:26:32Z supol $ 
 */

package com.sun.ts.tests.jaxrs.api.rs.core.linkbuilder;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import com.sun.ts.tests.jaxrs.common.impl.TRACE;

@Path("resource")
public class Resource {

	@GET
	@Path("get")
	public String get() {
		return "GET";
	}
	
	@DELETE
	@Path("delete")
	public String delete() {
		return "DELETE";
	}	
	
	@TRACE
	@Path("trace")
	public String trace(){
		return "TRACE";
	}

	@GET
	@Produces(MediaType.APPLICATION_SVG_XML)
	@Path("producessvgxml")
	public String producesSvgXml() {
		return MediaType.APPLICATION_SVG_XML;
	}

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("consumesAppJson")
	public String consumesAppJson() {
		return MediaType.APPLICATION_JSON;
	}

	@POST
	@Produces({ MediaType.APPLICATION_XHTML_XML,
			MediaType.APPLICATION_ATOM_XML, MediaType.APPLICATION_SVG_XML })
	@Path("producesxml")
	public String producesXml() {
		return MediaType.APPLICATION_XHTML_XML;
	}

	@POST
	@Consumes(MediaType.APPLICATION_FORM_URLENCODED)
	@Path("consumesform")
	public String consumesForm() {
		return MediaType.APPLICATION_FORM_URLENCODED;
	}

}
