/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */
package com.sun.ts.tests.jaxrs.ee.rs.core.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class CorruptedInputStream extends ByteArrayInputStream {

	AtomicInteger atomic;

	private boolean corrupted = false;
	public static final int CLOSEVALUE = 999;
	public static final String IOETEXT = "CorruptedInputStream tck test IOException";

	public CorruptedInputStream(byte[] buf, AtomicInteger atomic) {
		super(buf);
		this.atomic = atomic;
	}

	@Override
	public void close() throws IOException {
		if (corrupted) {
			atomic.set(CLOSEVALUE);
			throw new IOException(IOETEXT);
		}
		super.close();
	}

	public boolean isCorrupted() {
		return corrupted;
	}

	public void setCorrupted(boolean corrupted) {
		this.corrupted = corrupted;
	}

}
