/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id$
 */

package com.sun.ts.tests.jaxrs.spec.resource.locator;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
public class EntityWriter implements MessageBodyWriter<LocatorEntity> {

	@Override
	public long getSize(LocatorEntity t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return 50;
	}

	@Override
	public boolean isWriteable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return type == LocatorEntity.class;
	}

	@Override
	public void writeTo(LocatorEntity t, Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, Object> httpHeaders,
			OutputStream entityStream) throws IOException,
			WebApplicationException {
		String param;
		entityStream.write("resMatrix=".getBytes());
		param = t.resMatrix == null ? "null" : t.resMatrix;
		entityStream.write(param.getBytes());
		entityStream.write(";subMatrix=".getBytes());
		param = t.subMatrix == null ? "null" : t.subMatrix;
		entityStream.write(param.getBytes());
		entityStream.write(";entity=".getBytes());
		param = t.entity == null ? "null" : t.entity;
		entityStream.write(param.getBytes());
		
	}

}
