package com.sun.ts.lib.deliverable.jaxr;

import com.sun.ts.lib.deliverable.*;
import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.javatest.*;
import java.util.*;
import java.io.*;

/**
 * This class serves as a place for JAXR Deliverable specific info.
 *
 * @author Kyle Grucci
 */
public class JAXRDeliverable extends AbstractDeliverable {

  public PropertyManagerInterface createPropertyManager(TestEnvironment te)
      throws Exception {
    return JAXRPropertyManager.getJAXRPropertyManager(te);
  }

  public PropertyManagerInterface createPropertyManager(Properties p)
      throws Exception {
    return JAXRPropertyManager.getJAXRPropertyManager(p);
  }

  public PropertyManagerInterface getPropertyManager() throws Exception {
    return JAXRPropertyManager.getJAXRPropertyManager();
  }

  public Map getValidVehicles() {
    super.getValidVehicles();
    htTSValidVehicles.put("tests_jaxr.service_eetest.vehicles",
        new String[] { "ejb", "servlet", "jsp", "appclient" });
    return htTSValidVehicles;
  }

  public Map getInteropDirections() {
    super.getInteropDirections();
    return htValidRunDirections;
  }

  public boolean supportsInterop() {
    return false;
  }

  public boolean supportsAutoDeployment() {
    return false;
  }
}
