/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.ee.j2w.document.literal.nosei.client;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import java.io.*;
import java.net.*;
import java.rmi.*;

import javax.xml.ws.*;
import javax.xml.namespace.QName;

import java.util.*;

import com.sun.javatest.Status;

import com.sun.ts.tests.jaxws.common.*;

import javax.naming.InitialContext;

public class Client extends ServiceEETest
{
    // The webserver defaults (overidden by harness properties)
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM  = 8000;

    // The webserver host and port property names (harness properties)
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";

    private static final String PKG_NAME =
		"com.sun.ts.tests.jaxws.ee.j2w.document.literal.nosei.client.";

    private TSURL ctsurl = new TSURL();
    private String hostname = HOSTNAME;
    private int portnum = PORTNUM;

    // URL properties used by the test
    private static final String ENDPOINT_URL	= "j2wdlnosei.endpoint.1";
    private static final String WSDLLOC_URL	= "j2wdlnosei.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;

    // ServiceName and PortName mapping configuration going java-to-wsdl
    private static final String SERVICE_NAME	= "EchoService";
    private static final String PORT_NAME	= "EchoPort";
    private static final String NAMESPACEURI	= "http://echo.org/wsdl";
    private QName SERVICE_QNAME = new QName(NAMESPACEURI, SERVICE_NAME);
    private QName PORT_QNAME = new QName(NAMESPACEURI, PORT_NAME);

    String modeProperty = null;		// platform.mode -> (standalone|javaEE)

    Echo port = null;

    
    static EchoService service = null;

    private void getTestURLs() throws Exception {
	TestUtil.logMsg("Get URL's used by the test");
	String file = JAXWS_Util.getURLFromProp(ENDPOINT_URL);
	url = ctsurl.getURLString(PROTOCOL, hostname, portnum, file);
	file = JAXWS_Util.getURLFromProp(WSDLLOC_URL);
	wsdlurl = ctsurl.getURL(PROTOCOL, hostname, portnum, file);
	TestUtil.logMsg("Service Endpoint URL: " + url);
	TestUtil.logMsg("WSDL Location URL:    " + wsdlurl);
    }

    private void getPortStandalone() throws Exception {
	port = (Echo) JAXWS_Util.getPort(wsdlurl, SERVICE_QNAME, EchoService.class, PORT_QNAME, Echo.class);
	JAXWS_Util.setTargetEndpointAddress(port, url);
    }

    private void getPortJavaEE() throws Exception {
	TestUtil.logMsg("Obtain service via WebServiceRef annotation");
	TestUtil.logMsg("service="+service);
	port = (Echo) service.getPort(Echo.class);
	TestUtil.logMsg("port="+port);
	TestUtil.logMsg("Obtained port");
        getTargetEndpointAddress(port);
        //JAXWS_Util.setTargetEndpointAddress(port, url);
    }

    private void getTargetEndpointAddress(Object port) throws Exception {
	TestUtil.logMsg("Get Target Endpoint Address for port="+port);
        String url = JAXWS_Util.getTargetEndpointAddress(port);
	TestUtil.logMsg("Target Endpoint Address="+url);
    }

    public static void main(String[] args) 
    {
	Client theTests = new Client();
	Status s = theTests.run(args, System.out, System.err);
	s.exit();
    }



/*  Test setup */

  /*
     * @class.testArgs:     -ap jaxws-url-props.dat
   *   @class.setup_props: webServerHost;
   *                       webServerPort;
   *                       platform.mode;
   */

    public void setup(String[] args, Properties p) throws Fault
    {
	   boolean pass = true;

        try {
	    hostname = p.getProperty(WEBSERVERHOSTPROP);
	    if (hostname == null)
		pass = false;
	    else if (hostname.equals(""))
		pass = false;
	    try { 
		portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
	    } catch (Exception e) {
                  TestUtil.printStackTrace(e); 
		pass = false; 
	    }
	    modeProperty = p.getProperty(MODEPROP);
	    if (modeProperty.equals("standalone")) {
	        getTestURLs();
	        getPortStandalone();
	    } else {
             TestUtil.logMsg("WebServiceRef is not set in Client (get it from specific vehicle)");
             service = (EchoService) getSharedObject();
	        getTestURLs();
		   getPortJavaEE();
	    }
        } catch (Exception e) {
	    TestUtil.printStackTrace(e);
	    throw new Fault("setup failed:", e);
        }

	if (!pass) {
	    TestUtil.logErr("Please specify host & port of web server " +
			    "in config properties: " + WEBSERVERHOSTPROP +
			    ", " + WEBSERVERPORTPROP);
	    throw new Fault("setup failed:");
	}
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }

    /*
     *   @testName:  test
     *
     *   @assertion_ids: JAXWS:SPEC:3000; JAXWS:SPEC:3012; JAXWS:SPEC:3036;
     *
     *   @test_Strategy: 
     *
     *   Description
     */
    public void test() throws Fault {
	TestUtil.logMsg("test");
	boolean pass = true;

	if (!stringTest()) pass = false;
	if (!stringArrayTest()) pass = false;

	if (!pass)
	    throw new Fault("test failed");
    }

    public boolean stringTest() throws Fault {
	TestUtil.logMsg("stringTest");
	boolean pass = true;
        String request = "Mary";

	try {
            String response = port.echoString(request);
	    if (!JAXWS_Data.compareValues(request, response, "String"))
		pass = false;
	}
	catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("stringTest failed", e);
	}
	return pass;
    }

    public boolean stringArrayTest() throws Fault {
	TestUtil.logMsg("stringArrayTest");
	boolean pass = true;
        List<String> request = JAXWS_Data.list_String_nonull_data;

	try {
            List<String> response = port.echoStringArray(request);
	    if (!JAXWS_Data.compareArrayValues(request, response, "String"))
		pass = false;
	}
	catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("stringArrayTest failed", e);
	}
	return pass;
    }
}
