/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: J2WRLSharedEndpointImpl.java 62870 2011-05-25 17:40:37Z adf $
 */

package com.sun.ts.tests.jaxws.mapping.j2wmapping.rpc.literal.withannotations;

import javax.xml.ws.WebServiceException;
import javax.xml.ws.BindingType;

import javax.jws.WebService;

@WebService(
    portName="J2WRLSharedEndpointPort",
    serviceName="J2WRLSharedService",
    targetNamespace="http://rpclitservice.org/wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.mapping.j2wmapping.rpc.literal.withannotations.J2WRLSharedEndpoint"
)
@BindingType(value=javax.xml.ws.soap.SOAPBinding.SOAP11HTTP_BINDING)
public class J2WRLSharedEndpointImpl implements J2WRLSharedEndpoint {
    public String oneTwoThree(int one, long two, double three)  {
        return "" + one + ":" + two + ":" + three;
    }

    public String holderMethodDefault(javax.xml.ws.Holder<java.lang.String> varStringDefault) 
    {
	varStringDefault.value = "holderMethodDefault";
	return varStringDefault.value;
    }

    public String holderMethodInOut(javax.xml.ws.Holder<java.lang.String> varStringInOut) 
    {
	varStringInOut.value = "holderMethodInOut";
	return varStringInOut.value;
    }

    public String holderMethodOut(javax.xml.ws.Holder<java.lang.String> varStringOut) 
    {
	varStringOut.value = "holderMethodOut";
	return varStringOut.value;
    }

    public String helloWorld()  {
        return "hello world";
    }

    public String helloWorld(String hello)  {
        return hello;
    }

    public String stringOperation(String param)  {
        return param;
    }

    public String[] arrayOperation()  {
        return new String[] { "one", "two", "three" };
    }

    public J2WRLSharedBean getBean()  {
        return new J2WRLSharedBean(5, "A String");
    }

    public String arrayOperationFromClient(String[] array)  {
        return "success";
    }

    public void oneWayOperation()  {
    }

    public void oneWayOperationWithParams(Integer i, Long l, Double d)  {
    }

    public void operationWithHeaderAndHeaderFaultAndFault(ConfigHeader configheader) throws ConfigHeaderFault, MyFault, MyOtherFault {
    }

    public String hello(String hello)  {
	return hello;
    }

    public String bye(String bye)  {
	return bye;
    }
}
