/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JDLR2747ClientTwo.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.document.literal.R2747;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;

public class W2JDLR2747ClientTwo extends SOAPClient {

    public W2JDLR2747ClientTwo(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
	this(webServerHost, webServerPort, mode, null);
    }

    public W2JDLR2747ClientTwo(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault{
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://w2jdlr2747testservice.org/W2JDLR2747TestService.wsdl");
        stubContext.setService("W2JDLR2747TestService");
        stubContext.setPort("W2JDLR2747TestTwoPort");
        stubContext.setEndpointInterface(W2JDLR2747TestTwo.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.w2jdlr2747.endpoint.2";
    }

    protected String getWSDLURLProperty() {
        return "wsi.w2jdlr2747.wsdlloc.2";
    }

    public String echoString(String str) throws Exception {
        return ((W2JDLR2747TestTwo)stubContext.getStub()).echoString(str);
    }
}
