/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: XMLLangHandler.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R1016;

import com.sun.ts.tests.jaxws.common.Handler_Util;
import com.sun.ts.tests.jaxws.common.Constants;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;

import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.soap.*;
import javax.xml.namespace.QName;
import java.util.Iterator;
import java.util.Set;
import java.util. HashSet;

public class XMLLangHandler implements SOAPHandler<SOAPMessageContext> {

    public Set<QName> getHeaders() {
        return new  HashSet<QName>();
    }

    public void init(java.util.Map<String,Object> config) {
    };

    public boolean handleFault(SOAPMessageContext context) {
        System.out.println("HANDLER: XMLLangHandler.handleFault() BEGIN");
	JAXWS_Util.dumpSOAPMessage(context.getMessage(), false);
        try{
            if (Handler_Util.getDirection(context).equals(Constants.OUTBOUND)) {
	       System.out.println("HANDLER: XMLLangHandler.handleFault() direction=outbound");
               addXMLLangAttribute((SOAPMessageContext)context);
            } else {
               System.out.println("HANDLER: XMLLangHandler.handleFault() direction=inbound");
            }
        }catch(SOAPException se){
            com.sun.ts.lib.util.TestUtil.printStackTrace(se);
        }
        System.out.println("HANDLER: XMLLangHandler.handleFault() END");
        return true;
    };

    public void destroy() {
    };

    public void close(MessageContext context) {
    };

    public boolean handleMessage(SOAPMessageContext context)
    {
        if (Handler_Util.getDirection(context).equals(Constants.OUTBOUND)) {
	   System.out.println("HANDLER: XMLLangHandler.handleMessage() direction=outbound");
        } else {
           System.out.println("HANDLER: XMLLangHandler.handleMessage() direction=inbound");
        }
        return true;
    }

    private void addXMLLangAttribute(SOAPMessageContext context) throws SOAPException{

        Iterator children;
	SOAPElement fault = context.getMessage().getSOAPPart().getEnvelope().getBody().getFault();
	if (fault == null) return;
        children = fault.getChildElements();
        SOAPElement child;
        while(children.hasNext()){
            child = (SOAPElement)children.next();
            if(child.getElementName().getLocalName().equals("faultstring")) {
                child.addAttribute(getXMLLangName(SOAPFactory.newInstance()), "en");
            }
        }
	   context.getMessage().saveChanges();
    }

    private Name getXMLLangName(SOAPFactory factory) throws SOAPException{
        return factory.createName("lang", "xml", "");
    }
}
