/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.id;


import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "DATATYPES")
public class FieldIntId implements java.io.Serializable {

    // ===========================================================
    // instance variables

    @Id
    @Column(name = "ID")
    protected int id;

    @Column(name = "INTDATA")
    private int intData;


    // ===========================================================
    // constructors
    public FieldIntId() {
    }

    public FieldIntId(int id, int intData) {

        this.id = id;
        this.intData = intData;

    }


    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getIntData() {
        return intData;
    }

    public void setIntData(int intData) {
        this.intData = intData;
    }
    @Override
     public String toString() {
         StringBuilder result = new StringBuilder();
         result.append(this.getClass().getSimpleName() + "[");
         result.append("id: " + getId());
         result.append(", int: " + getIntData());
         result.append("]");
         return result.toString();
     }
}
