/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.id;

import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "A_BASIC")
public class PropertyStringId implements java.io.Serializable {

    // ===========================================================
    // instance variables 


    protected String id;
    
    protected String name;
    
    // ===========================================================
    // constructors
    public PropertyStringId() {
    }

    public PropertyStringId(String id, String name) {
        
        this.id = id;
        this.name = name;

    }

    @Id
    public String getId() {
        return id;
    }
    
    public void setId(String id){
        this.id=id;       
    }

    @Basic
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @Override
     public String toString() {
         StringBuilder result = new StringBuilder();
         result.append(this.getClass().getSimpleName() + "[");
         result.append("id: " + getId());
         if (getName() != null){
             result.append(", name: " + getName());
         } else {
             result.append(", name: null");
         }
         result.append("]");
         return result.toString();
     }
}
