/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex5a;

import javax.persistence.*;
import java.io.Serializable;

/**
 *
 * @author Raja Perumal
 */
@Entity
@IdClass(DID5PersonId.class)
public class DID5MedicalHistory implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id
    @JoinColumns({
      @JoinColumn(name="FIRSTNAME", referencedColumnName="FIRSTNAME"),
      @JoinColumn(name="LASTNAME", referencedColumnName="LASTNAME")
    })
    @OneToOne
    private DID5Person patient;
    private String doctorName;

    public DID5MedicalHistory() {
    }

    public DID5MedicalHistory(DID5Person patient, String doctorName) {
        this.patient = patient;
        this.doctorName = doctorName;
    }

    public DID5Person getPatient() {
        return patient;
    }

    public void setPatient(DID5Person patient) {
        this.patient = patient;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (patient != null ? patient.hashCode() : 0);
        return hash;
    }

    public String getDoctorName() {
        return doctorName;
    }

    public void setDoctorName(String doctorName) {
        this.doctorName = doctorName;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DID5MedicalHistory)) {
            return false;
        }
        DID5MedicalHistory other = (DID5MedicalHistory) object;
        if ((this.patient == null && other.patient != null) || (this.patient != null && !this.patient.equals(other.patient))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "derivedpatient5.DID5MedicalHistory[patient=" + patient + "]";
    }
}
