/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: A.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.entitytest.cascadeall.manyXmany;

import com.sun.ts.lib.util.TestUtil;

import javax.persistence.*;
import java.util.Collection;

@Entity
@Table(name="AEJB_MXM_BI_BTOB")
public class A implements java.io.Serializable {


    // ===========================================================
    // instance variables 

    @Id
    protected String id;

    @Basic
    protected String name;

    @Basic
    protected int value;


    // ===========================================================
    // constructors

    public A() {
        TestUtil.logTrace("Entity A no arg constructor");
    }

    public A(String id, String name, int value)
    {
      this.id = id;
      this.name = name;
      this.value = value;
    }

    public A(String id, String name, int value, Collection bCol)
    {
      this.id = id;
      this.name = name;
      this.value = value;
      this.bCol = bCol;
    }

    // ===========================================================
    // relationship fields

    @ManyToMany(targetEntity=com.sun.ts.tests.jpa.core.entitytest.cascadeall.manyXmany.B.class, cascade=CascadeType.ALL, fetch = FetchType.EAGER)
    @JoinTable(name="FKEYS_MXM_BI_BTOB",
    	joinColumns=
        	@JoinColumn(
                	name="FK_FOR_AEJB_MXM_BI_BTOB", referencedColumnName="ID"),
        inverseJoinColumns=
        	@JoinColumn(
                	name="FK_FOR_BEJB_MXM_BI_BTOB", referencedColumnName="ID")
    )
    protected Collection bCol = new java.util.ArrayList();

    // =======================================================================
    // Business methods for test cases


    public Collection getBCol()
    {
        TestUtil.logTrace("getBCol");
	return bCol;
    }

    public void setBCol(Collection bCol)
    {
        TestUtil.logTrace("setBCol");
        this.bCol = bCol;
    }

    public String getAId()
    {   
        return id;
    }

    public String getAName()
    {
        return name;
    }

    public void setAName(String aName)
    {
        this.name = aName;
    }


    public int getAValue()
    {
        return value;
    }


}
