package com.sun.ts.tests.jpa.core.override.mapkey;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.MapKey;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@Entity
public class TheatreCompany implements Serializable {

    @Id
    private Long id;
    private String name;
    @ManyToMany(mappedBy = "company")
    @MapKey(name = "id")
    private Map<String, TheatreLocation> locations = new HashMap<String, TheatreLocation>();

    public TheatreCompany() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int hashCode() {
        int hash = 0;
        hash += (this.getId() != null ? this.getId().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof TheatreCompany)) {
            return false;
        }
        TheatreCompany other = (TheatreCompany) object;
        if (this.getId() != other.getId() && (this.getId() == null ||
                !this.getId().equals(other.getId()))) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "com.sun.ts.tests.jpa.core.override.mapkey." +
                "TheatreCompany[id=" + getId() + "]";
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, TheatreLocation> getLocations() {
        return locations;
    }

    public void setLocations(Map<String, TheatreLocation> locations) {
        this.locations = locations;
    }
}
